/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.cmd.team;

import com.feed_the_beast.ftbl.FTBLibLang;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.cmd.CmdEditConfigBase;
import com.feed_the_beast.ftbl.api.config.ConfigContainer;
import com.feed_the_beast.ftbl.api.config.ConfigGroup;
import com.feed_the_beast.ftbl.net.MessageUpdateTeam;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.google.gson.JsonObject;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class CmdTeamConfig
extends CmdEditConfigBase {
    public CmdTeamConfig() {
        super("config");
    }

    @Override
    public int func_82362_a() {
        return 0;
    }

    @Override
    public ConfigContainer getConfigContainer(ICommandSender sender) throws CommandException {
        EntityPlayerMP ep = CmdTeamConfig.func_71521_c((ICommandSender)sender);
        ForgePlayerMP p = ForgePlayerMP.get(ep);
        if (!p.hasTeam()) {
            throw FTBLibLang.team_no_team.commandError(new Object[0]);
        }
        ForgeTeam team = p.getTeam();
        if (!team.getStatus(p).isOwner()) {
            throw FTBLibLang.team_not_owner.commandError(new Object[0]);
        }
        return new TeamConfigContainer(team);
    }

    public static class TeamConfigContainer
    extends ConfigContainer {
        public final ForgeTeam team;
        public final ConfigGroup group;

        public TeamConfigContainer(ForgeTeam t) {
            super(new ResourceLocation("ftbl", "team_config"));
            this.team = t;
            this.group = new ConfigGroup();
            this.team.getSettings(this.group);
        }

        @Override
        public ConfigGroup createGroup() {
            return this.group;
        }

        @Override
        public ITextComponent getConfigTitle() {
            return FTBLibLang.team_config.textComponent(this.team.getID());
        }

        @Override
        public void saveConfig(ICommandSender sender, NBTTagCompound nbt, JsonObject json) {
            this.group.loadFromGroup(json);
            for (EntityPlayerMP ep : FTBLib.getServer().func_184103_al().func_181057_v()) {
                new MessageUpdateTeam(ForgeWorldMP.inst.getPlayer(ep), this.team).sendTo(null);
            }
        }
    }
}

