/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.gui;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.gui.GuiIcons;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.GuiLang;
import com.feed_the_beast.ftbl.api.client.gui.IClickable;
import com.feed_the_beast.ftbl.api.client.gui.widgets.ButtonLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.PanelLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.SliderLM;
import com.feed_the_beast.ftbl.api.config.ConfigContainer;
import com.feed_the_beast.ftbl.api.config.ConfigEntry;
import com.feed_the_beast.ftbl.api.config.ConfigEntryColor;
import com.feed_the_beast.ftbl.api.config.ConfigEntryDouble;
import com.feed_the_beast.ftbl.api.config.ConfigEntryInt;
import com.feed_the_beast.ftbl.api.config.ConfigEntryString;
import com.feed_the_beast.ftbl.api.config.ConfigEntryType;
import com.feed_the_beast.ftbl.gui.GuiSelectColor;
import com.feed_the_beast.ftbl.gui.GuiSelectField;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.latmod.lib.LMColor;
import com.latmod.lib.io.Bits;
import com.latmod.lib.json.LMJsonUtils;
import com.latmod.lib.util.LMColorUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiEditConfig
extends GuiLM {
    public static final Comparator<Map.Entry<String, ConfigEntry>> COMPARATOR = (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey());
    public final ConfigContainer configContainer;
    public final NBTTagCompound extraNBT;
    public final JsonObject modifiedConfig;
    public final String title;
    public final List<ButtonConfigEntry> configEntryButtons;
    public final PanelLM configPanel;
    public final ButtonLM buttonAccept;
    public final ButtonLM buttonCancel;
    public final SliderLM scroll;
    private int shouldClose = 0;

    public GuiEditConfig(NBTTagCompound nbt, ConfigContainer cc) {
        this.configContainer = cc;
        ITextComponent title0 = this.configContainer.getConfigTitle().func_150259_f();
        title0.func_150256_b().func_150227_a(Boolean.valueOf(true));
        this.title = title0.func_150254_d() + TextFormatting.DARK_GRAY + " [WIP GUI]";
        this.extraNBT = nbt;
        this.modifiedConfig = new JsonObject();
        this.configEntryButtons = new ArrayList<ButtonConfigEntry>();
        ArrayList<Map.Entry<String, ConfigEntry>> list = new ArrayList<Map.Entry<String, ConfigEntry>>();
        list.addAll(this.configContainer.createGroup().getFullEntryMap().entrySet());
        Collections.sort(list, COMPARATOR);
        for (Map.Entry entry : list) {
            if (Bits.getFlag(((ConfigEntry)entry.getValue()).getFlags(), 2)) continue;
            this.configEntryButtons.add(new ButtonConfigEntry((String)entry.getKey(), ((ConfigEntry)entry.getValue()).copy()));
        }
        this.configPanel = new PanelLM(0, 0, 0, 20){

            @Override
            public void addWidgets() {
                this.height = 0.0;
                for (ButtonConfigEntry b : GuiEditConfig.this.configEntryButtons) {
                    b.posY = this.height;
                    this.add(b);
                    this.height += b.height;
                }
            }
        };
        this.buttonAccept = new ButtonLM(0.0, 2.0, 16.0, 16.0, GuiLang.button_accept.translate()){

            @Override
            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiLM.playClickSound();
                GuiEditConfig.this.shouldClose = 1;
                GuiEditConfig.this.closeGui();
            }
        };
        this.buttonCancel = new ButtonLM(0.0, 2.0, 16.0, 16.0, GuiLang.button_cancel.translate()){

            @Override
            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiLM.playClickSound();
                GuiEditConfig.this.shouldClose = 2;
                GuiEditConfig.this.closeGui();
            }
        };
        this.scroll = new SliderLM(-16.0, 20.0, 16.0, 0.0, 10.0){

            @Override
            public boolean canMouseScroll(GuiLM gui) {
                return true;
            }
        };
        this.scroll.isVertical = true;
        this.scroll.displayMax = 0;
        this.scroll.displayMin = 0;
    }

    @Override
    public void onInit() {
        this.setFullscreen();
        this.buttonAccept.posX = this.width - 18.0;
        this.buttonCancel.posX = this.width - 38.0;
        this.scroll.posX = this.width - 16.0;
        this.scroll.height = this.height - 20.0;
        this.configPanel.posY = 20.0;
        this.scroll.value = 0.0;
        for (ButtonConfigEntry b : this.configEntryButtons) {
            b.width = this.width - 16.0;
        }
    }

    @Override
    public void addWidgets() {
        this.configPanel.height = 20.0;
        this.configPanel.width = this.width;
        this.configPanel.posX = 0.0;
        this.configPanel.posY = 20.0;
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void onClosed() {
        if (this.shouldClose > 0 && !this.modifiedConfig.entrySet().isEmpty() && this.shouldClose == 1) {
            this.configContainer.saveConfig((ICommandSender)this.mc.field_71439_g, this.extraNBT, this.modifiedConfig);
        }
    }

    @Override
    public boolean onClosedByKey() {
        this.buttonCancel.onClicked(this, MouseButton.LEFT);
        return false;
    }

    public void onChanged(String id, JsonElement val) {
        this.modifiedConfig.add(id, val);
    }

    @Override
    public void renderWidgets() {
    }

    @Override
    public void drawBackground() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.configPanel.height + 20.0 > this.height) {
            this.scroll.scrollStep = 40.0 / (this.configPanel.height + 20.0);
            this.scroll.update(this);
            this.configPanel.posY = this.scroll.value * (this.height - this.configPanel.height - 20.0) + 20.0;
        } else {
            this.scroll.value = 0.0;
            this.configPanel.posY = 20.0;
        }
        GL11.glEnable((int)3089);
        this.scissor(0.0, 20.0, this.width, this.height - 20.0);
        this.configPanel.renderWidget(this);
        GL11.glDisable((int)3089);
        FTBLibClient.setGLColor(-1724697805);
        GuiEditConfig.drawBlankRect(0.0, 0.0, this.width, 20.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.font.func_78276_b(this.title, 6, 6, -1);
        FTBLibClient.setGLColor(-1724697805);
        GuiEditConfig.drawBlankRect(this.scroll.posX, this.scroll.posY, this.scroll.width, this.scroll.height);
        double sy = this.scroll.posY + this.scroll.value * (this.scroll.height - this.scroll.sliderSize);
        FTBLibClient.setGLColor(-1721342362);
        GuiEditConfig.drawBlankRect(this.scroll.posX, sy, this.scroll.width, this.scroll.sliderSize);
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buttonAccept.render(GuiIcons.accept);
        this.buttonCancel.render(GuiIcons.cancel);
    }

    @Override
    public void onClientDataChanged() {
        this.refreshWidgets();
    }

    public class ButtonConfigEntry
    extends ButtonLM {
        public final String ID;
        public final ConfigEntry entry;

        public ButtonConfigEntry(String id, ConfigEntry e) {
            super(0.0, 0.0, 0.0, 16.0, e.getDisplayName() == null ? id : e.getDisplayName().func_150254_d());
            this.ID = id;
            this.entry = e;
        }

        @Override
        public boolean shouldRender(GuiLM gui) {
            double ay = this.getAY();
            return ay > -this.height && ay < (double)GuiEditConfig.this.screen.func_78328_b();
        }

        @Override
        public void renderWidget(GuiLM gui) {
            boolean mouseOver = GuiEditConfig.this.mouseY >= 20 && gui.isMouseOver(this);
            double ax = this.getAX();
            double ay = this.getAY();
            if (mouseOver) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.13f);
                GuiLM.drawBlankRect(ax, ay, this.width, this.height);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GuiEditConfig.this.font.func_78276_b(this.title, (int)(ax + 4.0), (int)(ay + 4.0), mouseOver ? -1 : -6710887);
            String s = this.entry.getAsString();
            int slen = GuiEditConfig.this.font.func_78256_a(s);
            if (slen > 150) {
                s = GuiEditConfig.this.font.func_78269_a(s, 150) + "...";
                slen = 152;
            }
            int textCol = 0xFF000000 | this.entry.getColor();
            if (mouseOver) {
                textCol = LMColorUtils.addBrightness(textCol, 60);
            }
            if (mouseOver && (double)GuiEditConfig.this.mouseX > ax + this.width - (double)slen - 9.0) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.13f);
                GuiLM.drawBlankRect(ax + this.width - (double)slen - 8.0, ay, slen + 8, this.height);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GuiEditConfig.this.font.func_78276_b(s, GuiEditConfig.this.screen.func_78326_a() - (slen + 20), (int)(ay + 4.0), textCol);
        }

        @Override
        public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
            if (GuiEditConfig.this.mouseY >= 20 && !Bits.getFlag(this.entry.getFlags(), 4)) {
                GuiLM.playClickSound();
                ConfigEntryType type = this.entry.getConfigType();
                if (this.entry instanceof IClickable) {
                    ((IClickable)((Object)this.entry)).onClicked(button);
                    GuiEditConfig.this.onChanged(this.ID, this.entry.func_151003_a());
                } else {
                    switch (type) {
                        case COLOR: {
                            GuiSelectColor.display(null, ((ConfigEntryColor)this.entry).value, (id, val) -> {
                                ((ConfigEntryColor)this.entry).value.set((LMColor)val);
                                GuiEditConfig.this.onChanged(this.ID, this.entry.func_151003_a());
                                GuiEditConfig.this.openGui();
                            });
                            break;
                        }
                        case INT: {
                            GuiSelectField.display(null, GuiSelectField.FieldType.INTEGER, this.entry.getAsInt(), (id, val) -> {
                                ((ConfigEntryInt)this.entry).set((Integer)val);
                                GuiEditConfig.this.onChanged(this.ID, this.entry.func_151003_a());
                                GuiEditConfig.this.openGui();
                            });
                            break;
                        }
                        case DOUBLE: {
                            GuiSelectField.display(null, GuiSelectField.FieldType.DOUBLE, this.entry.getAsDouble(), (id, val) -> {
                                ((ConfigEntryDouble)this.entry).set((Double)val);
                                GuiEditConfig.this.onChanged(this.ID, this.entry.func_151003_a());
                                GuiEditConfig.this.openGui();
                            });
                            break;
                        }
                        case STRING: {
                            GuiSelectField.display(null, GuiSelectField.FieldType.STRING, this.entry.getAsString(), (id, val) -> {
                                ((ConfigEntryString)this.entry).set(val.toString());
                                GuiEditConfig.this.onChanged(this.ID, this.entry.func_151003_a());
                                GuiEditConfig.this.openGui();
                            });
                            break;
                        }
                        case CUSTOM: 
                        case INT_ARRAY: 
                        case STRING_ARRAY: {
                            GuiSelectField.display(null, GuiSelectField.FieldType.STRING, this.entry.func_151003_a().toString(), (id, val) -> {
                                this.entry.func_152753_a(LMJsonUtils.fromJson(val.toString()));
                                GuiEditConfig.this.onChanged(this.ID, this.entry.func_151003_a());
                                GuiEditConfig.this.openGui();
                            });
                        }
                    }
                }
            }
        }

        @Override
        public void addMouseOverText(GuiLM gui, List<String> l) {
            if (GuiEditConfig.this.mouseY > 18) {
                String[] info;
                if ((double)GuiEditConfig.this.mouseX < this.getAX() + (double)GuiEditConfig.this.font.func_78256_a(this.title) + 10.0 && (info = this.entry.getInfo()) != null && info.length > 0) {
                    for (String s : info) {
                        l.addAll(GuiEditConfig.this.font.func_78271_c(s, 230));
                    }
                }
                if (this.entry.getAsGroup() == null && GuiEditConfig.this.mouseX > GuiEditConfig.this.screen.func_78326_a() - (Math.min(150, GuiEditConfig.this.font.func_78256_a(this.entry.getAsString())) + 25)) {
                    String def = this.entry.getDefValueString();
                    String min = this.entry.getMinValueString();
                    String max = this.entry.getMaxValueString();
                    if (def != null) {
                        l.add(TextFormatting.AQUA + "Def: " + def);
                    }
                    if (min != null) {
                        l.add(TextFormatting.AQUA + "Min: " + min);
                    }
                    if (max != null) {
                        l.add(TextFormatting.AQUA + "Max: " + max);
                    }
                }
            }
        }
    }
}

