/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.gui;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.GuiLang;
import com.feed_the_beast.ftbl.api.client.gui.widgets.ButtonLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.SliderLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.WidgetLM;
import com.feed_the_beast.ftbl.util.EnumDyeColorHelper;
import com.feed_the_beast.ftbl.util.TextureCoords;
import com.latmod.lib.LMColor;
import com.latmod.lib.ObjectCallbackHandler;
import com.latmod.lib.math.MathHelperLM;
import com.latmod.lib.util.LMColorUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiSelectColor
extends GuiLM {
    public static final ResourceLocation TEXTURE = new ResourceLocation("ftbl", "textures/gui/colselector.png");
    public static final ResourceLocation TEXTURE_WHEEL = new ResourceLocation("ftbl", "textures/gui/colselector_wheel.png");
    public static final int COL_TEX_W = 29;
    public static final int COL_TEX_H = 16;
    public static final TextureCoords col_tex = new TextureCoords(TEXTURE, 145.0, 10.0, 29.0, 16.0, 256.0, 256.0);
    public static final TextureCoords cursor_tex = new TextureCoords(TEXTURE, 145.0, 36.0, 8.0, 8.0, 256.0, 256.0);
    public static final int SLIDER_W = 6;
    public static final int SLIDER_H = 10;
    public static final int SLIDER_BAR_W = 64;
    public static final TextureCoords slider_tex = new TextureCoords(TEXTURE, 145.0, 26.0, 6.0, 10.0, 256.0, 256.0);
    public static final TextureCoords slider_col_tex = new TextureCoords(TEXTURE, 145.0, 0.0, 64.0, 10.0, 256.0, 256.0);
    public final ObjectCallbackHandler callback;
    public final LMColor.HSB initCol;
    public final Object colorID;
    public final LMColor currentColor;
    public final ButtonLM colorInit;
    public final ButtonLM colorCurrent;
    public final SliderLM sliderRed;
    public final SliderLM sliderGreen;
    public final SliderLM sliderBlue;
    public final SliderLM sliderHue;
    public final SliderLM sliderSaturation;
    public final SliderLM sliderBrightness;
    public final ColorSelector colorSelector;

    public GuiSelectColor(ObjectCallbackHandler cb, LMColor col, Object id) {
        this.callback = cb;
        this.initCol = new LMColor.HSB();
        this.initCol.set(col);
        this.currentColor = new LMColor.RGB();
        this.colorID = id;
        this.width = 143.0;
        this.height = 93.0;
        this.colorInit = new ButtonLM(76.0, 71.0, 29.0, 16.0){

            @Override
            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiSelectColor.this.closeGui(false);
            }

            @Override
            public void addMouseOverText(GuiLM gui, List<String> s) {
                s.add(GuiLang.button_cancel.translate());
                s.add(GuiSelectColor.this.initCol.toString());
            }
        };
        this.colorCurrent = new ButtonLM(109.0, 71.0, 29.0, 16.0){

            @Override
            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiSelectColor.this.closeGui(true);
            }

            @Override
            public void addMouseOverText(GuiLM gui, List<String> s) {
                s.add(GuiLang.button_accept.translate());
                s.add(GuiSelectColor.this.currentColor.toString());
            }
        };
        this.sliderRed = new SliderLM(6.0, 6.0, 64.0, 10.0, 6.0){

            @Override
            public void onMoved(GuiLM gui) {
                GuiSelectColor.this.setColor(new LMColor.RGB((int)(this.value * 255.0), GuiSelectColor.this.currentColor.green(), GuiSelectColor.this.currentColor.blue()));
            }
        };
        this.sliderRed.displayMax = 255;
        this.sliderRed.title = EnumDyeColorHelper.get(EnumDyeColor.RED).toString();
        this.sliderRed.scrollStep = 0.003921568859368563;
        this.sliderGreen = new SliderLM(6.0, 19.0, 64.0, 10.0, 6.0){

            @Override
            public void onMoved(GuiLM gui) {
                GuiSelectColor.this.setColor(new LMColor.RGB(GuiSelectColor.this.currentColor.red(), (int)(this.value * 255.0), GuiSelectColor.this.currentColor.blue()));
            }
        };
        this.sliderGreen.displayMax = 255;
        this.sliderGreen.title = EnumDyeColorHelper.get(EnumDyeColor.GREEN).toString();
        this.sliderGreen.scrollStep = 0.003921568859368563;
        this.sliderBlue = new SliderLM(6.0, 32.0, 64.0, 10.0, 6.0){

            @Override
            public void onMoved(GuiLM gui) {
                GuiSelectColor.this.setColor(new LMColor.RGB(GuiSelectColor.this.currentColor.red(), GuiSelectColor.this.currentColor.green(), (int)(this.value * 255.0)));
            }
        };
        this.sliderBlue.displayMax = 255;
        this.sliderBlue.title = EnumDyeColorHelper.get(EnumDyeColor.BLUE).toString();
        this.sliderBlue.scrollStep = 0.003921568859368563;
        this.sliderHue = new SliderLM(6.0, 51.0, 64.0, 10.0, 6.0){

            @Override
            public void onMoved(GuiLM gui) {
                GuiSelectColor.this.setColor(new LMColor.HSB((float)this.value, GuiSelectColor.this.currentColor.saturation(), GuiSelectColor.this.currentColor.brightness()));
            }
        };
        this.sliderHue.displayMax = 255;
        this.sliderHue.title = "Hue";
        this.sliderHue.scrollStep = 0.003921568859368563;
        this.sliderSaturation = new SliderLM(6.0, 64.0, 64.0, 10.0, 6.0){

            @Override
            public void onMoved(GuiLM gui) {
                GuiSelectColor.this.setColor(new LMColor.HSB(GuiSelectColor.this.currentColor.hue(), (float)this.value, GuiSelectColor.this.currentColor.brightness()));
            }
        };
        this.sliderSaturation.displayMax = 255;
        this.sliderSaturation.title = "Saturation";
        this.sliderSaturation.scrollStep = 0.003921568859368563;
        this.sliderBrightness = new SliderLM(6.0, 77.0, 64.0, 10.0, 6.0){

            @Override
            public void onMoved(GuiLM gui) {
                GuiSelectColor.this.setColor(new LMColor.HSB(GuiSelectColor.this.currentColor.hue(), GuiSelectColor.this.currentColor.saturation(), (float)this.value));
            }
        };
        this.sliderBrightness.displayMax = 255;
        this.sliderBrightness.title = "Brightness";
        this.sliderBrightness.scrollStep = 0.003921568859368563;
        this.colorSelector = new ColorSelector(75, 5, 64, 64);
        this.setColor(this.initCol);
    }

    public static void display(Object id, LMColor col, ObjectCallbackHandler cb) {
        new GuiSelectColor(cb, col, id).openGui();
    }

    @Override
    public void addWidgets() {
        this.add(this.colorInit);
        this.add(this.colorCurrent);
        this.add(this.sliderRed);
        this.add(this.sliderGreen);
        this.add(this.sliderBlue);
        this.add(this.sliderHue);
        this.add(this.sliderSaturation);
        this.add(this.sliderBrightness);
        this.add(this.colorSelector);
    }

    public void setColor(LMColor col) {
        if ((0xFF000000 | this.currentColor.color()) == (0xFF000000 | col.color())) {
            return;
        }
        this.currentColor.set(col);
        this.sliderRed.value = (float)this.currentColor.red() / 255.0f;
        this.sliderGreen.value = (float)this.currentColor.green() / 255.0f;
        this.sliderBlue.value = (float)this.currentColor.blue() / 255.0f;
        this.sliderHue.value = this.currentColor.hue();
        this.sliderSaturation.value = this.currentColor.saturation();
        this.sliderBrightness.value = this.currentColor.brightness();
        this.colorSelector.cursorPosX = Math.cos(this.sliderHue.value * (Math.PI * 2)) * 0.5 * this.sliderSaturation.value + 0.5;
        this.colorSelector.cursorPosY = Math.sin(this.sliderHue.value * (Math.PI * 2)) * 0.5 * this.sliderSaturation.value + 0.5;
    }

    @Override
    public void renderWidgets() {
    }

    @Override
    public void drawBackground() {
        this.sliderRed.update(this);
        this.sliderGreen.update(this);
        this.sliderBlue.update(this);
        this.sliderHue.update(this);
        this.sliderSaturation.update(this);
        this.sliderBrightness.update(this);
        FTBLibClient.setTexture(TEXTURE);
        GuiScreen.func_146110_a((int)((int)this.getAX()), (int)((int)this.getAY()), (float)0.0f, (float)0.0f, (int)((int)this.width), (int)((int)this.height), (float)256.0f, (float)256.0f);
        FTBLibClient.setGLColor(this.initCol.color(), 255);
        this.colorInit.render(col_tex);
        FTBLibClient.setGLColor(this.currentColor.color(), 255);
        this.colorCurrent.render(col_tex);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179103_j((int)7425);
        LMColor col1 = new LMColor.RGB();
        LMColor col2 = new LMColor.RGB();
        col1.setRGBA(0, this.currentColor.green(), this.currentColor.blue(), 255);
        col2.setRGBA(255, this.currentColor.green(), this.currentColor.blue(), 255);
        this.renderSlider(this.sliderRed, col1.color(), col2.color());
        col1.setRGBA(this.currentColor.red(), 0, this.currentColor.blue(), 255);
        col2.setRGBA(this.currentColor.red(), 255, this.currentColor.blue(), 255);
        this.renderSlider(this.sliderGreen, col1.color(), col2.color());
        col1.setRGBA(this.currentColor.red(), this.currentColor.green(), 0, 255);
        col2.setRGBA(this.currentColor.red(), this.currentColor.green(), 255, 255);
        this.renderSlider(this.sliderBlue, col1.color(), col2.color());
        col1 = new LMColor.HSB();
        col2 = new LMColor.HSB();
        col1.setHSB(this.currentColor.hue(), this.currentColor.saturation(), this.currentColor.brightness());
        col2.setHSB(this.currentColor.hue(), this.currentColor.saturation(), this.currentColor.brightness());
        this.renderSlider(this.sliderHue, col1.color(), col2.color());
        col1.setHSB(this.currentColor.hue(), 0.0f, this.currentColor.brightness());
        col2.setHSB(this.currentColor.hue(), 1.0f, this.currentColor.brightness());
        this.renderSlider(this.sliderSaturation, col1.color(), col2.color());
        col1.setHSB(this.currentColor.hue(), this.currentColor.saturation(), 0.0f);
        col2.setHSB(this.currentColor.hue(), this.currentColor.saturation(), 1.0f);
        this.renderSlider(this.sliderBrightness, col1.color(), col2.color());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179103_j((int)7424);
        this.colorSelector.renderWidget(this);
        this.sliderRed.renderSlider(slider_tex);
        this.sliderGreen.renderSlider(slider_tex);
        this.sliderBlue.renderSlider(slider_tex);
        this.sliderHue.renderSlider(slider_tex);
        this.sliderSaturation.renderSlider(slider_tex);
        this.sliderBrightness.renderSlider(slider_tex);
    }

    public void renderSlider(WidgetLM widget, int colLeft, int colRight) {
        double x = widget.getAX();
        double y = widget.getAY();
        double w = widget.width;
        double h = widget.height;
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        int red = LMColorUtils.getRed(colLeft);
        int green = LMColorUtils.getGreen(colLeft);
        int blue = LMColorUtils.getBlue(colLeft);
        buffer.func_181662_b(x, y, 0.0).func_187315_a(GuiSelectColor.slider_col_tex.minU, GuiSelectColor.slider_col_tex.minV).func_181669_b(red, green, blue, 255).func_181675_d();
        buffer.func_181662_b(x, y + h, 0.0).func_187315_a(GuiSelectColor.slider_col_tex.minU, GuiSelectColor.slider_col_tex.maxV).func_181669_b(red, green, blue, 255).func_181675_d();
        red = LMColorUtils.getRed(colRight);
        green = LMColorUtils.getGreen(colRight);
        blue = LMColorUtils.getBlue(colRight);
        buffer.func_181662_b(x + w, y + h, 0.0).func_187315_a(GuiSelectColor.slider_col_tex.maxU, GuiSelectColor.slider_col_tex.maxV).func_181669_b(red, green, blue, 255).func_181675_d();
        buffer.func_181662_b(x + w, y, 0.0).func_187315_a(GuiSelectColor.slider_col_tex.maxU, GuiSelectColor.slider_col_tex.minV).func_181669_b(red, green, blue, 255).func_181675_d();
        tessellator.func_78381_a();
    }

    public void closeGui(boolean set) {
        GuiLM.playClickSound();
        this.callback.onCallback(this.colorID, set ? this.currentColor : this.initCol);
    }

    public class ColorSelector
    extends WidgetLM {
        public boolean grabbed;
        public double cursorPosX;
        public double cursorPosY;

        public ColorSelector(int x, int y, int w, int h) {
            super(x, y, w, h);
            this.grabbed = false;
            this.cursorPosX = 0.0;
            this.cursorPosY = 0.0;
            this.cursorPosY = -1.0;
            this.cursorPosX = -1.0;
        }

        @Override
        public void renderWidget(GuiLM gui) {
            double ax = this.getAX();
            double ay = this.getAY();
            if (this.grabbed && !Mouse.isButtonDown((int)0)) {
                this.grabbed = false;
            }
            if (this.grabbed) {
                this.cursorPosX = ((double)GuiSelectColor.this.mouseX - ax) / this.width;
                this.cursorPosY = ((double)GuiSelectColor.this.mouseY - ay) / this.height;
                double s = MathHelperLM.dist(this.cursorPosX, this.cursorPosY, 0.0, 0.5, 0.5, 0.0) * 2.0;
                if (s > 1.0) {
                    this.cursorPosX = (this.cursorPosX - 0.5) / s + 0.5;
                    this.cursorPosY = (this.cursorPosY - 0.5) / s + 0.5;
                    s = 1.0;
                }
                this.cursorPosX = MathHelperLM.clamp(this.cursorPosX, 0.0, 1.0);
                this.cursorPosY = MathHelperLM.clamp(this.cursorPosY, 0.0, 1.0);
                double h = Math.atan2(this.cursorPosY - 0.5, this.cursorPosX - 0.5) / (Math.PI * 2);
                GuiSelectColor.this.setColor(new LMColor.HSB((float)h, (float)s, (float)GuiSelectColor.this.sliderBrightness.value));
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FTBLibClient.setTexture(TEXTURE_WHEEL);
            GuiLM.drawTexturedRect(ax, ay, this.width, this.height, 0.0, 0.0, 1.0, 1.0);
            if (this.cursorPosX >= 0.0 && this.cursorPosY >= 0.0) {
                GlStateManager.func_179131_c((float)((float)(1.0 - GuiSelectColor.this.sliderRed.value)), (float)((float)(1.0 - GuiSelectColor.this.sliderGreen.value)), (float)((float)(1.0 - GuiSelectColor.this.sliderBlue.value)), (float)1.0f);
                GuiLM.render(cursor_tex, ax + this.cursorPosX * this.width - 2.0, ay + this.cursorPosY * this.height - 2.0, 4.0, 4.0);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        @Override
        public void mousePressed(GuiLM gui, MouseButton b) {
            if (b.isLeft() && gui.isMouseOver(this)) {
                this.grabbed = true;
            }
        }
    }
}

