/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.gui;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.GuiLang;
import com.feed_the_beast.ftbl.api.client.gui.widgets.ButtonSimpleLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.TextBoxLM;
import com.latmod.lib.ObjectCallbackHandler;
import com.latmod.lib.math.Converter;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSelectField
extends GuiLM {
    public final Object ID;
    public final FieldType type;
    public final String def;
    public final ObjectCallbackHandler callback;
    public final ButtonSimpleLM buttonCancel;
    public final ButtonSimpleLM buttonAccept;
    public final TextBoxLM textBox;

    public GuiSelectField(Object id, FieldType typ, String d, ObjectCallbackHandler c) {
        this.ID = id;
        this.type = typ;
        this.def = d;
        this.callback = c;
        this.width = 100.0;
        this.height = 40.0;
        double bsize = this.width / 2.0 - 4.0;
        this.buttonCancel = new ButtonSimpleLM(2.0, this.height - 18.0, bsize, 16.0, GuiLang.button_cancel.translate()){

            @Override
            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiLM.playClickSound();
                GuiSelectField.this.callback.onCallback(GuiSelectField.this.ID, GuiSelectField.this.def);
            }
        };
        this.buttonAccept = new ButtonSimpleLM(this.width - bsize - 2.0, this.height - 18.0, bsize, 16.0, GuiLang.button_accept.translate()){

            @Override
            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiLM.playClickSound();
                if (GuiSelectField.this.textBox.isValid()) {
                    switch (GuiSelectField.this.type) {
                        case STRING: {
                            GuiSelectField.this.callback.onCallback(GuiSelectField.this.ID, GuiSelectField.this.textBox.getText());
                            break;
                        }
                        case INTEGER: {
                            GuiSelectField.this.callback.onCallback(GuiSelectField.this.ID, Integer.parseInt(GuiSelectField.this.textBox.getText()));
                            break;
                        }
                        case DOUBLE: {
                            GuiSelectField.this.callback.onCallback(GuiSelectField.this.ID, Double.parseDouble(GuiSelectField.this.textBox.getText()));
                        }
                    }
                }
            }
        };
        this.textBox = new TextBoxLM(2.0, 2.0, this.width - 4.0, 18.0){

            @Override
            public boolean isValid() {
                return GuiSelectField.this.type.isValid(this.getText());
            }

            @Override
            public void returnPressed() {
                GuiSelectField.this.buttonAccept.onClicked(GuiSelectField.this, MouseButton.LEFT);
            }
        };
        this.textBox.setText(this.def);
        this.textBox.textRenderX = -1.0;
        this.textBox.textRenderY = 6.0;
        this.textBox.textColor = -1118482;
    }

    public static void display(Object id, FieldType type, Object d, ObjectCallbackHandler c) {
        new GuiSelectField(id, type, String.valueOf(d), c).openGui();
    }

    public GuiSelectField setCharLimit(int i) {
        this.textBox.charLimit = i;
        return this;
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonCancel);
        this.add(this.buttonAccept);
        this.add(this.textBox);
    }

    @Override
    public void renderWidgets() {
    }

    @Override
    public void drawBackground() {
        int size = 8 + this.font.func_78256_a(this.textBox.getText());
        if ((double)size > this.width) {
            this.width = size;
            int bsize = size / 2 - 4;
            this.buttonAccept.width = this.buttonCancel.width = (double)bsize;
            this.buttonAccept.posX = this.width - (double)bsize - 2.0;
            this.textBox.width = this.width - 4.0;
            this.initGui();
        }
        GlStateManager.func_179131_c((float)0.4f, (float)0.4f, (float)0.4f, (float)0.66f);
        GuiSelectField.drawBlankRect(this.posX, this.posY, this.width, this.height);
        GlStateManager.func_179131_c((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
        GuiSelectField.drawBlankRect(this.textBox.getAX(), this.textBox.getAY(), this.textBox.width, this.textBox.height);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.buttonAccept.renderWidget(this);
        this.buttonCancel.renderWidget(this);
        this.textBox.renderWidget(this);
    }

    public static enum FieldType {
        STRING,
        INTEGER,
        DOUBLE;


        public boolean isValid(String s) {
            switch (this) {
                case INTEGER: {
                    return Converter.canParseInt(s);
                }
                case DOUBLE: {
                    return Converter.canParseDouble(s);
                }
            }
            return true;
        }
    }
}

