/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.gui.friends;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.ForgePlayerSP;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.guibuttons.ActionButton;
import com.feed_the_beast.ftbl.api.client.gui.guibuttons.ActionButtonRegistry;
import com.feed_the_beast.ftbl.api.info.InfoPage;
import com.feed_the_beast.ftbl.gui.friends.InfoPlayerActionLine;
import com.feed_the_beast.ftbl.gui.friends.InfoPlayerViewLine;
import com.feed_the_beast.ftbl.gui.info.ButtonInfoPage;
import com.feed_the_beast.ftbl.gui.info.GuiInfo;
import com.feed_the_beast.ftbl.net.MessageRequestPlayerInfo;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class InfoFriendsGUIPage
extends InfoPage {
    public final ForgePlayerSP playerLM;

    public InfoFriendsGUIPage(ForgePlayerSP p) {
        super(p.getProfile().getName());
        this.playerLM = p;
    }

    @Override
    public void refreshGui(GuiInfo gui) {
        this.clear();
        this.text.add(new InfoPlayerViewLine((InfoPage)this, this.playerLM));
        if (!this.playerLM.clientInfo.isEmpty()) {
            for (ITextComponent s : this.playerLM.clientInfo) {
                this.println(s);
            }
            this.text.add(null);
        }
        for (ActionButton a : ActionButtonRegistry.getButtons(this.playerLM, true, true)) {
            this.text.add(new InfoPlayerActionLine(this, this.playerLM, a));
        }
    }

    @Override
    public ButtonInfoPage createButton(GuiInfo gui) {
        return new Button(gui, this);
    }

    private class Button
    extends ButtonInfoPage {
        public Button(GuiInfo g, InfoFriendsGUIPage p) {
            super(g, p, null);
            this.height = 20.0;
        }

        @Override
        public void updateTitle(GuiLM gui) {
            this.title = InfoFriendsGUIPage.this.playerLM.getProfile().getName();
            this.hover = null;
            if ((double)this.guiInfo.font.func_78256_a(this.title) > this.width - 24.0) {
                this.hover = this.title + "";
                this.title = this.guiInfo.font.func_78269_a(this.title, (int)this.width - 22) + "...";
            }
        }

        @Override
        public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
            new MessageRequestPlayerInfo(InfoFriendsGUIPage.this.playerLM.getProfile().getId()).sendToServer();
            super.onClicked(gui, button);
        }

        @Override
        public void renderWidget(GuiLM gui) {
            double ay = this.getAY();
            double ax = this.getAX();
            GlStateManager.func_179147_l();
            if (gui.isMouseOver(this)) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                GuiLM.drawBlankRect(ax, ay, this.width, this.height);
            }
            if (ForgeWorldSP.inst.clientPlayer.hasTeam()) {
                EnumTeamStatus status = ForgeWorldSP.inst.clientPlayer.getTeam().getStatus(InfoFriendsGUIPage.this.playerLM);
                FTBLibClient.setGLColor(status == EnumTeamStatus.NONE ? -16777216 : status.color.func_176768_e().field_76291_p, 255);
            } else {
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            GuiLM.drawBlankRect(ax + 1.0, ay + 1.0, 18.0, 18.0);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiLM.drawPlayerHead(InfoFriendsGUIPage.this.playerLM.getProfile().getName(), ax + 2.0, ay + 2.0, 16.0, 16.0);
            this.guiInfo.font.func_78276_b(this.title, (int)ax + 22, (int)ay + 6, -1);
        }
    }
}

