/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.gui.info;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.ButtonLM;
import com.feed_the_beast.ftbl.api.info.InfoPage;
import com.feed_the_beast.ftbl.gui.info.GuiInfo;
import com.feed_the_beast.ftbl.util.TextureCoords;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;

public class ButtonInfoPage
extends ButtonLM {
    public final GuiInfo guiInfo;
    public final InfoPage page;
    public String hover;
    public TextureCoords icon;
    public boolean iconBlur = false;
    private boolean prevMouseOver = false;

    public ButtonInfoPage(GuiInfo g, InfoPage p, TextureCoords t) {
        super(0.0, g.panelPages.height, g.panelWidth - 36, t == null ? 13.0 : 18.0);
        this.guiInfo = g;
        this.page = p;
        this.icon = t;
        this.updateTitle(g);
    }

    public ButtonInfoPage setIconBlur() {
        this.iconBlur = true;
        return this;
    }

    @Override
    public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
        GuiLM.playClickSound();
        this.page.refreshGui(this.guiInfo);
        if (this.page.childPages.isEmpty()) {
            this.guiInfo.selectedPage = this.page;
            this.guiInfo.sliderText.value = 0.0;
            this.guiInfo.panelText.posY = 10.0;
            this.guiInfo.panelText.refreshWidgets();
        } else {
            new GuiInfo(this.guiInfo, this.page).openGui();
        }
    }

    public void updateTitle(GuiLM gui) {
        ITextComponent titleC = this.page.getTitleComponent().func_150259_f();
        if (this.guiInfo.selectedPage == this.page) {
            titleC.func_150256_b().func_150227_a(Boolean.valueOf(true));
        }
        if (gui.isMouseOver(this)) {
            titleC.func_150256_b().func_150228_d(Boolean.valueOf(true));
        }
        this.title = titleC.func_150254_d();
        this.hover = null;
        if ((double)this.guiInfo.font.func_78256_a(this.title) > this.width) {
            this.hover = this.page.getTitleComponent().func_150254_d();
        }
    }

    @Override
    public void addMouseOverText(GuiLM gui, List<String> l) {
        if (this.hover != null) {
            l.add(this.hover);
        }
    }

    @Override
    public boolean shouldRender(GuiLM gui) {
        return this.parentPanel.isInside(this);
    }

    @Override
    public void renderWidget(GuiLM gui) {
        boolean mouseOver = gui.isMouseOver(this);
        if (this.prevMouseOver != mouseOver) {
            this.updateTitle(gui);
            this.prevMouseOver = mouseOver;
        }
        double ay = this.getAY();
        double ax = this.getAX();
        if (this.icon != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            FTBLibClient.setTexture(this.icon.texture);
            if (this.iconBlur) {
                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9729);
                GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
            }
            GuiLM.render(this.icon, ax + 1.0, ay + 1.0, 16.0, 16.0);
            if (this.iconBlur) {
                GlStateManager.func_187421_b((int)3553, (int)10241, (int)9728);
                GlStateManager.func_187421_b((int)3553, (int)10240, (int)9728);
            }
            this.guiInfo.font.func_78276_b(this.title, (int)ax + 19, (int)ay + 6, this.guiInfo.colorText);
        } else {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.guiInfo.font.func_78276_b(this.title, (int)ax + 1, (int)ay + 1, this.guiInfo.colorText);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

