/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.gui.info;

import com.feed_the_beast.ftbl.api.MouseButton;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.gui.GuiLM;
import com.feed_the_beast.ftbl.api.client.gui.GuiLang;
import com.feed_the_beast.ftbl.api.client.gui.IClientActionGui;
import com.feed_the_beast.ftbl.api.client.gui.widgets.ButtonLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.PanelLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.SliderLM;
import com.feed_the_beast.ftbl.api.client.gui.widgets.WidgetLM;
import com.feed_the_beast.ftbl.api.info.InfoPage;
import com.feed_the_beast.ftbl.api.info.InfoPageTheme;
import com.feed_the_beast.ftbl.api.info.InfoTextLine;
import com.feed_the_beast.ftbl.gui.info.ButtonInfoPage;
import com.feed_the_beast.ftbl.gui.info.ButtonInfoTextLine;
import com.feed_the_beast.ftbl.gui.info.InfoClientSettings;
import com.feed_the_beast.ftbl.util.TextureCoords;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiInfo
extends GuiLM
implements IClientActionGui {
    public static final ResourceLocation tex = new ResourceLocation("ftbl", "textures/gui/info.png");
    public static final TextureCoords tex_slider = new TextureCoords(tex, 0.0, 30.0, 12.0, 18.0, 64.0, 64.0);
    public static final TextureCoords tex_back = new TextureCoords(tex, 13.0, 30.0, 14.0, 11.0, 64.0, 64.0);
    public static final TextureCoords tex_close = new TextureCoords(tex, 13.0, 41.0, 14.0, 11.0, 64.0, 64.0);
    public static final TextureCoords tex_bullet = new TextureCoords(tex, 0.0, 49.0, 6.0, 6.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_MU = new TextureCoords(tex, 14.0, 0.0, 1.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_MD = new TextureCoords(tex, 14.0, 16.0, 1.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_ML = new TextureCoords(tex, 0.0, 14.0, 13.0, 1.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_MR = new TextureCoords(tex, 16.0, 14.0, 13.0, 1.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_NN = new TextureCoords(tex, 0.0, 0.0, 13.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_PN = new TextureCoords(tex, 16.0, 0.0, 13.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_NP = new TextureCoords(tex, 0.0, 16.0, 13.0, 13.0, 64.0, 64.0);
    public static final TextureCoords tex_bg_PP = new TextureCoords(tex, 16.0, 16.0, 13.0, 13.0, 64.0, 64.0);
    public final GuiInfo parentGui;
    public final InfoPage page;
    public final String pageTitle;
    public final SliderLM sliderPages;
    public final SliderLM sliderText;
    public final ButtonLM buttonBack;
    public final ButtonLM buttonSpecial;
    public final PanelLM panelPages;
    public final PanelLM panelText;
    public InfoPage selectedPage;
    public int panelWidth;
    public int colorText;
    public int colorBackground;
    public boolean useUnicodeFont;

    public GuiInfo(GuiInfo g, InfoPage c) {
        this.parentGui = g;
        this.page = c;
        this.pageTitle = this.page.getTitleComponent().func_150254_d();
        this.selectedPage = this.page;
        this.sliderPages = new SliderLM(0.0, 0.0, 12.0, 0.0, 18.0){

            @Override
            public boolean canMouseScroll(GuiLM gui) {
                return GuiInfo.this.mouseX < GuiInfo.this.panelWidth;
            }
        };
        this.sliderPages.isVertical = true;
        this.sliderText = new SliderLM(0.0, 0.0, 12.0, 0.0, 18.0){

            @Override
            public boolean canMouseScroll(GuiLM gui) {
                return GuiInfo.this.mouseX > GuiInfo.this.panelWidth;
            }
        };
        this.sliderText.isVertical = true;
        this.buttonBack = new ButtonLM(0.0, 0.0, 14.0, 11.0, this.parentGui == null ? GuiLang.button_close.translate() : GuiLang.button_back.translate()){

            @Override
            public void onClicked(@Nonnull GuiLM gui, @Nonnull MouseButton button) {
                GuiLM.playClickSound();
                if (GuiInfo.this.selectedPage == GuiInfo.this.page || GuiInfo.this.page.getUnformattedText().isEmpty()) {
                    if (GuiInfo.this.parentGui == null) {
                        GuiInfo.this.mc.field_71439_g.func_71053_j();
                    } else {
                        GuiInfo.this.parentGui.selectedPage = GuiInfo.this.parentGui.page;
                        GuiInfo.this.parentGui.sliderText.value = 0.0;
                        GuiInfo.this.parentGui.panelText.posY = 10.0;
                        GuiInfo.this.parentGui.openGui();
                    }
                } else {
                    GuiInfo.this.selectedPage = GuiInfo.this.page;
                    GuiInfo.this.sliderText.value = 0.0;
                    GuiInfo.this.panelText.posY = 10.0;
                    GuiInfo.this.onInit();
                    GuiInfo.this.refreshWidgets();
                }
            }
        };
        this.panelPages = new PanelLM(0, 0, 0, 0){

            @Override
            public void addWidgets() {
                this.height = 0.0;
                for (InfoPage c : GuiInfo.this.page.childPages.values()) {
                    ButtonInfoPage b = c.createButton(GuiInfo.this);
                    if (b == null || !(b.height > 0.0)) continue;
                    this.add(b);
                    this.height += b.height;
                }
            }
        };
        this.panelText = new PanelLM(0, 0, 0, 0){

            @Override
            public void addWidgets() {
                for (WidgetLM w : GuiInfo.this.panelPages.widgets) {
                    ((ButtonInfoPage)w).updateTitle(GuiInfo.this);
                }
                this.height = 0.0;
                boolean uni = GuiInfo.this.font.func_82883_a();
                GuiInfo.this.font.func_78264_a(GuiInfo.this.useUnicodeFont);
                for (InfoTextLine line : GuiInfo.this.selectedPage.text) {
                    ButtonInfoTextLine l = line == null ? new ButtonInfoTextLine(GuiInfo.this, null) : line.createWidget(GuiInfo.this);
                    if (l == null || !(l.height > 0.0)) continue;
                    this.add(l);
                    this.height += l.height + 1.0;
                }
                GuiInfo.this.font.func_78264_a(uni);
                GuiInfo.this.sliderText.scrollStep = 30.0f / (float)this.height;
            }
        };
        this.buttonSpecial = this.page.createSpecialButton(this);
    }

    @Override
    public void addWidgets() {
        this.page.refreshGuiTree(this);
        this.add(this.sliderPages);
        this.add(this.sliderText);
        this.add(this.buttonBack);
        this.add(this.panelPages);
        this.add(this.panelText);
        this.add(this.buttonSpecial);
        this.buttonBack.title = this.parentGui == null ? GuiLang.button_close.translate() : GuiLang.button_back.translate();
    }

    @Override
    public void onInit() {
        this.posX = InfoClientSettings.border_width.getAsInt();
        this.posY = InfoClientSettings.border_height.getAsInt();
        this.width = this.screen.func_78327_c() - (double)(InfoClientSettings.border_width.getAsInt() * 2);
        this.height = this.screen.func_78324_d() - (double)(InfoClientSettings.border_height.getAsInt() * 2);
        this.panelWidth = (int)(this.width * 2.0 / 7.0);
        this.panelPages.posX = 10.0;
        this.panelPages.posY = 46.0;
        this.panelPages.width = this.panelWidth - 20;
        this.panelPages.height = this.height - 56.0;
        this.panelText.posX = this.panelWidth + 10;
        this.panelText.posY = 10.0;
        this.panelText.width = this.width - (double)this.panelWidth - 20.0 - this.sliderText.width;
        this.panelText.height = this.height - 20.0;
        this.sliderPages.posX = (double)this.panelWidth - this.sliderPages.width - 10.0;
        this.sliderPages.posY = 46.0;
        this.sliderPages.height = this.height - 56.0;
        this.sliderText.posY = 10.0;
        this.sliderText.height = this.height - 20.0;
        this.sliderText.posX = this.width - 10.0 - this.sliderText.width;
        this.buttonBack.posX = 12.0;
        this.buttonBack.posY = 12.0;
        InfoPageTheme theme = this.page.getTheme();
        this.colorText = 0xFF000000 | theme.textColor;
        this.colorBackground = 0xFF000000 | theme.backgroundColor;
        this.useUnicodeFont = theme.useUnicodeFont == null ? InfoClientSettings.unicode.getAsBoolean() : theme.useUnicodeFont.booleanValue();
        if (this.buttonSpecial != null) {
            this.buttonSpecial.posX = this.panelWidth - 24;
            this.buttonSpecial.posY = 10.0;
        }
    }

    @Override
    public void renderWidgets() {
    }

    @Override
    public void drawBackground() {
        this.sliderPages.update(this);
        if (this.sliderPages.value == 0.0 || this.panelPages.height - (this.height - 56.0) <= 0.0) {
            this.panelPages.posY = 46.0;
            this.sliderPages.value = 0.0;
        } else {
            this.panelPages.posY = (int)(46.0 - this.sliderPages.value * (this.panelPages.height - (this.height - 56.0)));
        }
        this.sliderText.update(this);
        if (this.sliderText.value == 0.0 || this.panelText.height - (this.height - 20.0) <= 0.0) {
            this.panelText.posY = 10.0;
            this.sliderText.value = 0.0;
        } else {
            this.panelText.posY = (int)(10.0 - this.sliderText.value * (this.panelText.height - (this.height - 20.0)));
        }
        super.drawBackground();
        FTBLibClient.setTexture(tex);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderFilling(this.panelWidth, 0.0, this.width - (double)this.panelWidth, this.height);
        this.renderFilling(0.0, 36.0, this.panelWidth, this.height - 36.0);
        boolean uni = this.font.func_82883_a();
        this.font.func_78264_a(this.useUnicodeFont);
        GL11.glEnable((int)3089);
        this.scissor(this.panelText.getAX(), this.posY + 4.0, this.panelText.width, this.height - 8.0);
        this.panelText.renderWidget(this);
        GL11.glDisable((int)3089);
        this.font.func_78264_a(uni);
        GL11.glEnable((int)3089);
        this.scissor(this.panelPages.getAX(), this.posY + 40.0, this.panelPages.width, this.height - 44.0);
        this.panelPages.renderWidget(this);
        GL11.glDisable((int)3089);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderBorders(this.panelWidth, 0.0, this.width - (double)this.panelWidth, this.height);
        this.renderBorders(0.0, 36.0, this.panelWidth, this.height - 36.0);
        this.renderFilling(0.0, 0.0, this.panelWidth, 36.0);
        this.renderBorders(0.0, 0.0, this.panelWidth, 36.0);
        this.sliderPages.renderSlider(tex_slider);
        this.sliderText.renderSlider(tex_slider);
        FTBLibClient.setGLColor(this.colorText, 255);
        this.buttonBack.render(this.parentGui == null ? tex_close : tex_back);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.buttonSpecial != null) {
            this.buttonSpecial.renderWidget(this);
        }
        this.font.func_78276_b(this.pageTitle, (int)(this.buttonBack.getAX() + this.buttonBack.width + 5.0), (int)(this.posY + 14.0), this.colorText);
    }

    @Override
    public boolean drawDefaultBackground() {
        return false;
    }

    private void renderBorders(double px, double py, double w, double h) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiInfo.render(tex_bg_NN, px += this.posX, py += this.posY, 13.0, 13.0);
        GuiInfo.render(tex_bg_NP, px, py + h - 13.0, 13.0, 13.0);
        GuiInfo.render(tex_bg_PN, px + w - 13.0, py, 13.0, 13.0);
        GuiInfo.render(tex_bg_PP, px + w - 13.0, py + h - 13.0, 13.0, 13.0);
        GuiInfo.render(tex_bg_MU, px + 13.0, py, w - 24.0, 13.0);
        GuiInfo.render(tex_bg_MR, px + w - 13.0, py + 13.0, 13.0, h - 25.0);
        GuiInfo.render(tex_bg_MD, px + 13.0, py + h - 13.0, w - 24.0, 13.0);
        GuiInfo.render(tex_bg_ML, px, py + 13.0, 13.0, h - 25.0);
    }

    private void renderFilling(double px, double py, double w, double h) {
        FTBLibClient.setGLColor(this.colorBackground, 255);
        GuiInfo.drawBlankRect(this.posX + px + 4.0, this.posY + py + 4.0, w - 8.0, h - 8.0);
    }

    @Override
    public void onClientDataChanged() {
        this.refreshWidgets();
    }
}

