/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.api.net.MessageToServer;
import com.feed_the_beast.ftbl.api.tile.TileClientAction;
import com.feed_the_beast.ftbl.api.tile.TileClientActionRegistry;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class MessageClientTileAction
extends MessageToServer<MessageClientTileAction> {
    public int posX;
    public int posY;
    public int posZ;
    public ResourceLocation action;
    public NBTTagCompound data;

    public MessageClientTileAction() {
    }

    public MessageClientTileAction(TileEntity t, TileClientAction a, NBTTagCompound tag) {
        this.posX = t.func_174877_v().func_177958_n();
        this.posY = t.func_174877_v().func_177956_o();
        this.posZ = t.func_174877_v().func_177952_p();
        this.action = a.getResourceLocation();
        this.data = tag;
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    @Override
    public void fromBytes(ByteBuf io) {
        this.posX = io.readInt();
        this.posY = io.readInt();
        this.posZ = io.readInt();
        this.action = MessageClientTileAction.readResourceLocation(io);
        this.data = MessageClientTileAction.readTag(io);
    }

    @Override
    public void toBytes(ByteBuf io) {
        io.writeInt(this.posX);
        io.writeInt(this.posY);
        io.writeInt(this.posZ);
        MessageClientTileAction.writeResourceLocation(io, this.action);
        MessageClientTileAction.writeTag(io, this.data);
    }

    @Override
    public void onMessage(MessageClientTileAction m, EntityPlayerMP ep) {
        TileEntity te;
        TileClientAction action = TileClientActionRegistry.map.get(m.action);
        if (action != null && (te = ep.field_70170_p.func_175625_s(new BlockPos(m.posX, m.posY, m.posZ))) != null) {
            action.onAction(te, m.data, ep);
        }
    }
}

