/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.config.ConfigContainer;
import com.feed_the_beast.ftbl.api.config.ConfigRegistry;
import com.feed_the_beast.ftbl.api.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.api.net.MessageToServer;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class MessageEditConfigResponse
extends MessageToServer<MessageEditConfigResponse> {
    public ResourceLocation id;
    public JsonObject groupData;
    public NBTTagCompound extraNBT;

    public MessageEditConfigResponse() {
    }

    public MessageEditConfigResponse(ResourceLocation r, NBTTagCompound nbt, JsonObject json) {
        this.id = r;
        this.groupData = json;
        this.extraNBT = nbt;
        if (FTBLib.DEV_ENV) {
            FTBLib.dev_logger.info("TX Response: " + this.id + " :: " + this.groupData);
        }
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    @Override
    public void fromBytes(ByteBuf io) {
        this.id = MessageEditConfigResponse.readResourceLocation(io);
        this.groupData = MessageEditConfigResponse.readJsonElement(io).getAsJsonObject();
        this.extraNBT = MessageEditConfigResponse.readTag(io);
    }

    @Override
    public void toBytes(ByteBuf io) {
        MessageEditConfigResponse.writeResourceLocation(io, this.id);
        MessageEditConfigResponse.writeJsonElement(io, (JsonElement)this.groupData);
        MessageEditConfigResponse.writeTag(io, this.extraNBT);
    }

    @Override
    public void onMessage(MessageEditConfigResponse m, EntityPlayerMP ep) {
        ConfigContainer cc = ConfigRegistry.tempServerConfig.get(ep.func_146103_bH().getId());
        if (cc != null && cc.getResourceLocation().equals((Object)m.id)) {
            if (FTBLib.DEV_ENV) {
                FTBLib.dev_logger.info("RX Response: " + m.id + " :: " + m.groupData);
            }
            cc.saveConfig((ICommandSender)ep, m.extraNBT, m.groupData);
            ConfigRegistry.tempServerConfig.remove(ep.func_146103_bH().getId());
        }
    }
}

