/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgePlayerSP;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.api.net.MessageToClient;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import com.feed_the_beast.ftbl.util.JsonHelper;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageLMPlayerInfo
extends MessageToClient<MessageLMPlayerInfo> {
    public UUID playerID;
    public JsonElement[] info;
    public Map<EntityEquipmentSlot, ItemStack> armor;

    public MessageLMPlayerInfo() {
    }

    public MessageLMPlayerInfo(ForgePlayerMP owner, ForgePlayerMP p) {
        this.playerID = p.getProfile().getId();
        ArrayList<ITextComponent> info0 = new ArrayList<ITextComponent>();
        p.getInfo(owner, info0);
        this.info = new JsonElement[Math.min(255, info0.size())];
        for (int i = 0; i < this.info.length; ++i) {
            this.info[i] = JsonHelper.serializeICC((ITextComponent)info0.get(i));
        }
        p.updateArmor();
        this.armor = p.lastArmor;
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    @Override
    public void fromBytes(ByteBuf io) {
        this.playerID = MessageLMPlayerInfo.readUUID(io);
        this.info = new JsonElement[io.readUnsignedByte()];
        for (int i = 0; i < this.info.length; ++i) {
            this.info[i] = MessageLMPlayerInfo.readJsonElement(io);
        }
        this.armor = new HashMap<EntityEquipmentSlot, ItemStack>();
        int s = io.readUnsignedByte();
        for (int i = 0; i < s; ++i) {
            EntityEquipmentSlot e = EntityEquipmentSlot.values()[io.readByte()];
            ItemStack is = ByteBufUtils.readItemStack((ByteBuf)io);
            this.armor.put(e, is);
        }
    }

    @Override
    public void toBytes(ByteBuf io) {
        MessageLMPlayerInfo.writeUUID(io, this.playerID);
        io.writeByte(this.info.length);
        for (JsonElement anInfo : this.info) {
            MessageLMPlayerInfo.writeJsonElement(io, anInfo);
        }
        io.writeByte(this.armor.size());
        for (Map.Entry entry : this.armor.entrySet()) {
            io.writeByte(((EntityEquipmentSlot)entry.getKey()).ordinal());
            ByteBufUtils.writeItemStack((ByteBuf)io, (ItemStack)((ItemStack)entry.getValue()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageLMPlayerInfo m, Minecraft mc) {
        if (ForgeWorldSP.inst == null) {
            return;
        }
        ForgePlayerSP p = ForgeWorldSP.inst.getPlayer(m.playerID).toSP();
        if (p == null) {
            return;
        }
        ArrayList<ITextComponent> info = new ArrayList<ITextComponent>();
        for (int i = 0; i < m.info.length; ++i) {
            info.add(JsonHelper.deserializeICC(m.info[i]));
        }
        p.receiveInfo(info);
        p.lastArmor.clear();
        p.lastArmor.putAll(m.armor);
        FTBLibClient.onGuiClientAction();
    }
}

