/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgePlayerSP;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.api.net.MessageToClient;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageLMPlayerUpdate
extends MessageToClient<MessageLMPlayerUpdate> {
    public UUID playerID;
    public boolean isSelf;
    public NBTTagCompound data;

    public MessageLMPlayerUpdate() {
    }

    public MessageLMPlayerUpdate(ForgePlayerMP p, boolean self) {
        this();
        this.playerID = p.getProfile().getId();
        this.isSelf = self;
        this.data = new NBTTagCompound();
        p.writeToNet(this.data, self);
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    @Override
    public void fromBytes(ByteBuf io) {
        this.playerID = MessageLMPlayerUpdate.readUUID(io);
        this.isSelf = io.readBoolean();
        this.data = ByteBufUtils.readTag((ByteBuf)io);
    }

    @Override
    public void toBytes(ByteBuf io) {
        MessageLMPlayerUpdate.writeUUID(io, this.playerID);
        io.writeBoolean(this.isSelf);
        MessageLMPlayerUpdate.writeTag(io, this.data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageLMPlayerUpdate m, Minecraft mc) {
        ForgePlayerSP p = ForgeWorldSP.inst.getPlayer(m.playerID).toSP();
        p.readFromNet(m.data, m.isSelf);
        FTBLibClient.onGuiClientAction();
    }
}

