/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.FTBLibLang;
import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.PackModes;
import com.feed_the_beast.ftbl.api.events.ForgeWorldEvent;
import com.feed_the_beast.ftbl.api.events.ReloadEvent;
import com.feed_the_beast.ftbl.api.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.api.net.MessageToClient;
import com.feed_the_beast.ftbl.api.notification.ClientNotifications;
import com.feed_the_beast.ftbl.api.notification.Notification;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import com.feed_the_beast.ftbl.util.ReloadType;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageReload
extends MessageToClient<MessageReload> {
    public int typeID;
    public boolean login;
    public NBTTagCompound syncData;
    public NBTTagCompound worldData;

    public MessageReload() {
    }

    public MessageReload(ReloadType t, ForgePlayerMP self, boolean l) {
        this.typeID = t.ordinal();
        this.login = l;
        this.worldData = new NBTTagCompound();
        ForgeWorldMP.inst.writeDataToNet(this.worldData, self, l);
        this.syncData = ForgeWorldEvent.Sync.generateData(self, this.login);
    }

    public static void reloadClient(long ms, ReloadType type, boolean login) {
        if (ms == 0L) {
            ms = System.currentTimeMillis();
        }
        PackModes.reload();
        EntityPlayer ep = FTBLibMod.proxy.getClientPlayer();
        MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent(ForgeWorldSP.inst, (ICommandSender)ep, type, login));
        if (!login) {
            FTBLibLang.reload_client.printChat((ICommandSender)ep, System.currentTimeMillis() - ms + "ms");
        }
        FTBLibMod.logger.info("Current Mode: " + ForgeWorldSP.inst.getMode());
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    @Override
    public void fromBytes(ByteBuf io) {
        this.typeID = io.readUnsignedByte();
        this.login = io.readBoolean();
        this.worldData = MessageReload.readTag(io);
        this.syncData = MessageReload.readTag(io);
    }

    @Override
    public void toBytes(ByteBuf io) {
        io.writeByte(this.typeID);
        io.writeBoolean(this.login);
        MessageReload.writeTag(io, this.worldData);
        MessageReload.writeTag(io, this.syncData);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageReload m, Minecraft mc) {
        long ms = System.currentTimeMillis();
        ReloadType type = ReloadType.values()[m.typeID];
        ForgeWorldSP.inst.readDataFromNet(m.worldData, m.login);
        ForgeWorldEvent.Sync.readData(m.syncData, m.login);
        if (type.reload(Side.CLIENT)) {
            MessageReload.reloadClient(ms, type, m.login);
        } else if (type == ReloadType.SERVER_ONLY_NOTIFY_CLIENT) {
            Notification n = new Notification("reload_client_config");
            n.addText(FTBLibLang.reload_client_config.textComponent(new Object[0]));
            n.addText((ITextComponent)new TextComponentString("/ftb reload_client"));
            n.setTimer(7000);
            n.setColor(-13421773);
            ClientNotifications.add(n);
        }
    }
}

