/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.net;

import com.feed_the_beast.ftbl.api.ForgePlayerMP;
import com.feed_the_beast.ftbl.api.ForgeTeam;
import com.feed_the_beast.ftbl.api.ForgeWorldSP;
import com.feed_the_beast.ftbl.api.net.LMNetworkWrapper;
import com.feed_the_beast.ftbl.api.net.MessageToClient;
import com.feed_the_beast.ftbl.net.FTBLibNetHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageUpdateTeam
extends MessageToClient<MessageUpdateTeam> {
    public String teamID;
    public NBTTagCompound data;

    public MessageUpdateTeam() {
    }

    public MessageUpdateTeam(ForgePlayerMP to, ForgeTeam team) {
        this.teamID = team.getID();
        this.data = team.serializeNBTForNet(to);
    }

    public MessageUpdateTeam(String id) {
        this.teamID = id;
        this.data = null;
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBLibNetHandler.NET;
    }

    @Override
    public void toBytes(ByteBuf io) {
        MessageUpdateTeam.writeString(io, this.teamID);
        MessageUpdateTeam.writeTag(io, this.data);
    }

    @Override
    public void fromBytes(ByteBuf io) {
        this.teamID = MessageUpdateTeam.readString(io);
        this.data = MessageUpdateTeam.readTag(io);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage(MessageUpdateTeam m, Minecraft mc) {
        if (m.data == null) {
            ForgeWorldSP.inst.teams.remove(m.teamID);
        } else {
            ForgeTeam team = (ForgeTeam)ForgeWorldSP.inst.teams.get(m.teamID);
            if (team == null) {
                team = new ForgeTeam(ForgeWorldSP.inst, m.teamID);
                ForgeWorldSP.inst.teams.put(m.teamID, team);
            }
            team.deserializeNBTFromNet(m.data);
        }
    }
}

