/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.util;

import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbl.util.EntityDimPos;
import com.latmod.lib.math.MathHelperLM;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public final class BlockDimPos
extends BlockPos {
    private int dim;

    public BlockDimPos(Vec3i p, int d) {
        super(p);
        this.dim = d;
    }

    public BlockDimPos(int x, int y, int z, int d) {
        super(x, y, z);
        this.dim = d;
    }

    public BlockDimPos(int[] ai) {
        this(ai[0], ai[1], ai[2], ai[3]);
    }

    public int getDim() {
        return this.dim;
    }

    public int[] toIntArray() {
        return new int[]{this.func_177958_n(), this.func_177956_o(), this.func_177952_p(), this.dim};
    }

    public String toString() {
        return "[" + this.dim + '@' + this.func_177958_n() + ',' + this.func_177956_o() + ',' + this.func_177952_p() + ']';
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof BlockPos) {
            if (o instanceof BlockDimPos) {
                return this.equalsPos((BlockDimPos)((Object)o));
            }
            return super.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() * 31 + this.getDim();
    }

    public Vec3d toVec() {
        return new Vec3d((double)this.func_177958_n() + 0.5, (double)this.func_177956_o() + 0.5, (double)this.func_177952_p() + 0.5);
    }

    public EntityDimPos toEntityPos() {
        return new EntityDimPos(this.toVec(), this.getDim());
    }

    public ChunkDimPos toChunkPos() {
        return new ChunkDimPos(this.getDim(), MathHelperLM.chunk(this.func_177958_n()), MathHelperLM.chunk(this.func_177952_p()));
    }

    public BlockDimPos copy() {
        return new BlockDimPos(this.func_177958_n(), this.func_177956_o(), this.func_177952_p(), this.getDim());
    }

    public int chunkX() {
        return MathHelperLM.chunk(this.func_177958_n());
    }

    public int chunkY() {
        return MathHelperLM.chunk(this.func_177956_o());
    }

    public int chunkZ() {
        return MathHelperLM.chunk(this.func_177952_p());
    }

    public boolean equalsPos(BlockDimPos p) {
        return p != null && (p == this || p.getDim() == this.getDim() && p.func_177958_n() == this.func_177958_n() && p.func_177956_o() == this.func_177956_o() && p.func_177952_p() == this.func_177952_p());
    }

    public BlockDimPos offset(EnumFacing facing, int n) {
        return n == 0 ? this : new BlockDimPos(this.func_177958_n() + facing.func_82601_c() * n, this.func_177956_o() + facing.func_96559_d() * n, this.func_177952_p() + facing.func_82599_e() * n, this.getDim());
    }
}

