/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.util;

import com.feed_the_beast.ftbl.FTBLibEventHandler;
import com.feed_the_beast.ftbl.FTBLibLang;
import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.api.ForgeWorldMP;
import com.feed_the_beast.ftbl.api.PackModes;
import com.feed_the_beast.ftbl.api.ServerTickCallback;
import com.feed_the_beast.ftbl.api.config.ConfigRegistry;
import com.feed_the_beast.ftbl.api.config.EnumNameMap;
import com.feed_the_beast.ftbl.api.events.ReloadEvent;
import com.feed_the_beast.ftbl.net.MessageReload;
import com.feed_the_beast.ftbl.util.BroadcastSender;
import com.feed_the_beast.ftbl.util.ReloadType;
import com.google.gson.JsonElement;
import com.latmod.lib.io.LMConnection;
import com.latmod.lib.io.RequestMethod;
import com.latmod.lib.util.LMUtils;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBLib {
    public static final boolean DEV_ENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final Logger dev_logger = LogManager.getLogger((String)"FTBLibDev");
    public static final String FORMATTING = "\u00a7";
    public static final Pattern textFormattingPattern = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public static final Comparator<ResourceLocation> RESOURCE_LOCATION_COMPARATOR = (o1, o2) -> {
        int i = o1.func_110624_b().compareTo(o2.func_110624_b());
        if (i == 0) {
            i = o1.func_110623_a().compareTo(o2.func_110623_a());
        }
        return i;
    };
    public static final EnumNameMap<EnumDyeColor> DYE_COLORS = new EnumNameMap(false, (Enum[])EnumDyeColor.values());
    public static final EnumNameMap<EnumFacing> FACINGS = new EnumNameMap(false, (Enum[])EnumFacing.field_82609_l);
    private static final Map<String, UUID> cachedUUIDs = new HashMap<String, UUID>();
    public static boolean userIsLatvianModder = false;
    public static File folderConfig;
    public static File folderMinecraft;
    public static File folderModpack;
    public static File folderLocal;
    public static File folderWorld;

    public static void init(File configFolder) {
        folderConfig = configFolder;
        folderMinecraft = folderConfig.getParentFile();
        folderModpack = new File(folderMinecraft, "modpack/");
        folderLocal = new File(folderMinecraft, "local/");
        if (!folderModpack.exists()) {
            folderModpack.mkdirs();
        }
        if (!folderLocal.exists()) {
            folderLocal.mkdirs();
        }
        if (dev_logger instanceof org.apache.logging.log4j.core.Logger) {
            if (DEV_ENV) {
                ((org.apache.logging.log4j.core.Logger)dev_logger).setLevel(Level.ALL);
            } else {
                ((org.apache.logging.log4j.core.Logger)dev_logger).setLevel(Level.OFF);
            }
        } else {
            FTBLibMod.logger.info("DevLogger isn't org.apache.logging.log4j.core.Logger! It's " + dev_logger.getClass().getName());
        }
    }

    public static void reload(ICommandSender sender, ReloadType type, boolean login) {
        if (ForgeWorldMP.inst == null) {
            return;
        }
        long ms = System.currentTimeMillis();
        if (type.reload(Side.SERVER)) {
            ConfigRegistry.reload();
            PackModes.reload();
            MinecraftForge.EVENT_BUS.post((Event)new ReloadEvent(ForgeWorldMP.inst, sender, type, login));
        }
        if (!login) {
            if (FTBLib.hasOnlinePlayers()) {
                for (EntityPlayerMP ep : FTBLib.getServer().func_184103_al().func_181057_v()) {
                    new MessageReload(type, ForgeWorldMP.inst.getPlayer(ep), login).sendTo(ep);
                }
            }
            if (type.reload(Side.SERVER)) {
                FTBLibLang.reload_server.printChat(BroadcastSender.inst, System.currentTimeMillis() - ms + "ms");
            }
        }
    }

    public static void addTile(Class<? extends TileEntity> c, ResourceLocation id) {
        if (c != null && id != null) {
            GameRegistry.registerTileEntity(c, (String)id.toString().replace(':', '.'));
        }
    }

    public static void addEntity(Class<? extends Entity> c, String s, int id, Object mod) {
        EntityRegistry.registerModEntity(c, (String)s, (int)id, (Object)mod, (int)50, (int)1, (boolean)true);
    }

    public static void addWorldGenerator(IWorldGenerator i, int w) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)i, (int)w);
    }

    public static Fluid addFluid(Fluid f) {
        Fluid f1 = FluidRegistry.getFluid((String)f.getName());
        if (f1 != null) {
            return f1;
        }
        FluidRegistry.registerFluid((Fluid)f);
        return f;
    }

    public static ITextComponent getChatComponent(Object o) {
        return o instanceof ITextComponent ? (ITextComponent)o : new TextComponentString(String.valueOf(o));
    }

    public static void printChat(ICommandSender ep, Object o) {
        if (ep == null) {
            ep = FTBLibMod.proxy.getClientPlayer();
        }
        if (ep != null) {
            ep.func_145747_a(FTBLib.getChatComponent(o));
        } else {
            FTBLibMod.logger.info(o);
        }
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static Side getEffectiveSide() {
        return FMLCommonHandler.instance().getEffectiveSide();
    }

    public static boolean isDedicatedServer() {
        MinecraftServer mcs = FTBLib.getServer();
        return mcs != null && mcs.func_71262_S();
    }

    public static boolean hasOnlinePlayers() {
        return FTBLib.getServer() != null && !FTBLib.getServer().func_184103_al().func_181057_v().isEmpty();
    }

    public static String removeFormatting(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return "";
        }
        return textFormattingPattern.matcher(s).replaceAll("");
    }

    public static WorldServer getServerWorld() {
        MinecraftServer ms = FTBLib.getServer();
        if (ms == null || ms.field_71305_c.length < 1) {
            return null;
        }
        return ms.field_71305_c[0];
    }

    public static int runCommand(ICommandSender ics, String s) throws CommandException {
        return FTBLib.getServer().func_71187_D().func_71556_a(ics, s);
    }

    public static int runCommand(ICommandSender ics, String cmd, String[] args) throws CommandException {
        StringBuilder sb = new StringBuilder();
        sb.append(cmd);
        if (args != null && args.length > 0) {
            for (String arg : args) {
                sb.append(' ');
                sb.append(arg);
            }
        }
        return FTBLib.runCommand(ics, sb.toString());
    }

    public static void addCallback(ServerTickCallback c) {
        if (c.maxTick == 0) {
            c.onCallback();
        } else {
            FTBLibEventHandler.pendingCallbacks.add(c);
        }
    }

    public static boolean isOP(GameProfile p) {
        return !FTBLib.isDedicatedServer() || p != null && p.getId() != null && FTBLib.getServerWorld() != null && FTBLib.getServer().func_184103_al().func_152603_m().func_187452_a(p) > 0;
    }

    public static Collection<ICommand> getAllCommands(MinecraftServer server, ICommandSender sender) {
        HashSet<ICommand> commands = new HashSet<ICommand>();
        for (ICommand c : server.func_71187_D().func_71555_a().values()) {
            if (!c.func_184882_a(server, sender)) continue;
            commands.add(c);
        }
        return commands;
    }

    public static UUID getPlayerID(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        String key = s.trim().toLowerCase();
        if (!cachedUUIDs.containsKey(key)) {
            cachedUUIDs.put(key, null);
            try {
                JsonElement e = new LMConnection(RequestMethod.GET, "https://api.mojang.com/users/profiles/minecraft/" + s).connect().asJson();
                cachedUUIDs.put(key, LMUtils.fromString(e.getAsJsonObject().get("id").getAsString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cachedUUIDs.get(key);
    }

    public static Boolean canMobSpawn(World world, BlockPos pos) {
        if (world == null || pos == null || pos.func_177956_o() < 0 || pos.func_177956_o() >= 256) {
            return null;
        }
        Chunk chunk = world.func_175726_f(pos);
        if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)pos) || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) >= 8) {
            return null;
        }
        AxisAlignedBB aabb = new AxisAlignedBB((double)pos.func_177958_n() + 0.2, (double)pos.func_177956_o() + 0.01, (double)pos.func_177952_p() + 0.2, (double)pos.func_177958_n() + 0.8, (double)pos.func_177956_o() + 1.8, (double)pos.func_177952_p() + 0.8);
        if (!world.func_72855_b(aabb) || world.func_72953_d(aabb)) {
            return null;
        }
        if (chunk.func_177413_a(EnumSkyBlock.SKY, pos) >= 8) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Entity getEntityByUUID(World worldObj, UUID uuid) {
        if (worldObj == null || uuid == null) {
            return null;
        }
        for (Entity e : worldObj.field_72996_f) {
            if (!e.func_110124_au().equals(uuid)) continue;
            return e;
        }
        return null;
    }

    public static void registerServerTickable(MinecraftServer server, ITickable tickable) {
        try {
            Field field = ReflectionHelper.findField(MinecraftServer.class, (String[])new String[]{"tickables", "field_71322_p"});
            field.setAccessible(true);
            List list = (List)field.get(server);
            list.add(tickable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

