/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.util;

import java.lang.reflect.Field;
import java.util.EnumMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class FTBLibReflection {
    private static EnumMap<EnumDyeColor, TextFormatting> dyeToTextFormattingMap;
    private static EnumMap<TextFormatting, Character> textFormattingToCharMap;
    private static EnumMap<EnumDyeColor, Integer> dyeTextFormattingColorsLight;
    private static EnumMap<EnumDyeColor, Integer> dyeTextFormattingColorsDark;

    public static TextFormatting getFromDyeColor(EnumDyeColor color) {
        if (dyeToTextFormattingMap == null) {
            dyeToTextFormattingMap = new EnumMap(EnumDyeColor.class);
            for (EnumDyeColor col : EnumDyeColor.values()) {
                try {
                    Field field = ReflectionHelper.findField(EnumDyeColor.class, (String[])new String[]{"chatColor", "field_176793_x"});
                    field.setAccessible(true);
                    dyeToTextFormattingMap.put(col, (TextFormatting)field.get(col));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return dyeToTextFormattingMap.get(color);
    }

    public static char getTextFormattingChar(TextFormatting formatting) {
        if (textFormattingToCharMap == null) {
            textFormattingToCharMap = new EnumMap(TextFormatting.class);
            for (TextFormatting f : TextFormatting.values()) {
                try {
                    Field field = ReflectionHelper.findField(TextFormatting.class, (String[])new String[]{"formattingCode", "field_96329_z"});
                    field.setAccessible(true);
                    textFormattingToCharMap.put(f, (Character)field.get(f));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        return textFormattingToCharMap.get(formatting).charValue();
    }

    public static int getDyeColor(EnumDyeColor color, boolean isLighter) {
        if (isLighter) {
            if (dyeTextFormattingColorsLight == null) {
                dyeTextFormattingColorsLight = new EnumMap(EnumDyeColor.class);
                for (EnumDyeColor col : EnumDyeColor.values()) {
                    dyeTextFormattingColorsLight.put(col, GuiUtils.getColorCode((char)FTBLibReflection.getTextFormattingChar(FTBLibReflection.getFromDyeColor(color)), (boolean)true));
                }
            }
            return dyeTextFormattingColorsLight.get(color);
        }
        if (dyeTextFormattingColorsDark == null) {
            dyeTextFormattingColorsDark = new EnumMap(EnumDyeColor.class);
            for (EnumDyeColor col : EnumDyeColor.values()) {
                dyeTextFormattingColorsDark.put(col, GuiUtils.getColorCode((char)FTBLibReflection.getTextFormattingChar(FTBLibReflection.getFromDyeColor(color)), (boolean)false));
            }
        }
        return dyeTextFormattingColorsDark.get(color);
    }
}

