/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.util;

import com.feed_the_beast.ftbl.util.BlockDimPos;
import com.feed_the_beast.ftbl.util.EntityDimPos;
import com.feed_the_beast.ftbl.util.FTBLib;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class LMDimUtils {
    public static boolean teleportPlayer(Entity entity, EntityDimPos pos) {
        return pos != null && LMDimUtils.teleportPlayer(entity, pos.pos, pos.dim);
    }

    public static boolean teleportPlayer(Entity entity, BlockDimPos pos) {
        return pos != null && LMDimUtils.teleportPlayer(entity, pos.toVec(), pos.getDim());
    }

    public static boolean teleportPlayer(Entity entity, Vec3d pos, int dim) {
        EntityPlayerMP player;
        if (entity == null || pos == null) {
            return false;
        }
        entity.field_70143_R = 0.0f;
        EntityPlayerMP entityPlayerMP = player = entity instanceof EntityPlayer ? (EntityPlayerMP)entity : null;
        if (dim == entity.field_71093_bK) {
            if (pos.field_72450_a == entity.field_70165_t && pos.field_72448_b == entity.field_70163_u && pos.field_72449_c == entity.field_70161_v) {
                return true;
            }
            if (player != null) {
                player.field_71135_a.func_147364_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, player.field_70177_z, player.field_70125_A);
                return true;
            }
        }
        int from = entity.field_71093_bK;
        float rotationYaw = entity.field_70177_z;
        float rotationPitch = entity.field_70125_A;
        MinecraftServer server = FTBLib.getServer();
        WorldServer fromDim = server.func_71218_a(from);
        WorldServer toDim = server.func_71218_a(dim);
        if (player != null) {
            server.func_184103_al().transferPlayerToDimension(player, dim, (Teleporter)new TeleporterBlank(toDim));
            if (from == 1 && entity.func_70089_S()) {
                toDim.func_72838_d(entity);
                toDim.func_72866_a(entity, false);
            }
        } else {
            NBTTagCompound tagCompound = new NBTTagCompound();
            entity.func_189511_e(tagCompound);
            Class<?> entityClass = entity.getClass();
            fromDim.func_72900_e(entity);
            try {
                Entity newEntity = (Entity)entityClass.getConstructor(World.class).newInstance(toDim);
                newEntity.func_70020_e(tagCompound);
                newEntity.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, rotationYaw, rotationPitch);
                newEntity.field_98038_p = true;
                toDim.func_72838_d(newEntity);
                newEntity.field_98038_p = false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        entity.field_70143_R = 0.0f;
        entity.field_70177_z = rotationYaw;
        entity.field_70125_A = rotationPitch;
        if (player != null) {
            player.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        } else {
            entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        }
        return true;
    }

    public static World getWorld(int dim) {
        return DimensionManager.getWorld((int)dim);
    }

    public static double getMovementFactor(int dim) {
        switch (dim) {
            case 0: {
                return 1.0;
            }
            case -1: {
                return 8.0;
            }
            case 1: {
                return 1.0;
            }
        }
        World w = LMDimUtils.getWorld(dim);
        return w == null ? 1.0 : w.field_73011_w.getMovementFactor();
    }

    public static BlockDimPos getSpawnPoint(int dim) {
        World w = LMDimUtils.getWorld(dim);
        if (w == null) {
            return null;
        }
        BlockPos c = w.func_175694_M();
        if (c == null) {
            return null;
        }
        return new BlockDimPos((Vec3i)c, dim);
    }

    public static BlockDimPos getPlayerEntitySpawnPoint(EntityPlayerMP ep, int dim) {
        BlockPos c = ep.getBedLocation(dim);
        if (c == null) {
            return LMDimUtils.getSpawnPoint(dim);
        }
        return new BlockDimPos((Vec3i)c, dim);
    }

    private static class TeleporterBlank
    extends Teleporter {
        public TeleporterBlank(WorldServer w) {
            super(w);
        }

        public boolean func_85188_a(Entity e) {
            return true;
        }

        public boolean func_180620_b(Entity e, float f) {
            return true;
        }

        public void func_180266_a(@Nonnull Entity entity, float f) {
            entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70125_A, entity.field_70177_z);
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70143_R = 0.0f;
        }

        public void func_85189_a(long l) {
        }
    }
}

