/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.util;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.feed_the_beast.ftbl.api.block.IBlockLM;
import com.feed_the_beast.ftbl.api.item.IItemLM;
import com.feed_the_beast.ftbl.api.recipes.LMRecipes;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.latmod.lib.FinalIDObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class LMMod
extends FinalIDObject {
    public final String lowerCaseModID = this.getID().toLowerCase();
    public final List<IItemLM> itemsAndBlocks;
    private final String modAssets = this.lowerCaseModID + '.';
    public LMRecipes recipes;
    private ModContainer modContainer;

    public LMMod(String id) {
        super(id);
        this.itemsAndBlocks = new ArrayList<IItemLM>();
        this.recipes = LMRecipes.INSTANCE;
    }

    public static LMMod create(String s) {
        LMMod mod = new LMMod(s);
        if (FTBLib.DEV_ENV) {
            FTBLibMod.logger.info("LMMod '" + mod.getID() + "' created");
        }
        return mod;
    }

    public ModContainer getModContainer() {
        if (this.modContainer == null) {
            this.modContainer = (ModContainer)Loader.instance().getModObjectList().inverse().get((Object)this.getID());
        }
        return this.modContainer;
    }

    public void setRecipes(LMRecipes r) {
        this.recipes = r == null ? new LMRecipes() : r;
    }

    public String getFullID() {
        return this.getID() + '-' + "1.9.4" + '-' + this.modContainer.getDisplayVersion();
    }

    public String getBlockName(String s) {
        return this.modAssets + "tile." + s;
    }

    public String getItemName(String s) {
        return this.modAssets + "item." + s;
    }

    public <K extends IForgeRegistryEntry<?>> K register(String s, K object) {
        object.setRegistryName(new ResourceLocation(this.getID(), s));
        GameRegistry.register(object);
        if (object instanceof IItemLM) {
            this.itemsAndBlocks.add((IItemLM)object);
            if (object instanceof IBlockLM) {
                ItemBlock ib = ((IBlockLM)object).createItemBlock();
                ib.setRegistryName(new ResourceLocation(this.getID(), s));
                GameRegistry.register((IForgeRegistryEntry)ib);
            }
        }
        return object;
    }

    public void onPostLoaded() {
        for (IItemLM i : this.itemsAndBlocks) {
            i.onPostLoaded();
            if (i instanceof IBlockLM) {
                ((IBlockLM)i).loadTiles();
            }
            FTBLibMod.proxy.loadModels(i);
        }
    }

    public void loadRecipes() {
        for (IItemLM i : this.itemsAndBlocks) {
            i.loadRecipes();
        }
        if (this.recipes != null) {
            this.recipes.loadRecipes();
        }
    }
}

