/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.util;

import com.latmod.lib.io.ByteIOStream;
import com.latmod.lib.util.LMFileUtils;
import com.latmod.lib.util.LMListUtils;
import com.latmod.lib.util.LMUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class LMNBTUtils {
    public static String[] getMapKeys(NBTTagCompound tag) {
        if (tag == null || tag.func_82582_d()) {
            return new String[0];
        }
        return LMListUtils.toStringArray(tag.func_150296_c());
    }

    public static Map<String, NBTBase> toMap(NBTTagCompound tag) {
        if (tag == null) {
            return null;
        }
        HashMap<String, NBTBase> map = new HashMap<String, NBTBase>();
        if (tag.func_82582_d()) {
            return map;
        }
        for (String s : tag.func_150296_c()) {
            map.put(s, tag.func_74781_a(s));
        }
        return map;
    }

    public static Set<Map.Entry<String, NBTBase>> entrySet(NBTTagCompound tag) {
        HashSet<Map.Entry<String, NBTBase>> l = new HashSet<Map.Entry<String, NBTBase>>();
        if (tag == null || tag.func_82582_d()) {
            return l;
        }
        for (String s : tag.func_150296_c()) {
            l.add(new AbstractMap.SimpleEntry<String, NBTBase>(s, tag.func_74781_a(s)));
        }
        return l;
    }

    public static Exception writeTag(File f, NBTTagCompound tag) {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)tag, (File)LMFileUtils.newFile(f));
        }
        catch (Exception e) {
            return e;
        }
        return null;
    }

    public static NBTTagCompound readTag(File f) {
        if (f == null || !f.exists()) {
            return null;
        }
        try {
            return CompressedStreamTools.func_74797_a((File)f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean areTagsEqual(NBTTagCompound tag1, NBTTagCompound tag2) {
        if (tag1 == null && tag2 == null) {
            return true;
        }
        if (tag1 != null && tag2 == null) {
            return false;
        }
        return (tag1 != null || tag2 == null) && tag1.equals((Object)tag2);
    }

    public static void toStringList(List<String> l, NBTTagList tag) {
        l.clear();
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            l.add(tag.func_150307_f(i));
        }
    }

    public static List<String> toStringList(NBTTagList tag) {
        ArrayList<String> l = new ArrayList<String>();
        LMNBTUtils.toStringList(l, tag);
        return l;
    }

    public static NBTTagList fromStringList(List<String> l) {
        NBTTagList tag = new NBTTagList();
        for (String s : l) {
            tag.func_74742_a((NBTBase)new NBTTagString(s));
        }
        return tag;
    }

    public static NBTTagCompound readTag(ByteIOStream data) {
        byte i = data.readByte();
        if (i == 0) {
            return null;
        }
        if (i == 1) {
            return new NBTTagCompound();
        }
        try {
            return CompressedStreamTools.func_152456_a((DataInput)data, (NBTSizeTracker)NBTSizeTracker.field_152451_a);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void writeTag(ByteIOStream data, NBTTagCompound tag) {
        data.writeByte(tag == null ? 0 : (tag.func_82582_d() ? 1 : 2));
        try {
            if (tag != null && !tag.func_82582_d()) {
                CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static UUID getUUID(NBTTagCompound tag, String key, boolean string) {
        if (tag == null) {
            return null;
        }
        if (string) {
            return tag.func_74764_b(key) ? LMUtils.fromString(tag.func_74779_i(key)) : null;
        }
        long msb = tag.func_74763_f(key + 'M');
        long lsb = tag.func_74763_f(key + 'L');
        return msb == 0L && lsb == 0L ? null : new UUID(msb, lsb);
    }

    public static void setUUID(NBTTagCompound tag, String key, UUID uuid, boolean string) {
        if (tag == null || key == null || key.isEmpty() || uuid == null) {
            return;
        }
        if (string) {
            tag.func_74778_a(key, LMUtils.fromUUID(uuid));
        } else {
            tag.func_74772_a(key + 'M', uuid.getMostSignificantBits());
            tag.func_74772_a(key + 'L', uuid.getLeastSignificantBits());
        }
    }
}

