/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.util;

import com.feed_the_beast.ftbl.FTBLibMod;
import com.latmod.lib.math.MathHelperLM;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MathHelperMC {
    public static final int[][] connectedTextureMap = new int[][]{{0, 0, 0, 0}, {1, 1, 1, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}, {1, 1, 0, 0}, {0, 1, 1, 0}, {0, 0, 1, 1}, {1, 0, 0, 1}, {0, 1, 1, 1}, {1, 0, 1, 1}, {1, 1, 0, 1}, {1, 1, 1, 0}};

    public static Vec3d getPosVec(BlockPos pos) {
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public static EnumFacing getHorizontalFacing(int index) {
        if (index == 0) {
            return EnumFacing.NORTH;
        }
        if (index == 1) {
            return EnumFacing.EAST;
        }
        if (index == 2) {
            return EnumFacing.SOUTH;
        }
        if (index == 3) {
            return EnumFacing.WEST;
        }
        return null;
    }

    public static int getHorizontalIndex(EnumFacing facing) {
        if (facing == EnumFacing.NORTH) {
            return 0;
        }
        if (facing == EnumFacing.EAST) {
            return 1;
        }
        if (facing == EnumFacing.SOUTH) {
            return 2;
        }
        if (facing == EnumFacing.WEST) {
            return 3;
        }
        return -1;
    }

    public static EnumFacing get2DRotation(EntityLivingBase el) {
        return MathHelperMC.getHorizontalFacing(MathHelperLM.getRotations(el.field_70177_z, 4));
    }

    public static EnumFacing get3DRotation(BlockPos pos, EntityLivingBase el) {
        return BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)el);
    }

    public static EnumFacing getDirection(Vec3i p0, Vec3i p1) {
        if (p0 != null && p1 != null) {
            int x0 = p0.func_177958_n();
            int y0 = p0.func_177956_o();
            int z0 = p0.func_177952_p();
            int x1 = p1.func_177958_n();
            int y1 = p1.func_177956_o();
            int z1 = p1.func_177952_p();
            if (x0 == x1 || y0 == y1 || z0 == z1) {
                if (x0 == x1 && y0 == y1 && z0 == z1) {
                    return null;
                }
                if (x0 != x1) {
                    return x0 > x1 ? EnumFacing.EAST : EnumFacing.WEST;
                }
                if (y0 != y1) {
                    return y0 > y1 ? EnumFacing.UP : EnumFacing.WEST;
                }
                if (z0 != z1) {
                    return z0 > z1 ? EnumFacing.SOUTH : EnumFacing.NORTH;
                }
            }
        }
        return null;
    }

    public static double getDistanceSq(Vec3i p0, Vec3i p1) {
        if (p0 == null || p1 == null) {
            return 0.0;
        }
        return MathHelperLM.distSq(p0.func_177958_n(), p0.func_177956_o(), p0.func_177952_p(), p1.func_177958_n(), p1.func_177956_o(), p1.func_177952_p());
    }

    public static Vec3d randomAABB(Random r, AxisAlignedBB bb) {
        double x = MathHelperLM.randomDouble(r, bb.field_72340_a, bb.field_72336_d);
        double y = MathHelperLM.randomDouble(r, bb.field_72338_b, bb.field_72337_e);
        double z = MathHelperLM.randomDouble(r, bb.field_72339_c, bb.field_72334_f);
        return new Vec3d(x, y, z);
    }

    public static Vec3d getEyePosition(EntityPlayer ep) {
        double y = 0.0;
        if (!ep.field_70170_p.field_72995_K) {
            y = ep.func_70047_e();
        }
        return new Vec3d(ep.field_70165_t, ep.field_70163_u + y, ep.field_70161_v);
    }

    public static RayTraceResult rayTrace(EntityPlayer ep, double d) {
        if (ep == null) {
            return null;
        }
        Vec3d pos = MathHelperMC.getEyePosition(ep);
        Vec3d look = ep.func_70040_Z();
        Vec3d vec = pos.func_72441_c(look.field_72450_a * d, look.field_72448_b * d, look.field_72449_c * d);
        RayTraceResult mop = ep.field_70170_p.func_147447_a(pos, vec, false, true, false);
        if (mop != null && mop.field_72307_f == null) {
            mop.field_72307_f = new Vec3d(0.0, 0.0, 0.0);
        }
        return mop;
    }

    public static RayTraceResult rayTrace(EntityPlayer ep) {
        return MathHelperMC.rayTrace(ep, FTBLibMod.proxy.getReachDist(ep));
    }

    public static RayTraceResult collisionRayTrace(World w, BlockPos blockPos, Vec3d start, Vec3d end, AxisAlignedBB[] boxes) {
        if (boxes == null || boxes.length <= 0) {
            return null;
        }
        RayTraceResult current = null;
        double dist = Double.POSITIVE_INFINITY;
        for (int i = 0; i < boxes.length; ++i) {
            RayTraceResult mop;
            if (boxes[i] == null || (mop = MathHelperMC.collisionRayTrace(w, blockPos, start, end, boxes[i])) == null) continue;
            double d1 = mop.field_72307_f.func_72436_e(start);
            if (current != null && !(d1 < dist)) continue;
            current = mop;
            current.subHit = i;
            dist = d1;
        }
        return current;
    }

    public static RayTraceResult collisionRayTrace(World w, BlockPos blockPos, Vec3d start, Vec3d end, List<AxisAlignedBB> boxes) {
        AxisAlignedBB[] boxesa = new AxisAlignedBB[boxes.size()];
        for (int i = 0; i < boxesa.length; ++i) {
            boxesa[i] = boxes.get(i).func_72321_a(0.0, 0.0, 0.0);
        }
        return MathHelperMC.collisionRayTrace(w, blockPos, start, end, boxesa);
    }

    public static RayTraceResult collisionRayTrace(World w, BlockPos blockPos, Vec3d start, Vec3d end, AxisAlignedBB aabb) {
        Vec3d pos = start.func_72441_c((double)(-blockPos.func_177958_n()), (double)(-blockPos.func_177956_o()), (double)(-blockPos.func_177952_p()));
        Vec3d rot = end.func_72441_c((double)(-blockPos.func_177958_n()), (double)(-blockPos.func_177956_o()), (double)(-blockPos.func_177952_p()));
        Vec3d xmin = pos.func_72429_b(rot, aabb.field_72340_a);
        Vec3d xmax = pos.func_72429_b(rot, aabb.field_72336_d);
        Vec3d ymin = pos.func_72435_c(rot, aabb.field_72338_b);
        Vec3d ymax = pos.func_72435_c(rot, aabb.field_72337_e);
        Vec3d zmin = pos.func_72434_d(rot, aabb.field_72339_c);
        Vec3d zmax = pos.func_72434_d(rot, aabb.field_72334_f);
        if (!MathHelperMC.isVecInsideYZBounds(xmin, aabb)) {
            xmin = null;
        }
        if (!MathHelperMC.isVecInsideYZBounds(xmax, aabb)) {
            xmax = null;
        }
        if (!MathHelperMC.isVecInsideXZBounds(ymin, aabb)) {
            ymin = null;
        }
        if (!MathHelperMC.isVecInsideXZBounds(ymax, aabb)) {
            ymax = null;
        }
        if (!MathHelperMC.isVecInsideXYBounds(zmin, aabb)) {
            zmin = null;
        }
        if (!MathHelperMC.isVecInsideXYBounds(zmax, aabb)) {
            zmax = null;
        }
        Vec3d v = null;
        if (xmin != null && (v == null || pos.func_72436_e(xmin) < pos.func_72436_e(v))) {
            v = xmin;
        }
        if (xmax != null && (v == null || pos.func_72436_e(xmax) < pos.func_72436_e(v))) {
            v = xmax;
        }
        if (ymin != null && (v == null || pos.func_72436_e(ymin) < pos.func_72436_e(v))) {
            v = ymin;
        }
        if (ymax != null && (v == null || pos.func_72436_e(ymax) < pos.func_72436_e(v))) {
            v = ymax;
        }
        if (zmin != null && (v == null || pos.func_72436_e(zmin) < pos.func_72436_e(v))) {
            v = zmin;
        }
        if (zmax != null && (v == null || pos.func_72436_e(zmax) < pos.func_72436_e(v))) {
            v = zmax;
        }
        if (v == null) {
            return null;
        }
        EnumFacing side = null;
        if (v == xmin) {
            side = EnumFacing.WEST;
        }
        if (v == xmax) {
            side = EnumFacing.EAST;
        }
        if (v == ymin) {
            side = EnumFacing.DOWN;
        }
        if (v == ymax) {
            side = EnumFacing.UP;
        }
        if (v == zmin) {
            side = EnumFacing.NORTH;
        }
        if (v == zmax) {
            side = EnumFacing.SOUTH;
        }
        return new RayTraceResult(v.func_72441_c((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), side, blockPos);
    }

    private static boolean isVecInsideYZBounds(Vec3d v, AxisAlignedBB aabb) {
        return v != null && v.field_72448_b >= aabb.field_72338_b && v.field_72448_b <= aabb.field_72337_e && v.field_72449_c >= aabb.field_72339_c && v.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXZBounds(Vec3d v, AxisAlignedBB aabb) {
        return v != null && v.field_72450_a >= aabb.field_72340_a && v.field_72450_a <= aabb.field_72336_d && v.field_72449_c >= aabb.field_72339_c && v.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXYBounds(Vec3d v, AxisAlignedBB aabb) {
        return v != null && v.field_72450_a >= aabb.field_72340_a && v.field_72450_a <= aabb.field_72336_d && v.field_72448_b >= aabb.field_72338_b && v.field_72448_b <= aabb.field_72337_e;
    }

    public static RayTraceResult getMOPFrom(BlockPos pos, EnumFacing s, float hitX, float hitY, float hitZ) {
        return new RayTraceResult(new Vec3d((double)((float)pos.func_177958_n() + hitX), (double)((float)pos.func_177956_o() + hitY), (double)((float)pos.func_177952_p() + hitZ)), s, pos);
    }

    public static AxisAlignedBB getBox(double cx, double y0, double cz, double w, double y1, double d) {
        return new AxisAlignedBB(cx - w / 2.0, y0, cz - d / 2.0, cx + w / 2.0, y1, cz + d / 2.0);
    }

    public static AxisAlignedBB centerBox(double x, double y, double z, double w, double h, double d) {
        return MathHelperMC.getBox(x, y - h / 2.0, z, w, y + h / 2.0, d);
    }

    public static final int getConnectedTextureIndex(int a, int b, int c, int d) {
        for (int i = 0; i < 16; ++i) {
            if (connectedTextureMap[i][0] != a || connectedTextureMap[i][1] != b || connectedTextureMap[i][2] != c || connectedTextureMap[i][3] != d) continue;
            return i;
        }
        return -1;
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB bb, EnumFacing facing) {
        if (bb == null) {
            return null;
        }
        switch (facing) {
            case DOWN: {
                return bb;
            }
            case UP: {
                return new AxisAlignedBB(1.0 - bb.field_72340_a, 1.0 - bb.field_72338_b, 1.0 - bb.field_72339_c, 1.0 - bb.field_72336_d, 1.0 - bb.field_72337_e, 1.0 - bb.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(bb.field_72340_a, bb.field_72339_c, bb.field_72338_b, bb.field_72336_d, bb.field_72334_f, bb.field_72337_e);
            }
            case SOUTH: {
                bb = MathHelperMC.rotateAABB(bb, EnumFacing.NORTH);
                return new AxisAlignedBB(1.0 - bb.field_72340_a, bb.field_72338_b, 1.0 - bb.field_72339_c, 1.0 - bb.field_72336_d, bb.field_72337_e, 1.0 - bb.field_72334_f);
            }
            case WEST: {
                return MathHelperMC.rotateCW(MathHelperMC.rotateAABB(bb, EnumFacing.SOUTH));
            }
            case EAST: {
                return MathHelperMC.rotateCW(MathHelperMC.rotateAABB(bb, EnumFacing.NORTH));
            }
        }
        return bb;
    }

    public static AxisAlignedBB rotateCW(AxisAlignedBB bb) {
        return new AxisAlignedBB(1.0 - bb.field_72339_c, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72334_f, bb.field_72337_e, bb.field_72336_d);
    }

    public static AxisAlignedBB[] getRotatedBoxes(AxisAlignedBB bb) {
        AxisAlignedBB[] boxes = new AxisAlignedBB[6];
        for (EnumFacing f : EnumFacing.field_82609_l) {
            boxes[f.ordinal()] = MathHelperMC.rotateAABB(bb, f);
        }
        return boxes;
    }

    public static RayTraceResult rayTrace(BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Vec3d vec = new Vec3d((double)hitX, (double)hitY, (double)hitZ);
        vec.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        return new RayTraceResult(vec, facing, pos);
    }
}

