/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.util;

import com.latmod.lib.util.LMUtils;
import net.minecraft.util.ResourceLocation;

public final class TextureCoords {
    public static final TextureCoords NULL_TEXTURE = new TextureCoords(null, 0.0, 0.0, 1.0, 1.0);
    public final ResourceLocation texture;
    public final double minU;
    public final double minV;
    public final double maxU;
    public final double maxV;

    public TextureCoords(ResourceLocation res, double u0, double v0, double u1, double v1) {
        this.texture = res;
        this.minU = Math.min(u0, u1);
        this.minV = Math.min(v0, v1);
        this.maxU = Math.max(u0, u1);
        this.maxV = Math.max(v0, v1);
    }

    public TextureCoords(ResourceLocation res, double x, double y, double w, double h, double tw, double th) {
        this.texture = res;
        this.minU = x / tw;
        this.minV = y / th;
        this.maxU = (x + w) / tw;
        this.maxV = (y + h) / th;
    }

    public static TextureCoords getSquareIcon(ResourceLocation res) {
        return new TextureCoords(res, 0.0, 0.0, 1.0, 1.0);
    }

    public int hashCode() {
        return LMUtils.hashCode(this.texture, this.minU, this.minV, this.maxU, this.maxV);
    }

    public String toString() {
        return Double.toString(this.minU) + ',' + this.minV + ',' + this.maxU + ',' + this.maxV;
    }

    public boolean isValid() {
        return this.texture != null && this != NULL_TEXTURE && this.maxU - this.minU > 0.0 && this.maxV - this.minV > 0.0;
    }

    public TextureCoords copy() {
        return new TextureCoords(this.texture, this.minU, this.minV, this.maxU, this.maxV);
    }
}

