/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.lib;

public enum OS {
    WINDOWS,
    LINUX,
    OSX,
    OTHER;

    public static final OS current;
    public static final String ARCH;
    public static final boolean IS_64_ARCH;

    private static OS get() {
        String s = System.getProperty("os.name");
        if (s == null || s.isEmpty()) {
            return OTHER;
        }
        if ((s = s.toLowerCase()).contains("win")) {
            return WINDOWS;
        }
        if (s.contains("mac")) {
            return OSX;
        }
        if (s.contains("linux") || s.contains("unix")) {
            return LINUX;
        }
        return OTHER;
    }

    static {
        current = OS.get();
        ARCH = System.getProperty("sun.arch.data.model");
        IS_64_ARCH = ARCH.equals("64");
    }
}

