/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.lib.annotations;

import com.latmod.lib.annotations.Flags;
import com.latmod.lib.annotations.IAnnotationContainer;
import com.latmod.lib.annotations.IFlagContainer;
import com.latmod.lib.annotations.IInfoContainer;
import com.latmod.lib.annotations.INumberBoundsContainer;
import com.latmod.lib.annotations.Info;
import com.latmod.lib.annotations.NumberBounds;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class AnnotationHelper {
    private static final Map<Class<? extends Annotation>, Handler> map = new HashMap<Class<? extends Annotation>, Handler>();

    public static void register(@Nonnull Class<? extends Annotation> c, @Nonnull Handler h) {
        map.put(c, h);
    }

    public static void inject(@Nonnull Field field, Object obj) throws Exception {
        if (obj instanceof IAnnotationContainer) {
            IAnnotationContainer container = (IAnnotationContainer)obj;
            for (Annotation a : field.getDeclaredAnnotations()) {
                Handler h = map.get(a.annotationType());
                if (h == null) continue;
                h.onAnnotationDeclared(a, container);
            }
        }
    }

    static {
        AnnotationHelper.register(Info.class, (a, container) -> {
            if (container instanceof IInfoContainer) {
                String[] info = ((Info)a).value();
                if (info.length == 0) {
                    info = null;
                }
                ((IInfoContainer)container).setInfo(info);
                return true;
            }
            return false;
        });
        AnnotationHelper.register(NumberBounds.class, (a, container) -> {
            if (container instanceof INumberBoundsContainer) {
                NumberBounds b = (NumberBounds)a;
                ((INumberBoundsContainer)container).setBounds(b.min(), b.max());
                return true;
            }
            return false;
        });
        AnnotationHelper.register(Flags.class, (a, container) -> {
            if (container instanceof IFlagContainer) {
                IFlagContainer fc = (IFlagContainer)container;
                fc.setFlags(((Flags)a).value());
                return true;
            }
            return false;
        });
    }

    public static interface Handler {
        public boolean onAnnotationDeclared(@Nonnull Annotation var1, @Nonnull IAnnotationContainer var2);
    }
}

