/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.lib.io;

import com.latmod.lib.io.RequestMethod;
import com.latmod.lib.io.Response;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class LMConnection {
    public final RequestMethod type;
    public final String url;
    public byte[] data;

    public LMConnection(RequestMethod t, String s) {
        this.type = t == null ? RequestMethod.SIMPLE_GET : t;
        this.url = s;
    }

    public Response connect() throws Exception {
        long startTime = System.currentTimeMillis();
        switch (this.type) {
            case SIMPLE_GET: {
                URL con = new URL(this.url);
                InputStream is = con.openStream();
                return new Response(RequestMethod.SIMPLE_GET, System.currentTimeMillis() - startTime, 200, is);
            }
            case FILE: {
                FileInputStream is = new FileInputStream(this.url);
                return new Response(RequestMethod.FILE, System.currentTimeMillis() - startTime, 200, is);
            }
        }
        HttpURLConnection con = (HttpURLConnection)new URL(this.url).openConnection();
        con.setRequestMethod(this.type.name());
        con.setRequestProperty("User-Agent", "HTTP/1.1");
        con.setDoInput(true);
        if (this.data != null && this.data.length > 0) {
            con.setDoOutput(true);
            OutputStream os = con.getOutputStream();
            os.write(this.data, 0, this.data.length);
            os.flush();
            os.close();
        }
        int responseCode = con.getResponseCode();
        return new Response(this.type, System.currentTimeMillis() - startTime, responseCode, con.getInputStream());
    }
}

