/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.lib.io;

import com.google.gson.JsonElement;
import com.latmod.lib.io.RequestMethod;
import com.latmod.lib.json.LMJsonUtils;
import com.latmod.lib.util.LMStringUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;

public final class Response {
    public final RequestMethod method;
    public final long millis;
    public final int code;
    public final InputStream stream;

    public Response(@Nonnull RequestMethod m, long ms, int c, @Nonnull InputStream is) {
        this.method = m;
        this.millis = ms;
        this.code = c;
        this.stream = is;
    }

    public Response(@Nonnull InputStream is) {
        this(RequestMethod.SIMPLE_GET, 0L, 200, is);
    }

    public String toString() {
        return (Object)((Object)this.method) + "-" + Integer.toString(this.code);
    }

    @Nonnull
    public String asString() throws Exception {
        return LMStringUtils.readString(this.stream);
    }

    @Nonnull
    public List<String> asStringList() throws Exception {
        return LMStringUtils.readStringList(this.stream);
    }

    @Nonnull
    public JsonElement asJson() throws Exception {
        return LMJsonUtils.fromJson(new BufferedReader(new InputStreamReader(this.stream)));
    }

    @Nonnull
    public BufferedImage asImage() throws Exception {
        return ImageIO.read(this.stream);
    }
}

