/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.lib.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.io.ByteIOStream;
import com.latmod.lib.json.EnumJsonID;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonElementIO {
    @Nonnull
    public static EnumJsonID getID(@Nullable JsonElement e) {
        if (e == null || e.isJsonNull()) {
            return EnumJsonID.NULL;
        }
        if (e.isJsonArray()) {
            return EnumJsonID.ARRAY;
        }
        if (e.isJsonObject()) {
            return EnumJsonID.OBJECT;
        }
        JsonPrimitive p = e.getAsJsonPrimitive();
        if (p.isString()) {
            return EnumJsonID.STRING;
        }
        if (p.isBoolean()) {
            return EnumJsonID.BOOL;
        }
        Number n = p.getAsNumber();
        if (n instanceof Integer) {
            return EnumJsonID.INT;
        }
        if (n instanceof Byte) {
            return EnumJsonID.BYTE;
        }
        if (n instanceof Short) {
            return EnumJsonID.SHORT;
        }
        if (n instanceof Long) {
            return EnumJsonID.LONG;
        }
        if (n instanceof Float) {
            return EnumJsonID.FLOAT;
        }
        if (n instanceof Double) {
            return EnumJsonID.DOUBLE;
        }
        return EnumJsonID.NULL;
    }

    @Nonnull
    public static JsonElement read(@Nonnull ByteIOStream io) {
        switch (EnumJsonID.values()[io.readByte()]) {
            case NULL: {
                return JsonNull.INSTANCE;
            }
            case ARRAY: {
                JsonArray a = new JsonArray();
                int s = io.readInt();
                for (int i = 0; i < s; ++i) {
                    a.add(JsonElementIO.read(io));
                }
                return a;
            }
            case OBJECT: {
                JsonObject o = new JsonObject();
                int s = io.readInt();
                for (int i = 0; i < s; ++i) {
                    String key = io.readUTF();
                    if (key == null) continue;
                    o.add(key, JsonElementIO.read(io));
                }
                return o;
            }
            case STRING: {
                String s = io.readUTF();
                return s == null ? JsonNull.INSTANCE : new JsonPrimitive(s);
            }
            case BOOL: {
                return new JsonPrimitive(Boolean.valueOf(io.readBoolean()));
            }
            case BYTE: {
                return new JsonPrimitive((Number)io.readByte());
            }
            case SHORT: {
                return new JsonPrimitive((Number)io.readShort());
            }
            case INT: {
                return new JsonPrimitive((Number)io.readInt());
            }
            case LONG: {
                return new JsonPrimitive((Number)io.readLong());
            }
            case FLOAT: {
                return new JsonPrimitive((Number)Float.valueOf(io.readFloat()));
            }
            case DOUBLE: {
                return new JsonPrimitive((Number)io.readDouble());
            }
        }
        return JsonNull.INSTANCE;
    }

    public static void write(@Nonnull ByteIOStream io, @Nullable JsonElement e) {
        if (e == null || e.isJsonNull()) {
            io.writeByte(EnumJsonID.NULL.ID);
        } else if (e.isJsonArray()) {
            io.writeByte(EnumJsonID.ARRAY.ID);
            JsonArray a = e.getAsJsonArray();
            int s = a.size();
            io.writeInt(s);
            for (int i = 0; i < s; ++i) {
                JsonElementIO.write(io, a.get(i));
            }
        } else if (e.isJsonObject()) {
            io.writeByte(EnumJsonID.OBJECT.ID);
            Set set = e.getAsJsonObject().entrySet();
            io.writeInt(set.size());
            for (Map.Entry entry : set) {
                io.writeUTF((String)entry.getKey());
                JsonElementIO.write(io, (JsonElement)entry.getValue());
            }
        } else {
            JsonPrimitive p = e.getAsJsonPrimitive();
            if (p.isString()) {
                io.writeByte(EnumJsonID.STRING.ID);
                io.writeUTF(p.getAsString());
            } else if (p.isBoolean()) {
                io.writeByte(EnumJsonID.BOOL.ID);
                io.writeBoolean(p.getAsBoolean());
            } else {
                Number n = p.getAsNumber();
                if (n instanceof Integer) {
                    io.writeByte(EnumJsonID.INT.ID);
                    io.writeInt(n.intValue());
                } else if (n instanceof Byte) {
                    io.writeByte(EnumJsonID.BYTE.ID);
                    io.writeByte(n.byteValue());
                } else if (n instanceof Short) {
                    io.writeByte(EnumJsonID.SHORT.ID);
                    io.writeShort(n.shortValue());
                } else if (n instanceof Long) {
                    io.writeByte(EnumJsonID.LONG.ID);
                    io.writeLong(n.longValue());
                } else if (n instanceof Float) {
                    io.writeByte(EnumJsonID.FLOAT.ID);
                    io.writeFloat(n.floatValue());
                } else if (n instanceof Double) {
                    io.writeByte(EnumJsonID.DOUBLE.ID);
                    io.writeDouble(n.doubleValue());
                } else {
                    io.writeByte(EnumJsonID.NULL.ID);
                }
            }
        }
    }
}

