/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.lib.math;

import com.latmod.lib.math.MathHelperLM;
import java.util.Random;
import javax.annotation.Nonnull;

public final class VecLM {
    public double x;
    public double y;
    public double z;

    public VecLM() {
    }

    public VecLM(double nx, double ny, double nz) {
        this.x = nx;
        this.y = ny;
        this.z = nz;
    }

    public VecLM(@Nonnull Random r, boolean sin) {
        this(r.nextFloat(), r.nextFloat(), r.nextFloat());
        if (sin) {
            this.scale(2.0);
            this.add(-1.0, -1.0, -1.0);
        }
    }

    public void set(double nx, double ny, double nz) {
        this.x = nx;
        this.y = ny;
        this.z = nz;
    }

    public void set(@Nonnull VecLM v) {
        this.set(v.x, v.y, v.z);
    }

    public void add(double ax, double ay, double az) {
        this.set(this.x + ax, this.y + ay, this.z + az);
    }

    public void add(@Nonnull VecLM v, double s) {
        this.add(v.x * s, v.y * s, v.z * s);
    }

    public void scale(double sx, double sy, double sz) {
        this.x *= sx;
        this.y *= sy;
        this.z *= sz;
    }

    public void scale(@Nonnull VecLM v, double s) {
        this.scale(v.x * s, v.y * s, v.z * s);
    }

    public void scale(double s) {
        this.scale(s, s, s);
    }

    public boolean isNull() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public boolean containsNaN() {
        return Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.y);
    }

    public boolean equals(Object o) {
        return o instanceof VecLM && this.equalsPos((VecLM)o);
    }

    public boolean equalsPos(@Nonnull VecLM v) {
        return v.x == this.x && v.y == this.y && v.z == this.z;
    }

    @Nonnull
    public VecLM copy() {
        return new VecLM(this.x, this.y, this.z);
    }

    public double distSq(double x1, double y1, double z1) {
        return MathHelperLM.sq(x1 - this.x) + MathHelperLM.sq(y1 - this.y) + MathHelperLM.sq(z1 - this.z);
    }

    public double dist(double x1, double y1, double z1) {
        return MathHelperLM.sqrt(this.distSq(x1, y1, z1));
    }

    public double distSq(VecLM v) {
        return this.distSq(v.x, v.y, v.z);
    }

    public double dist(VecLM v) {
        return MathHelperLM.sqrt(this.distSq(v));
    }

    public double atanXZ(VecLM v) {
        if (v == null) {
            return -1.0;
        }
        return Math.atan2(v.z - this.z, v.x - this.x);
    }

    public double atanY(VecLM v) {
        if (v == null) {
            return -1.0;
        }
        return Math.atan(this.y - v.y);
    }

    public int getX() {
        return MathHelperLM.floor(this.x);
    }

    public int getY() {
        return MathHelperLM.floor(this.y);
    }

    public int getZ() {
        return MathHelperLM.floor(this.z);
    }

    public double length() {
        return this.isNull() ? 0.0 : MathHelperLM.dist(0.0, 0.0, 0.0, this.x, this.y, this.z);
    }

    @Nonnull
    public VecLM normalize() {
        double d = this.length();
        return d == 0.0 ? new VecLM(0.0, 0.0, 0.0) : new VecLM(this.x / d, this.y / d, this.z / d);
    }
}

