/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.lib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.latmod.lib.math.MathHelperLM;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LMColorUtils {
    public static final int[] chatFormattingColors = new int[16];
    public static final int BLACK = -16777216;
    public static final int WHITE = -1;
    public static final int LIGHT_GRAY = -5592406;
    public static final int DARK_GRAY = -13421773;
    public static final int WIDGETS = -16777216;

    @Nonnull
    public static JsonElement serialize(int col) {
        return new JsonPrimitive('#' + Integer.toHexString(col).toUpperCase());
    }

    public static int deserialize(@Nullable JsonElement e) {
        if (e == null || !e.isJsonPrimitive()) {
            return -16777216;
        }
        return (int)Long.parseLong(e.getAsString().substring(1), 16);
    }

    public static int getRGBA(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getRGBAF(float r, float g, float b, float a) {
        return LMColorUtils.getRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public static int getRed(int c) {
        return c >> 16 & 0xFF;
    }

    public static int getGreen(int c) {
        return c >> 8 & 0xFF;
    }

    public static int getBlue(int c) {
        return c & 0xFF;
    }

    public static int getAlpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static float getRedF(int c) {
        return (float)LMColorUtils.getRed(c) / 255.0f;
    }

    public static float getGreenF(int c) {
        return (float)LMColorUtils.getGreen(c) / 255.0f;
    }

    public static float getBlueF(int c) {
        return (float)LMColorUtils.getBlue(c) / 255.0f;
    }

    public static float getAlphaF(int c) {
        return (float)LMColorUtils.getAlpha(c) / 255.0f;
    }

    public static String getHex(int c) {
        return '#' + Integer.toHexString(LMColorUtils.getRGBA(c, 255)).substring(2).toUpperCase();
    }

    public static int getRGBA(int c, int a) {
        return LMColorUtils.getRGBA(LMColorUtils.getRed(c), LMColorUtils.getGreen(c), LMColorUtils.getBlue(c), a);
    }

    public static int addBrightness(int c, int b) {
        int red = MathHelperLM.clampInt(LMColorUtils.getRed(c) + b, 0, 255);
        int green = MathHelperLM.clampInt(LMColorUtils.getGreen(c) + b, 0, 255);
        int blue = MathHelperLM.clampInt(LMColorUtils.getBlue(c) + b, 0, 255);
        return LMColorUtils.getRGBA(red, green, blue, LMColorUtils.getAlpha(c));
    }

    public static void addHSB(@Nonnull int[] pixels, float h, float s, float b) {
        if (pixels.length > 0) {
            float[] hsb = new float[3];
            for (int i = 0; i < pixels.length; ++i) {
                Color.RGBtoHSB(LMColorUtils.getRed(pixels[i]), LMColorUtils.getGreen(pixels[i]), LMColorUtils.getBlue(pixels[i]), hsb);
                hsb[0] = hsb[0] + h;
                hsb[1] = MathHelperLM.clampFloat(hsb[1] + s, 0.0f, 1.0f);
                hsb[2] = MathHelperLM.clampFloat(hsb[2] + b, 0.0f, 1.0f);
                pixels[i] = LMColorUtils.getRGBA(Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]), 255);
            }
        }
    }

    public static int lerp(int col1, int col2, double m, int alpha) {
        m = MathHelperLM.clamp(m, 0.0, 1.0);
        int r = MathHelperLM.lerpInt(LMColorUtils.getRed(col1), LMColorUtils.getRed(col2), m);
        int g = MathHelperLM.lerpInt(LMColorUtils.getGreen(col1), LMColorUtils.getGreen(col2), m);
        int b = MathHelperLM.lerpInt(LMColorUtils.getBlue(col1), LMColorUtils.getBlue(col2), m);
        return LMColorUtils.getRGBA(r, g, b, alpha);
    }

    public static int lerp(int col1, int col2, double m) {
        return LMColorUtils.lerp(col1, col2, m, LMColorUtils.getAlpha(col1));
    }

    public static int multiply(int col1, int col2, int a) {
        float r = MathHelperLM.clampFloat(LMColorUtils.getRedF(col1) * LMColorUtils.getRedF(col2), 0.0f, 1.0f);
        float g = MathHelperLM.clampFloat(LMColorUtils.getGreenF(col1) * LMColorUtils.getGreenF(col2), 0.0f, 1.0f);
        float b = MathHelperLM.clampFloat(LMColorUtils.getBlueF(col1) * LMColorUtils.getBlueF(col2), 0.0f, 1.0f);
        return LMColorUtils.getRGBA((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), a);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            int j = (i >> 3 & 1) * 85;
            int r = (i >> 2 & 1) * 170 + j;
            int g = (i >> 1 & 1) * 170 + j;
            int b = (i & 1) * 170 + j;
            if (i == 6) {
                r += 85;
            }
            LMColorUtils.chatFormattingColors[i] = LMColorUtils.getRGBA(r, g, b, 255);
        }
    }
}

