/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.lib.util;

import com.latmod.lib.IIDObject;
import com.latmod.lib.util.LMStringUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class LMUtils {
    public static final Comparator<Package> PACKAGE_COMPARATOR = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    public static final Comparator<Object> ID_COMPARATOR = (o1, o2) -> LMUtils.getID(o1).compareToIgnoreCase(LMUtils.getID(o2));

    @Nullable
    public static <T> T convert(@Nullable Object t) {
        return (T)(t == null ? null : t);
    }

    @Nonnull
    public static <E> E newObject(Class<?> c, Object ... o) throws Exception {
        if (o != null && o.length > 0) {
            Class[] params = new Class[o.length];
            for (int i = 0; i < o.length; ++i) {
                params[i] = o.getClass();
            }
            Constructor<?> c1 = c.getConstructor(params);
            return (E)c1.newInstance(o);
        }
        return (E)c.newInstance();
    }

    @Nonnull
    public static Package[] getAllPackages() {
        Package[] p = Package.getPackages();
        Arrays.sort(p, PACKAGE_COMPARATOR);
        return p;
    }

    @Nonnull
    public static Collection<Class<?>> addSubclasses(Class<?> c, Collection<Class<?>> al, boolean all) {
        if (al == null) {
            al = new HashSet();
        }
        ArrayList al1 = new ArrayList();
        Collections.addAll(al1, c.getDeclaredClasses());
        if (all && !al1.isEmpty()) {
            for (Class anAl1 : al1) {
                al.addAll(LMUtils.addSubclasses(anAl1, null, true));
            }
        }
        al.addAll(al1);
        return al;
    }

    public static boolean areObjectsEqual(@Nullable Object o1, @Nullable Object o2, boolean allowNulls) {
        return o1 == null && o2 == null ? allowNulls : o1 != null && o2 != null && (o1 == o2 || o1.equals(o2));
    }

    public static int hashCodeOf(@Nullable Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int hashCode(Object ... o) {
        if (o == null || o.length == 0) {
            return 0;
        }
        if (o.length == 1) {
            return LMUtils.hashCodeOf(o[0]);
        }
        return Arrays.hashCode(o);
    }

    public static long longHashCode(Object ... o) {
        if (o == null || o.length == 0) {
            return 0L;
        }
        if (o.length == 1) {
            return LMUtils.hashCodeOf(o[0]);
        }
        long h = 1L;
        for (Object anO : o) {
            h = h * 31L + (long)LMUtils.hashCodeOf(anO);
        }
        return h;
    }

    @Nullable
    public static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static String getExternalAddress() {
        try {
            return LMStringUtils.readString(new URL("http://checkip.amazonaws.com").openStream());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean openURI(URI uri) throws Exception {
        Class<?> oclass = Class.forName("java.awt.Desktop");
        Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
        oclass.getMethod("browse", URI.class).invoke(object, uri);
        return true;
    }

    public static void moveBytes(InputStream is, OutputStream os, boolean close) throws Exception {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer, 0, buffer.length)) > 0) {
            os.write(buffer, 0, len);
        }
        os.flush();
        if (close) {
            is.close();
            os.close();
        }
    }

    public static String getID(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof IIDObject) {
            return ((IIDObject)o).getID();
        }
        return o.toString();
    }

    public static String fromUUID(@Nullable UUID id) {
        if (id != null) {
            long msb = id.getMostSignificantBits();
            long lsb = id.getLeastSignificantBits();
            StringBuilder sb = new StringBuilder(32);
            LMUtils.digitsUUID(sb, msb >> 32, 8);
            LMUtils.digitsUUID(sb, msb >> 16, 4);
            LMUtils.digitsUUID(sb, msb, 4);
            LMUtils.digitsUUID(sb, lsb >> 48, 4);
            LMUtils.digitsUUID(sb, lsb, 12);
            return sb.toString();
        }
        return null;
    }

    private static void digitsUUID(StringBuilder sb, long val, int digits) {
        long hi = 1L << digits * 4;
        String s = Long.toHexString(hi | val & hi - 1L);
        sb.append(s, 1, s.length());
    }

    public static UUID fromString(@Nullable String s) {
        if (s == null || s.length() != 32 && s.length() != 36) {
            return null;
        }
        try {
            if (s.indexOf(45) != -1) {
                return UUID.fromString(s);
            }
            int l = s.length();
            StringBuilder sb = new StringBuilder(36);
            for (int i = 0; i < l; ++i) {
                sb.append(s.charAt(i));
                if (i != 7 && i != 11 && i != 15 && i != 19) continue;
                sb.append('-');
            }
            return UUID.fromString(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nonnull
    public static <E> List<E> getObjects(@Nullable Class<E> type, Class<?> fields, @Nullable Object obj) throws IllegalAccessException {
        ArrayList<Object> l = new ArrayList<Object>();
        for (Field f : fields.getDeclaredFields()) {
            f.setAccessible(true);
            Object o = f.get(obj);
            if (type != null && !type.isAssignableFrom(o.getClass())) continue;
            l.add(o);
        }
        return l;
    }
}

