/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.asm;

import lumien.randomthings.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"RandomThingsCore");
    final String asmHandler = "lumien/randomthings/handler/AsmHandler";

    public ClassTransformer() {
        this.logger.log(Level.DEBUG, "Starting Class Transformation");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.world.World")) {
            return this.patchWorldClass(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.BlockRendererDispatcher")) {
            return this.patchBlockRendererDispatcher(basicClass);
        }
        if (transformedName.equals("net.minecraft.block.Block")) {
            return this.patchBlock(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.entity.RenderLivingBase")) {
            return this.patchRenderLivingBase(basicClass);
        }
        if (transformedName.equals("net.minecraft.entity.EntityLivingBase")) {
            return this.patchEntityLivingBase(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.RenderItem")) {
            return this.patchRenderItem(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.entity.layers.LayerArmorBase")) {
            return this.patchLayerArmorBase(basicClass);
        }
        if (!transformedName.equals("net.minecraft.world.gen.structure.StructureOceanMonumentPieces$MonumentCoreRoom") && !transformedName.equals("net.minecraft.block.BlockLiquid")) {
            if (transformedName.equals("net.minecraft.client.renderer.EntityRenderer")) {
                return this.patchEntityRenderer(basicClass);
            }
            if (transformedName.equals("net.minecraft.entity.player.InventoryPlayer")) {
                return this.patchInventoryPlayer(basicClass);
            }
        }
        return basicClass;
    }

    private byte[] patchInventoryPlayer(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found InventoryPlayer Class: " + classNode.name);
        MethodNode dropAllItems = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_70436_m"))) continue;
            dropAllItems = mn;
            break;
        }
        if (dropAllItems != null) {
            this.logger.log(Level.DEBUG, " - Found dropAllItems (1/2)");
            for (int i = 0; i < dropAllItems.instructions.size(); ++i) {
                JumpInsnNode jin;
                AbstractInsnNode ain = dropAllItems.instructions.get(i);
                if (!(ain instanceof JumpInsnNode) || (jin = (JumpInsnNode)ain).getOpcode() != 198) continue;
                LabelNode l0 = jin.label;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 5));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 4));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 5));
                toInsert.add((AbstractInsnNode)new InsnNode(50));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldPlayerDrop", "(Lnet/minecraft/entity/player/InventoryPlayer;ILnet/minecraft/item/ItemStack;)Z"));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l0));
                dropAllItems.instructions.insert((AbstractInsnNode)jin, toInsert);
                i += 7;
                this.logger.log(Level.DEBUG, " - Patched dropAllItems (2/2)");
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchLiquidBlock(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found BlockLiquid Class: " + classNode.name);
        MethodNode shouldSideBeRendered = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_176225_a"))) continue;
            shouldSideBeRendered = mn;
            break;
        }
        if (shouldSideBeRendered != null) {
            this.logger.log(Level.DEBUG, " - Found shouldSideBeRendered (1/1)");
            LabelNode l1 = new LabelNode(new Label());
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldLiquidSideBeRendered", "(Lnet/minecraft/block/BlockLiquid;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I", false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(155, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new InsnNode(87));
            shouldSideBeRendered.instructions.insert(toInsert);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchLayerArmorBase(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found LayerArmorBase Class: " + classNode.name);
        MethodNode renderEnchantedGlint = null;
        MethodNode renderArmorLayer = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_188364_a"))) {
                renderEnchantedGlint = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_188361_a"))) continue;
            renderArmorLayer = mn;
        }
        if (renderEnchantedGlint != null) {
            this.logger.log(Level.DEBUG, "- Found renderEnchantedGlint (Effect Rendering 1/2)");
            for (int i = 0; i < renderEnchantedGlint.instructions.size(); ++i) {
                AbstractInsnNode ain = renderEnchantedGlint.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.owner.equals("net/minecraft/client/renderer/GlStateManager") || !min.name.equals(MCPNames.method("func_179131_c"))) continue;
                renderEnchantedGlint.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "armorEnchantmentHook", "()V", false));
            }
        }
        int renderCounter = 0;
        if (renderArmorLayer != null) {
            this.logger.log(Level.DEBUG, "- Found renderArmorLayer (ItemStack Information & Armor Coloring 2/2)");
            for (int i = 0; i < renderArmorLayer.instructions.size(); ++i) {
                InsnList toInsert;
                AbstractInsnNode ain = renderArmorLayer.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (min.name.equals("func_188364_a")) {
                    this.logger.log(Level.DEBUG, "- Set currentlyRendering");
                    toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 10));
                    toInsert.add((AbstractInsnNode)new FieldInsnNode(179, "lumien/randomthings/handler/AsmHandler", "currentlyRendering", "Lnet/minecraft/item/ItemStack;"));
                    renderArmorLayer.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                    i += 2;
                }
                if (!min.name.equals(MCPNames.method("func_78088_a"))) continue;
                if (renderCounter == 1) {
                    this.logger.log(Level.DEBUG, "- Found render");
                    toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 10));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "armorColorHook", "(Lnet/minecraft/item/ItemStack;)V", false));
                    renderArmorLayer.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                }
                ++renderCounter;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchRenderItem(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found RenderItem Class: " + classNode.name);
        MethodNode renderEffect = null;
        MethodNode renderItem = null;
        MethodNode renderQuads = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_180451_a"))) {
                renderEffect = mn;
                continue;
            }
            if (mn.name.equals(MCPNames.method("func_180454_a")) && mn.desc.equals("(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V")) {
                renderItem = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_175032_a"))) continue;
            renderQuads = mn;
        }
        if (renderEffect != null) {
            this.logger.log(Level.DEBUG, "- Found renderEffect (1/3)");
            for (int i = 0; i < renderEffect.instructions.size(); ++i) {
                AbstractInsnNode ain = renderEffect.instructions.get(i);
                if (!(ain instanceof LdcInsnNode)) continue;
                LdcInsnNode lin = (LdcInsnNode)ain;
                if (!lin.cst.equals(new Integer(-8372020))) continue;
                this.logger.log(Level.DEBUG, "- Found Texture Binding");
                renderEffect.instructions.insert((AbstractInsnNode)lin, (AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "enchantmentColorHook", "()I", false));
                renderEffect.instructions.remove((AbstractInsnNode)lin);
            }
        }
        if (renderItem != null) {
            boolean found = false;
            this.logger.log(Level.DEBUG, "- Found renderItem (2/3) (" + renderItem.desc + ")");
            for (int i = 0; i < renderItem.instructions.size(); ++i) {
                AbstractInsnNode ain = renderItem.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!found && min.name.equals(MCPNames.method("func_180451_a"))) {
                    this.logger.log(Level.DEBUG, "- Found renderEffect calling");
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
                    toInsert.add((AbstractInsnNode)new FieldInsnNode(179, "lumien/randomthings/handler/AsmHandler", "currentlyRendering", "Lnet/minecraft/item/ItemStack;"));
                    renderItem.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                    found = true;
                }
                if (!min.name.equals(MCPNames.method("func_179022_a"))) continue;
                LabelNode l1 = new LabelNode(new Label());
                LabelNode l2 = new LabelNode(new Label());
                this.logger.log(Level.DEBUG, "- Inserting TE Item Renderer");
                InsnList insertBefore = new InsnList();
                insertBefore.add((AbstractInsnNode)new FieldInsnNode(178, "lumien/randomthings/client/RandomThingsTEItemRenderer", "instance", "Llumien/randomthings/client/RandomThingsTEItemRenderer;"));
                insertBefore.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insertBefore.add((AbstractInsnNode)new MethodInsnNode(182, "lumien/randomthings/client/RandomThingsTEItemRenderer", "renderByItem", "(Lnet/minecraft/item/ItemStack;)Z", false));
                insertBefore.add((AbstractInsnNode)new JumpInsnNode(153, l2));
                insertBefore.add((AbstractInsnNode)new InsnNode(87));
                insertBefore.add((AbstractInsnNode)new InsnNode(87));
                insertBefore.add((AbstractInsnNode)new JumpInsnNode(167, l1));
                insertBefore.add((AbstractInsnNode)l2);
                InsnList insertAfter = new InsnList();
                insertAfter.add((AbstractInsnNode)l1);
                renderItem.instructions.insertBefore((AbstractInsnNode)min, insertBefore);
                renderItem.instructions.insert((AbstractInsnNode)min, insertAfter);
                i += 8;
            }
        }
        if (renderQuads != null) {
            this.logger.log(Level.DEBUG, "- Found renderQuads (3/3) (" + renderQuads.desc + ")");
            for (int i = 0; i < renderQuads.instructions.size(); ++i) {
                AbstractInsnNode ain = renderQuads.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals("renderQuadColor")) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new InsnNode(87));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 4));
                toInsert.add((AbstractInsnNode)new VarInsnNode(21, 9));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "getColorFromItemStack", "(Lnet/minecraft/item/ItemStack;I)I", false));
                renderQuads.instructions.insertBefore((AbstractInsnNode)min, toInsert);
                i += 4;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntityLivingBase(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found EntityLivingBase Class: " + classNode.name);
        MethodNode updatePotionEffects = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_70679_bo"))) continue;
            updatePotionEffects = mn;
        }
        if (updatePotionEffects != null) {
            this.logger.log(Level.DEBUG, "- Found updatePotionEffects (1/1)");
            for (int i = 0; i < updatePotionEffects.instructions.size(); ++i) {
                AbstractInsnNode ain = updatePotionEffects.instructions.get(i);
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (!fin.name.equals(MCPNames.field("field_70180_af"))) continue;
                AbstractInsnNode aload = updatePotionEffects.instructions.get(i - 1);
                InsnList toInsert = new InsnList();
                LabelNode l1 = new LabelNode(new Label());
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldRenderPotionParticles", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(157, l1));
                toInsert.add((AbstractInsnNode)new InsnNode(177));
                toInsert.add((AbstractInsnNode)l1);
                updatePotionEffects.instructions.insertBefore(aload, toInsert);
                break;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchRenderLivingBase(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found RenderLivingBase Class: " + classNode.name);
        MethodNode canRenderName = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_177070_b"))) continue;
            canRenderName = mn;
            break;
        }
        if (canRenderName != null) {
            this.logger.log(Level.DEBUG, "- Found canRenderName (1/1)");
            LabelNode l1 = new LabelNode(new Label());
            InsnList toInsert = new InsnList();
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "canRenderName", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(157, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(3));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            canRenderName.instructions.insert(toInsert);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchBlock(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Block Class: " + classNode.name);
        MethodNode addCollisionBoxesToList = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_185477_a")) || !mn.desc.equals("(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;)V")) continue;
            addCollisionBoxesToList = mn;
        }
        if (addCollisionBoxesToList != null) {
            this.logger.log(Level.DEBUG, "- Found addCollisionBoxesToList (1/1)");
            InsnList toInsert = new InsnList();
            LabelNode l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 4));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 5));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 6));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "addCollisionBoxesToList", "(Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/entity/Entity;)Z", false));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(177));
            toInsert.add((AbstractInsnNode)l1);
            addCollisionBoxesToList.instructions.insert(toInsert);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchBlockRendererDispatcher(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found BlockRendererDispatcher Class: " + classNode.name);
        MethodNode renderBlock = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_175018_a"))) continue;
            renderBlock = mn;
        }
        if (renderBlock != null) {
            this.logger.log(Level.DEBUG, "- Found renderBlock (1/1)");
            InsnList toInsert = new InsnList();
            LabelNode l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 4));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "renderBlock", "(Lnet/minecraft/client/renderer/BlockRendererDispatcher;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/IBlockAccess;Lnet/minecraft/client/renderer/VertexBuffer;)I", false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new InsnNode(5));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(159, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new InsnNode(87));
            renderBlock.instructions.insert(toInsert);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchWorldClass(byte[] basicClass) {
        LabelNode l1;
        InsnList toInsert;
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found World Class: " + classNode.name);
        MethodNode getRedstonePower = null;
        MethodNode getStrongPower = null;
        MethodNode isRainingAt = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_175651_c"))) {
                getRedstonePower = mn;
                continue;
            }
            if (mn.name.equals(MCPNames.method("func_175627_a")) && mn.desc.equals("(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I")) {
                getStrongPower = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_175727_C"))) continue;
            isRainingAt = mn;
        }
        if (getRedstonePower != null) {
            this.logger.log(Level.DEBUG, "- Found getRedstonePower (1/3)");
            toInsert = new InsnList();
            l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "getRedstonePower", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I", false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new InsnNode(87));
            getRedstonePower.instructions.insert(toInsert);
        }
        if (getStrongPower != null) {
            this.logger.log(Level.DEBUG, "- Found getStrongPower (2/3)");
            toInsert = new InsnList();
            l1 = new LabelNode(new Label());
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert.add((AbstractInsnNode)new VarInsnNode(25, 2));
            toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "getStrongPower", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/EnumFacing;)I", false));
            toInsert.add((AbstractInsnNode)new InsnNode(89));
            toInsert.add((AbstractInsnNode)new JumpInsnNode(153, l1));
            toInsert.add((AbstractInsnNode)new InsnNode(172));
            toInsert.add((AbstractInsnNode)l1);
            toInsert.add((AbstractInsnNode)new InsnNode(87));
            getStrongPower.instructions.insert(toInsert);
        }
        if (isRainingAt != null) {
            this.logger.log(Level.DEBUG, "- Found isRainingAt (3/3)");
            AbstractInsnNode returnNode = isRainingAt.instructions.get(isRainingAt.instructions.size() - 2);
            InsnList toInsert2 = new InsnList();
            LabelNode returnLabel = new LabelNode(new Label());
            toInsert2.add((AbstractInsnNode)new InsnNode(89));
            toInsert2.add((AbstractInsnNode)new JumpInsnNode(153, returnLabel));
            toInsert2.add((AbstractInsnNode)new InsnNode(87));
            toInsert2.add((AbstractInsnNode)new VarInsnNode(25, 0));
            toInsert2.add((AbstractInsnNode)new VarInsnNode(25, 1));
            toInsert2.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldRain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
            toInsert2.add((AbstractInsnNode)returnLabel);
            isRainingAt.instructions.insertBefore(returnNode, toInsert2);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchEntityRenderer(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found EntityRenderer Class: " + classNode.name);
        MethodNode renderRainSnow = null;
        MethodNode addRainParticles = null;
        for (MethodNode mn : classNode.methods) {
            if (mn.name.equals(MCPNames.method("func_78474_d"))) {
                renderRainSnow = mn;
                continue;
            }
            if (!mn.name.equals(MCPNames.method("func_78484_h"))) continue;
            addRainParticles = mn;
        }
        if (renderRainSnow != null) {
            this.logger.log(Level.DEBUG, "- Found renderRainSnow");
            VarInsnNode insnPoint = null;
            for (int i = 0; i < renderRainSnow.instructions.size(); ++i) {
                AbstractInsnNode jumpNode;
                AbstractInsnNode ain = renderRainSnow.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (min.name.equals(MCPNames.method("func_76738_d"))) {
                    this.logger.log(Level.DEBUG, "- Found canRain");
                    insnPoint = (VarInsnNode)renderRainSnow.instructions.get(i - 1);
                }
                if (!min.name.equals(MCPNames.method("func_76746_c"))) continue;
                this.logger.log(Level.DEBUG, "- Found getEnableSnow");
                int jumpCounter = i + 1;
                int worldIndex = 5;
                int blockPosIndex = 21;
                for (LocalVariableNode lv : renderRainSnow.localVariables) {
                    if (lv.desc.equals("Lnet/minecraft/client/multiplayer/WorldClient;") || lv.desc.equals("Lnet/minecraft/world/World;")) {
                        worldIndex = lv.index;
                        continue;
                    }
                    if (!lv.desc.equals("Lnet/minecraft/util/math/BlockPos$MutableBlockPos;")) continue;
                    blockPosIndex = lv.index;
                }
                while (!((jumpNode = renderRainSnow.instructions.get(jumpCounter)) instanceof JumpInsnNode)) {
                    ++jumpCounter;
                }
                JumpInsnNode jin = (JumpInsnNode)jumpNode;
                LabelNode labelNode = jin.label;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, worldIndex));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, blockPosIndex));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldRain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, labelNode));
                renderRainSnow.instructions.insertBefore((AbstractInsnNode)insnPoint, toInsert);
                i += 4;
            }
        }
        if (addRainParticles != null) {
            this.logger.log(Level.DEBUG, "- Found addRainParticles");
            for (int i = 0; i < addRainParticles.instructions.size(); ++i) {
                JumpInsnNode jin;
                AbstractInsnNode ain = addRainParticles.instructions.get(i);
                if (!(ain instanceof JumpInsnNode) || (jin = (JumpInsnNode)ain).getOpcode() != 163) continue;
                LabelNode jumpTarget = jin.label;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 3));
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 15));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/randomthings/handler/AsmHandler", "shouldRain", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Z", false));
                toInsert.add((AbstractInsnNode)new JumpInsnNode(153, jumpTarget));
                addRainParticles.instructions.insert((AbstractInsnNode)jin, toInsert);
                break;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Dummy Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

