/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.magicavoxel;

import java.awt.Color;
import java.nio.FloatBuffer;
import lumien.randomthings.handler.magicavoxel.MagicaVoxelModel;
import lumien.randomthings.handler.magicavoxel.Palette;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.Util;

public class MagicaVoxelRenderModel {
    MagicaVoxelModel model;
    Palette palette;
    int vertexBufferID;
    int colourBufferID;
    int normalBufferID;
    int numberIndices;
    boolean build;
    boolean randomized;
    boolean rendering;

    public MagicaVoxelRenderModel(MagicaVoxelModel model, boolean randomized) {
        this.model = model;
        this.palette = model.getPalette();
        this.build = false;
        this.randomized = randomized;
    }

    public void build() {
        if (!this.build) {
            int arrayBuffer = GL11.glGetInteger((int)34964);
            this.vertexBufferID = GL15.glGenBuffers();
            this.colourBufferID = GL15.glGenBuffers();
            this.normalBufferID = GL15.glGenBuffers();
            this.numberIndices = this.model.getVoxels().size();
            FloatBuffer vertexBuffer = BufferUtils.createFloatBuffer((int)(this.numberIndices * 6 * 4 * 3));
            float size = 0.05f;
            for (MagicaVoxelModel.Voxel voxel : this.model.getVoxels()) {
                float x = (float)voxel.x * size;
                float y = (float)voxel.y * size;
                float z = (float)voxel.z * size;
                vertexBuffer.put(new float[]{x + 0.0f, y + 0.0f, z + 0.0f});
                vertexBuffer.put(new float[]{x + 0.0f, y + size, z + 0.0f});
                vertexBuffer.put(new float[]{x + size, y + size, z + 0.0f});
                vertexBuffer.put(new float[]{x + size, y + 0.0f, z + 0.0f});
                vertexBuffer.put(new float[]{x + size, y + size, z + 0.0f});
                vertexBuffer.put(new float[]{x + size, y + size, z + size});
                vertexBuffer.put(new float[]{x + size, y + 0.0f, z + size});
                vertexBuffer.put(new float[]{x + size, y + 0.0f, z + 0.0f});
                vertexBuffer.put(new float[]{x + size, y + size, z + size});
                vertexBuffer.put(new float[]{x + 0.0f, y + size, z + size});
                vertexBuffer.put(new float[]{x + 0.0f, y + 0.0f, z + size});
                vertexBuffer.put(new float[]{x + size, y + 0.0f, z + size});
                vertexBuffer.put(new float[]{x + 0.0f, y + size, z + size});
                vertexBuffer.put(new float[]{x + 0.0f, y + size, z + 0.0f});
                vertexBuffer.put(new float[]{x + 0.0f, y + 0.0f, z + 0.0f});
                vertexBuffer.put(new float[]{x + 0.0f, y + 0.0f, z + size});
                vertexBuffer.put(new float[]{x + 0.0f, y + 0.0f, z + 0.0f});
                vertexBuffer.put(new float[]{x + size, y + 0.0f, z + 0.0f});
                vertexBuffer.put(new float[]{x + size, y + 0.0f, z + size});
                vertexBuffer.put(new float[]{x + 0.0f, y + 0.0f, z + size});
                vertexBuffer.put(new float[]{x + 0.0f, y + size, z + 0.0f});
                vertexBuffer.put(new float[]{x + 0.0f, y + size, z + size});
                vertexBuffer.put(new float[]{x + size, y + size, z + size});
                vertexBuffer.put(new float[]{x + size, y + size, z + 0.0f});
            }
            vertexBuffer.rewind();
            GL15.glBindBuffer((int)34962, (int)this.vertexBufferID);
            GL15.glBufferData((int)34962, (FloatBuffer)vertexBuffer, (int)35044);
            FloatBuffer colourBuffer = BufferUtils.createFloatBuffer((int)(this.numberIndices * 6 * 4 * 4));
            for (MagicaVoxelModel.Voxel voxel : this.model.getVoxels()) {
                Color colour = this.palette.getColor(voxel.colorIndex);
                float colorRandom = 0.0f;
                if (this.randomized) {
                    colorRandom = (float)(Math.random() * (double)0.2f - (double)0.1f);
                }
                float mod = 0.003921569f;
                for (int i = 0; i < 24; ++i) {
                    colourBuffer.put(new float[]{mod * (float)colour.getRed() + colorRandom, mod * (float)colour.getGreen() + colorRandom, mod * (float)colour.getBlue() + colorRandom, 1.0f});
                }
            }
            colourBuffer.rewind();
            GL15.glBindBuffer((int)34962, (int)this.colourBufferID);
            GL15.glBufferData((int)34962, (FloatBuffer)colourBuffer, (int)35044);
            FloatBuffer normalBuffer = BufferUtils.createFloatBuffer((int)(this.numberIndices * 6 * 3 * 4));
            for (MagicaVoxelModel.Voxel voxel : this.model.getVoxels()) {
                int i;
                for (i = 0; i < 4; ++i) {
                    normalBuffer.put(new float[]{0.0f, 0.0f, -1.0f});
                }
                for (i = 0; i < 4; ++i) {
                    normalBuffer.put(new float[]{1.0f, 0.0f, 0.0f});
                }
                for (i = 0; i < 4; ++i) {
                    normalBuffer.put(new float[]{0.0f, 0.0f, 1.0f});
                }
                for (i = 0; i < 4; ++i) {
                    normalBuffer.put(new float[]{-1.0f, 0.0f, 0.0f});
                }
                for (i = 0; i < 4; ++i) {
                    normalBuffer.put(new float[]{0.0f, -1.0f, 0.0f});
                }
                for (i = 0; i < 4; ++i) {
                    normalBuffer.put(new float[]{0.0f, 1.0f, 0.0f});
                }
            }
            normalBuffer.rewind();
            GL15.glBindBuffer((int)34962, (int)this.normalBufferID);
            GL15.glBufferData((int)34962, (FloatBuffer)normalBuffer, (int)35044);
            this.build = true;
            GL15.glBindBuffer((int)34962, (int)arrayBuffer);
            Util.checkGLError();
        }
    }

    public boolean isBuild() {
        return this.build;
    }

    public void draw(boolean ambientLight) {
        if (this.build) {
            this.rendering = true;
            GlStateManager.func_179090_x();
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            if (ambientLight) {
                GlStateManager.func_179145_e();
            } else {
                GlStateManager.func_179140_f();
            }
            FloatBuffer globalAmbient = BufferUtils.createFloatBuffer((int)4);
            globalAmbient.put(new float[]{0.2f, 0.2f, 0.2f, 1.0f});
            globalAmbient.rewind();
            GL11.glLightModel((int)2899, (FloatBuffer)globalAmbient);
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179142_g();
            GlStateManager.func_179104_a((int)1032, (int)5634);
            FloatBuffer materialSpecular = BufferUtils.createFloatBuffer((int)4);
            materialSpecular.put(new float[]{1.0f, 1.0f, 1.0f, 1.0f});
            materialSpecular.rewind();
            GL11.glMaterial((int)1032, (int)4610, (FloatBuffer)materialSpecular);
            FloatBuffer materialEmission = BufferUtils.createFloatBuffer((int)4);
            materialEmission.put(new float[]{0.0f, 0.0f, 0.0f, 1.0f});
            materialEmission.rewind();
            GL11.glMaterial((int)1032, (int)5632, (FloatBuffer)materialEmission);
            int arrayBuffer = GL11.glGetInteger((int)34964);
            GlStateManager.func_187410_q((int)32884);
            GL15.glBindBuffer((int)34962, (int)this.vertexBufferID);
            GlStateManager.func_187420_d((int)3, (int)5126, (int)0, (int)0);
            GlStateManager.func_187410_q((int)32886);
            GL15.glBindBuffer((int)34962, (int)this.colourBufferID);
            GlStateManager.func_187406_e((int)4, (int)5126, (int)0, (int)0);
            GlStateManager.func_187410_q((int)32885);
            GL15.glBindBuffer((int)34962, (int)this.normalBufferID);
            GL11.glNormalPointer((int)5126, (int)0, (long)0L);
            GL11.glDrawArrays((int)7, (int)0, (int)(this.numberIndices * 6 * 4));
            GL15.glBindBuffer((int)34962, (int)arrayBuffer);
            GlStateManager.func_187429_p((int)32884);
            GlStateManager.func_187429_p((int)32886);
            GlStateManager.func_187429_p((int)32885);
            GlStateManager.func_179098_w();
            globalAmbient.put(new float[]{0.4f, 0.4f, 0.4f, 1.0f});
            globalAmbient.rewind();
            GlStateManager.func_179145_e();
            GL11.glLightModel((int)2899, (FloatBuffer)globalAmbient);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            this.rendering = false;
        }
    }

    public void cleanUp() {
        if (this.build) {
            this.build = false;
            GL15.glDeleteBuffers((int)this.vertexBufferID);
            GL15.glDeleteBuffers((int)this.colourBufferID);
            GL15.glDeleteBuffers((int)this.normalBufferID);
        }
    }
}

