/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import lumien.randomthings.item.ItemBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDungeonChestGenerator
extends ItemBase {
    private static Random rng = new Random();

    public ItemDungeonChestGenerator() {
        super("dungeonChestGenerator");
        this.func_77625_d(1);
        this.func_77664_n();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(par1ItemStack, par2EntityPlayer, par3List, par4);
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        if (nbt != null) {
            Set lootTableSet = LootTableList.func_186374_a();
            ArrayList sortedList = new ArrayList(lootTableSet);
            Collections.sort(sortedList, new Comparator<ResourceLocation>(){

                @Override
                public int compare(ResourceLocation rl1, ResourceLocation rl2) {
                    return rl1.toString().compareTo(rl2.toString());
                }
            });
            int tableIndex = nbt.func_74762_e("tableIndex");
            if (tableIndex > 0 && tableIndex < sortedList.size()) {
                ResourceLocation tableLocation = (ResourceLocation)sortedList.get(tableIndex);
                par3List.add(net.minecraft.client.resources.I18n.func_135052_a((String)"item.dungeonChestGenerator.category", (Object[])new Object[]{tableLocation.toString()}));
                par3List.add(net.minecraft.client.resources.I18n.func_135052_a((String)"item.dungeonChestGenerator.shiftCategory", (Object[])new Object[0]));
            }
        }
    }

    public String func_77653_i(ItemStack par1ItemStack) {
        NBTTagCompound nbt = par1ItemStack.func_77978_p();
        if (nbt != null) {
            Set lootTableSet = LootTableList.func_186374_a();
            ArrayList sortedList = new ArrayList(lootTableSet);
            Collections.sort(sortedList, new Comparator<ResourceLocation>(){

                @Override
                public int compare(ResourceLocation rl1, ResourceLocation rl2) {
                    return rl1.toString().compareTo(rl2.toString());
                }
            });
            int tableIndex = nbt.func_74762_e("tableIndex");
            if (tableIndex > 0 && tableIndex < sortedList.size()) {
                ResourceLocation tableLocation = (ResourceLocation)sortedList.get(tableIndex);
                return ("" + I18n.func_74838_a((String)(this.func_77657_g(par1ItemStack) + ".name"))).trim() + " (" + tableLocation.toString() + ")";
            }
        }
        return ("" + I18n.func_74838_a((String)(this.func_77657_g(par1ItemStack) + ".name"))).trim();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer, EnumHand hand) {
        if (!par2World.field_72995_K && par3EntityPlayer.func_70093_af()) {
            NBTTagCompound nbt = par1ItemStack.func_77978_p();
            if (nbt == null) {
                par1ItemStack.func_77982_d(new NBTTagCompound());
                par1ItemStack.func_77978_p().func_74768_a("tableIndex", 0);
            } else {
                int currentCategory = par1ItemStack.func_77978_p().func_74762_e("tableIndex");
                currentCategory = currentCategory + 1 < LootTableList.func_186374_a().size() ? ++currentCategory : 0;
                par1ItemStack.func_77978_p().func_74768_a("tableIndex", currentCategory);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)par1ItemStack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)par1ItemStack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && !playerIn.func_70093_af()) {
            NBTTagCompound nbt;
            if (!playerIn.func_175151_a(pos = pos.func_177972_a(side), side, stack)) {
                return EnumActionResult.FAIL;
            }
            if (worldIn.func_175623_d(pos) && Blocks.field_150486_ae.func_176196_c(worldIn, pos) && (nbt = stack.func_77978_p()) != null) {
                int currentCategory = nbt.func_74762_e("tableIndex");
                Set lootTableSet = LootTableList.func_186374_a();
                ArrayList sortedList = new ArrayList(lootTableSet);
                Collections.sort(sortedList, new Comparator<ResourceLocation>(){

                    @Override
                    public int compare(ResourceLocation rl1, ResourceLocation rl2) {
                        return rl1.toString().compareTo(rl2.toString());
                    }
                });
                if (currentCategory > 0 && currentCategory < sortedList.size()) {
                    ResourceLocation currentTableLocation = (ResourceLocation)sortedList.get(currentCategory);
                    LootTable lootTable = worldIn.func_184146_ak().func_186521_a(currentTableLocation);
                    if (lootTable != null) {
                        worldIn.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
                        IInventory chestInventory = (IInventory)worldIn.func_175625_s(pos);
                        LootContext.Builder builder = new LootContext.Builder((WorldServer)worldIn).func_186470_a(playerIn);
                        lootTable.func_186460_a(chestInventory, worldIn.field_73012_v, builder.func_186471_a());
                    }
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }
}

