/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import lumien.randomthings.RandomThings;
import lumien.randomthings.container.inventories.InventoryItem;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.util.InventoryUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemItemFilter
extends ItemBase {
    public ItemItemFilter() {
        super("itemFilter");
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)RandomThings.instance, 14, worldIn, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public static class ItemFilterRepresentation {
        InventoryItem filterInventory;
        ItemStack filterStack;
        boolean metadata = true;
        boolean nbt = true;
        boolean oreDict = false;
        int listType = 0;

        public ItemFilterRepresentation(ItemStack stack) {
            this.filterInventory = new InventoryItem("ItemFilter", 9, stack);
            this.filterStack = stack;
        }

        public IInventory getFilterInventory() {
            return this.filterInventory;
        }

        public static ItemFilterRepresentation readFromItemStack(ItemStack filterStack) {
            ItemFilterRepresentation representation = new ItemFilterRepresentation(filterStack);
            NBTTagCompound compound = filterStack.func_77978_p();
            if (compound != null) {
                NBTTagCompound inventoryCompound = compound.func_74775_l("inventory");
                if (inventoryCompound != null) {
                    InventoryUtil.readInventoryFromCompound(inventoryCompound, representation.filterInventory);
                }
                representation.metadata = compound.func_74764_b("metadata") ? compound.func_74767_n("metadata") : representation.metadata;
                representation.oreDict = compound.func_74764_b("oreDict") ? compound.func_74767_n("oreDict") : representation.oreDict;
                representation.nbt = compound.func_74764_b("nbt") ? compound.func_74767_n("nbt") : representation.nbt;
                representation.listType = compound.func_74764_b("listType") ? compound.func_74762_e("listType") : representation.listType;
            }
            return representation;
        }

        public void writeToItemStack() {
            NBTTagCompound compound = this.filterStack.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
                this.filterStack.func_77982_d(compound);
            }
            NBTTagCompound inventoryCompound = new NBTTagCompound();
            InventoryUtil.writeInventoryToCompound(inventoryCompound, this.filterInventory);
            compound.func_74782_a("inventory", (NBTBase)inventoryCompound);
            compound.func_74757_a("metadata", this.metadata);
            compound.func_74757_a("oreDict", this.oreDict);
            compound.func_74757_a("nbt", this.nbt);
            compound.func_74768_a("listType", this.listType);
        }

        public boolean matchesItemStack(ItemStack stackToCheck) {
            boolean matches = false;
            for (int i = 0; i < this.filterInventory.func_70302_i_(); ++i) {
                ItemStack item = this.filterInventory.func_70301_a(i);
                if (item == null) continue;
                if (this.oreDict) {
                    int[] idList = OreDictionary.getOreIDs((ItemStack)item);
                    int[] checkList = OreDictionary.getOreIDs((ItemStack)stackToCheck);
                    for (int id : idList) {
                        for (int id2 : checkList) {
                            if (id != id2) continue;
                            matches = true;
                            break;
                        }
                        if (matches) break;
                    }
                }
                if (matches) break;
                if (item.func_77973_b() != stackToCheck.func_77973_b() || this.metadata && item.func_77952_i() != stackToCheck.func_77952_i() || this.nbt && !ItemStack.func_77970_a((ItemStack)item, (ItemStack)stackToCheck)) continue;
                matches = true;
                break;
            }
            if (this.listType == 0) {
                return matches;
            }
            return !matches;
        }

        public boolean respectOreDictionary() {
            return this.oreDict;
        }

        public boolean respectMetadata() {
            return this.metadata;
        }

        public boolean respectNBT() {
            return this.nbt;
        }

        public int getListType() {
            return this.listType;
        }

        public void toggleMetadata() {
            this.metadata = !this.metadata;
        }

        public void toggleOreDict() {
            this.oreDict = !this.oreDict;
        }

        public void toggleNBT() {
            this.nbt = !this.nbt;
        }

        public void toggleListType() {
            this.listType = this.listType == 0 ? 1 : 0;
        }
    }
}

