/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.tileentity;

import java.awt.Color;
import java.util.ArrayList;
import lumien.randomthings.client.particles.EntityColoredSmokeFX;
import lumien.randomthings.item.ItemBiomeCrystal;
import lumien.randomthings.item.ItemPositionFilter;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.network.MessageUtil;
import lumien.randomthings.network.messages.sync.MessageBiomeRadarAntenna;
import lumien.randomthings.tileentity.TileEntityBase;
import lumien.randomthings.util.client.RenderUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBiomeRadar
extends TileEntityBase
implements ITickable {
    ItemStack currentCrystal;
    boolean powered;
    STATE state = STATE.IDLE;
    Biome biomeToSearch;
    int searchCounter = 0;
    int antennaCounter = 0;
    String[] antennaBiomes = new String[4];
    int testCounter = 0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.testCounter;
            if (this.testCounter % 60 == 0 && this.state != STATE.IDLE && !this.isValid()) {
                this.state = STATE.IDLE;
                this.syncTE();
            }
            if (this.state == STATE.SEARCHING) {
                boolean changedColor = false;
                for (int i = 0; i < 5; ++i) {
                    BlockPos testPos = this.getPos(this.searchCounter);
                    Biome testBiome = this.field_145850_b.func_180494_b(testPos);
                    ResourceLocation registryName = testBiome.getRegistryName();
                    boolean exist = false;
                    for (int s = 0; s < 4; ++s) {
                        if (!registryName.toString().equals(this.antennaBiomes[s])) continue;
                        exist = true;
                    }
                    if (!exist) {
                        this.antennaBiomes[this.antennaCounter] = registryName.toString();
                        changedColor = true;
                        this.antennaCounter = this.antennaCounter >= 3 ? 0 : ++this.antennaCounter;
                    }
                    if (testBiome == this.biomeToSearch) {
                        this.state = STATE.FINISHED;
                        this.syncTE();
                        break;
                    }
                    ++this.searchCounter;
                }
                if (this.searchCounter % 100 == 0 && this.field_145850_b != null && changedColor) {
                    changedColor = false;
                    MessageBiomeRadarAntenna message = new MessageBiomeRadarAntenna(this.antennaBiomes, this.field_174879_c);
                    MessageUtil.sendToAllWatchingPos(this.field_145850_b, this.field_174879_c, message);
                }
            }
        } else {
            this.spawnParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        Biome b;
        if (this.state == STATE.SEARCHING) {
            for (int i = 0; i < 4; ++i) {
                String biomeName;
                Biome biome;
                if (this.antennaBiomes[i] == null || (biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(biomeName = this.antennaBiomes[i]))) == null) continue;
                Color color = new Color(RenderUtils.getBiomeColor(null, biome, this.field_174879_c));
                EntityColoredSmokeFX particle = new EntityColoredSmokeFX(this.field_145850_b, i < 2 ? (double)this.field_174879_c.func_177958_n() + 1.5 - (double)(i * 2) : (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 4.1, i > 1 ? (double)this.field_174879_c.func_177952_p() + 1.5 - (double)((i - 2) * 2) : (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                particle.func_70538_b(0.003921569f * (float)color.getRed(), 0.003921569f * (float)color.getGreen(), 0.003921569f * (float)color.getBlue());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            }
        } else if (this.state == STATE.FINISHED && (b = ItemBiomeCrystal.getBiome(this.currentCrystal)) != null) {
            Color color = new Color(RenderUtils.getBiomeColor(null, b, this.field_174879_c));
            for (int i = 0; i < 4; ++i) {
                EntityColoredSmokeFX particle = new EntityColoredSmokeFX(this.field_145850_b, i < 2 ? (double)this.field_174879_c.func_177958_n() + 1.5 - (double)(i * 2) : (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 4.1, i > 1 ? (double)this.field_174879_c.func_177952_p() + 1.5 - (double)((i - 2) * 2) : (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                particle.func_70538_b(0.003921569f * (float)color.getRed(), 0.003921569f * (float)color.getGreen(), 0.003921569f * (float)color.getBlue());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            }
            EntityColoredSmokeFX particle = new EntityColoredSmokeFX(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 3.1, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            particle.func_70538_b(0.003921569f * (float)color.getRed(), 0.003921569f * (float)color.getGreen(), 0.003921569f * (float)color.getBlue());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
        }
    }

    private BlockPos getPos(int n) {
        double x = 0.0;
        double z = 0.0;
        double r = Math.floor((Math.sqrt(n + 1) - 1.0) / 2.0) + 1.0;
        double p = 8.0 * r * (r - 1.0) / 2.0;
        double en = r * 2.0;
        double a = ((double)(1 + n) - p) % (r * 8.0);
        switch ((int)Math.floor(a / (r * 2.0))) {
            case 0: {
                x = a - r;
                z = -r;
                break;
            }
            case 1: {
                x = r;
                z = a % en - r;
                break;
            }
            case 2: {
                x = r - a % en;
                z = r;
                break;
            }
            case 3: {
                x = -r;
                z = r - a % en;
            }
        }
        return new BlockPos((double)this.field_174879_c.func_177958_n() + x * 48.0, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + z * 48.0);
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
        if (this.currentCrystal != null) {
            compound.func_74782_a("currentCrystal", (NBTBase)this.currentCrystal.serializeNBT());
        }
        compound.func_74768_a("state", this.state.ordinal());
        compound.func_74757_a("powered", this.powered);
        if (this.biomeToSearch != null) {
            compound.func_74778_a("biomeToSearch", this.biomeToSearch.getRegistryName().toString());
        }
        compound.func_74768_a("searchCounter", this.searchCounter);
        compound.func_74768_a("antennaCounter", this.antennaCounter);
        for (int i = 0; i < this.antennaBiomes.length; ++i) {
            if (this.antennaBiomes[i] == null) continue;
            compound.func_74778_a("antennaBiome" + i, this.antennaBiomes[i]);
        }
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
        this.currentCrystal = ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("currentCrystal"));
        this.state = STATE.values()[compound.func_74762_e("state")];
        this.powered = compound.func_74767_n("powered");
        if (compound.func_74764_b("biomeToSearch")) {
            this.biomeToSearch = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("biomeToSearch")));
        }
        this.searchCounter = compound.func_74762_e("searchCounter");
        this.antennaCounter = compound.func_74762_e("antennaCounter");
        for (int i = 0; i < this.antennaBiomes.length; ++i) {
            if (!compound.func_74764_b("antennaBiome" + i)) continue;
            this.antennaBiomes[i] = compound.func_74779_i("antennaBiome" + i);
        }
    }

    public ItemStack getCurrentCrystal() {
        return this.currentCrystal;
    }

    public void setCrystal(ItemStack crystal) {
        this.currentCrystal = crystal;
        this.syncTE();
    }

    public STATE getState() {
        return this.state;
    }

    public void neighborChanged(Block neighborBlock) {
        boolean newPowered = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        boolean changed = false;
        if (!this.powered && newPowered && this.state == STATE.IDLE && this.currentCrystal != null && this.isValid()) {
            Biome biome = ItemBiomeCrystal.getBiome(this.currentCrystal);
            if (biome != null) {
                this.state = STATE.SEARCHING;
                this.searchCounter = 0;
                this.biomeToSearch = biome;
                changed = true;
            }
        } else if (this.state == STATE.SEARCHING && !newPowered && this.powered) {
            this.state = STATE.IDLE;
            changed = true;
        } else if (this.state == STATE.FINISHED && this.powered && !newPowered) {
            this.state = STATE.IDLE;
            changed = true;
        }
        this.powered = newPowered;
        if (changed) {
            this.syncTE();
        }
    }

    public void setAntennaBiomes(String[] antennaBiomes) {
        this.antennaBiomes = antennaBiomes;
    }

    public ItemStack generatePositionFilter() {
        BlockPos pos = this.getPos(this.searchCounter);
        ItemStack positionFilter = new ItemStack((Item)ModItems.positionFilter);
        ItemPositionFilter.setPosition(positionFilter, this.field_145850_b.field_73011_w.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return positionFilter;
    }

    private boolean isValid() {
        ArrayList<BlockPos> posToCheck = new ArrayList<BlockPos>();
        posToCheck.add(this.field_174879_c.func_177972_a(EnumFacing.UP));
        posToCheck.add(this.field_174879_c.func_177967_a(EnumFacing.UP, 2));
        posToCheck.add(this.field_174879_c.func_177982_a(1, 2, 0));
        posToCheck.add(this.field_174879_c.func_177982_a(-1, 2, 0));
        posToCheck.add(this.field_174879_c.func_177982_a(1, 3, 0));
        posToCheck.add(this.field_174879_c.func_177982_a(-1, 3, 0));
        posToCheck.add(this.field_174879_c.func_177982_a(0, 2, 1));
        posToCheck.add(this.field_174879_c.func_177982_a(0, 2, -1));
        posToCheck.add(this.field_174879_c.func_177982_a(0, 3, 1));
        posToCheck.add(this.field_174879_c.func_177982_a(0, 3, -1));
        for (BlockPos pos : posToCheck) {
            if (this.field_145850_b.func_180495_p(pos).func_177230_c() == Blocks.field_150411_aY) continue;
            return false;
        }
        return true;
    }

    public static enum STATE {
        IDLE,
        SEARCHING,
        FINISHED;

    }
}

