/*
 * Decompiled with CFR 0.152.
 */
package exter.substratum.block;

import exter.substratum.block.BlockDustOre;
import exter.substratum.block.BlockMetal;
import exter.substratum.block.BlockMetalSlab;
import exter.substratum.block.BlockMetalStairs;
import exter.substratum.block.BlockOre;
import exter.substratum.item.ItemBlockMulti;
import exter.substratum.material.EnumMaterial;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;

public class SubstratumBlocks {
    private static final BlockMetal.Variant[] BLOCK1_METALS = new BlockMetal.Variant[]{new BlockMetal.Variant(EnumMaterial.COPPER), new BlockMetal.Variant(EnumMaterial.TIN), new BlockMetal.Variant(EnumMaterial.BRONZE), new BlockMetal.Variant(EnumMaterial.ELECTRUM), new BlockMetal.Variant(EnumMaterial.INVAR), new BlockMetal.Variant(EnumMaterial.NICKEL), new BlockMetal.Variant(EnumMaterial.ZINC), new BlockMetal.Variant(EnumMaterial.BRASS), new BlockMetal.Variant(EnumMaterial.SILVER), new BlockMetal.Variant(EnumMaterial.STEEL), new BlockMetal.Variant(EnumMaterial.LEAD), new BlockMetal.Variant(EnumMaterial.PLATINUM), new BlockMetal.Variant(EnumMaterial.CUPRONICKEL), new BlockMetal.Variant(EnumMaterial.SIGNALUM), new BlockMetal.Variant(EnumMaterial.LUMIUM)};
    private static final BlockMetal.Variant[] BLOCK2_METALS = new BlockMetal.Variant[]{new BlockMetal.Variant(EnumMaterial.ENDERIUM), new BlockMetal.Variant(EnumMaterial.ALUMINIUM), new BlockMetal.Variant(EnumMaterial.CHROMIUM)};
    private static final BlockMetalSlab.Variant[] SLAB1_METALS = new BlockMetalSlab.Variant[]{new BlockMetalSlab.Variant(EnumMaterial.IRON), new BlockMetalSlab.Variant(EnumMaterial.GOLD), new BlockMetalSlab.Variant(EnumMaterial.COPPER), new BlockMetalSlab.Variant(EnumMaterial.TIN), new BlockMetalSlab.Variant(EnumMaterial.BRONZE), new BlockMetalSlab.Variant(EnumMaterial.ELECTRUM), new BlockMetalSlab.Variant(EnumMaterial.INVAR), new BlockMetalSlab.Variant(EnumMaterial.NICKEL)};
    private static final BlockMetalSlab.Variant[] SLAB2_METALS = new BlockMetalSlab.Variant[]{new BlockMetalSlab.Variant(EnumMaterial.ZINC), new BlockMetalSlab.Variant(EnumMaterial.BRASS), new BlockMetalSlab.Variant(EnumMaterial.SILVER), new BlockMetalSlab.Variant(EnumMaterial.STEEL), new BlockMetalSlab.Variant(EnumMaterial.LEAD), new BlockMetalSlab.Variant(EnumMaterial.PLATINUM), new BlockMetalSlab.Variant(EnumMaterial.CUPRONICKEL), new BlockMetalSlab.Variant(EnumMaterial.SIGNALUM)};
    private static final BlockMetalSlab.Variant[] SLAB3_METALS = new BlockMetalSlab.Variant[]{new BlockMetalSlab.Variant(EnumMaterial.LUMIUM), new BlockMetalSlab.Variant(EnumMaterial.ENDERIUM), new BlockMetalSlab.Variant(EnumMaterial.ALUMINIUM), new BlockMetalSlab.Variant(EnumMaterial.CHROMIUM)};
    public static BlockMetal[] block_metal;
    public static BlockOre block_ore;
    public static BlockDustOre block_ore_dust;
    public static BlockMetalSlab[] block_slab;
    public static BlockMetalSlab[] block_slabdouble;
    public static final Map<EnumMaterial, ItemStack> ore_stacks;
    public static final Map<EnumMaterial, ItemStack> block_stacks;
    public static final Map<EnumMaterial, ItemStack> slab_stacks;
    public static final Map<EnumMaterial, ItemStack> stairs_stacks;

    public static void register(Block block) {
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    private static <T extends Block> void registerMulti(T block) {
        GameRegistry.register(block);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockMulti(block).setRegistryName(block.getRegistryName()));
    }

    private static void registerSlab(BlockSlab block, BlockSlab slabdouble) {
        GameRegistry.register((IForgeRegistryEntry)block);
        GameRegistry.register((IForgeRegistryEntry)new ItemSlab((Block)block, block, slabdouble).setRegistryName(block.getRegistryName()));
    }

    private static void registerHalfSlabs() {
        block_slab = new BlockMetalSlab[3];
        SubstratumBlocks.block_slab[0] = new BlockMetalSlab(null, "slab1"){

            @Override
            public BlockMetalSlab.Variant[] getVariants() {
                return SLAB1_METALS;
            }
        };
        SubstratumBlocks.block_slab[1] = new BlockMetalSlab(null, "slab2"){

            @Override
            public BlockMetalSlab.Variant[] getVariants() {
                return SLAB2_METALS;
            }
        };
        SubstratumBlocks.block_slab[2] = new BlockMetalSlab(null, "slab3"){

            @Override
            public BlockMetalSlab.Variant[] getVariants() {
                return SLAB3_METALS;
            }
        };
        block_slabdouble = new BlockMetalSlab[3];
        SubstratumBlocks.block_slabdouble[0] = new BlockMetalSlab(block_slab[0], "slabDouble1"){

            @Override
            public BlockMetalSlab.Variant[] getVariants() {
                return SLAB1_METALS;
            }

            @Override
            public IProperty<BlockMetalSlab.Variant> func_176551_l() {
                return block_slab[0].func_176551_l();
            }
        };
        SubstratumBlocks.block_slabdouble[1] = new BlockMetalSlab(block_slab[1], "slabDouble2"){

            @Override
            public BlockMetalSlab.Variant[] getVariants() {
                return SLAB2_METALS;
            }

            @Override
            public IProperty<BlockMetalSlab.Variant> func_176551_l() {
                return block_slab[1].func_176551_l();
            }
        };
        SubstratumBlocks.block_slabdouble[2] = new BlockMetalSlab(block_slab[2], "slabDouble3"){

            @Override
            public BlockMetalSlab.Variant[] getVariants() {
                return SLAB3_METALS;
            }

            @Override
            public IProperty<BlockMetalSlab.Variant> func_176551_l() {
                return block_slab[2].func_176551_l();
            }
        };
        for (int i = 0; i < block_slab.length; ++i) {
            BlockMetalSlab slab = block_slab[i];
            BlockMetalSlab slabdouble = block_slabdouble[i];
            SubstratumBlocks.registerSlab(slab, slabdouble);
            SubstratumBlocks.registerSlab(slabdouble, slabdouble);
            for (BlockMetalSlab.Variant v : block_slab[i].getVariants()) {
                IBlockState state = block_slab[i].getBottomVariant(v);
                ItemStack item = new ItemStack((Block)block_slab[i], 1, block_slab[i].func_176201_c(state));
                slab_stacks.put(v.material, item);
                OreDictionary.registerOre((String)("slab" + v.material.suffix), (ItemStack)item);
            }
        }
    }

    private static void registerStairs(EnumMaterial material, IBlockState model_state) {
        BlockMetalStairs block = new BlockMetalStairs(model_state, material);
        SubstratumBlocks.register((Block)block);
        ItemStack item = new ItemStack((Block)block);
        stairs_stacks.put(material, item);
        OreDictionary.registerOre((String)("stairs" + material.suffix), (ItemStack)item);
    }

    public static void registerBlocks() {
        ItemStack item;
        block_metal = new BlockMetal[2];
        SubstratumBlocks.block_metal[0] = new BlockMetal("blockMetal1"){

            @Override
            public BlockMetal.Variant[] getVariants() {
                return BLOCK1_METALS;
            }
        };
        SubstratumBlocks.block_metal[1] = new BlockMetal("blockMetal2"){

            @Override
            public BlockMetal.Variant[] getVariants() {
                return BLOCK2_METALS;
            }
        };
        block_ore = new BlockOre();
        block_ore_dust = new BlockDustOre();
        for (int i = 0; i < block_metal.length; ++i) {
            SubstratumBlocks.registerMulti(block_metal[i]);
            for (IStringSerializable iStringSerializable : block_metal[i].getVariants()) {
                IBlockState state = block_metal[i].getVariantState((BlockMetal.Variant)iStringSerializable);
                ItemStack item2 = new ItemStack((Block)block_metal[i], 1, block_metal[i].func_176201_c(state));
                block_stacks.put(iStringSerializable.material, item2);
                OreDictionary.registerOre((String)("block" + iStringSerializable.material.suffix), (ItemStack)item2);
                SubstratumBlocks.registerStairs(iStringSerializable.material, state);
            }
        }
        SubstratumBlocks.registerMulti(block_ore);
        for (IStringSerializable iStringSerializable : BlockOre.EnumVariant.values()) {
            item = block_ore.asItemStack((BlockOre.EnumVariant)iStringSerializable);
            ore_stacks.put(iStringSerializable.material, item);
            OreDictionary.registerOre((String)("ore" + iStringSerializable.material.suffix), (ItemStack)item);
        }
        SubstratumBlocks.registerMulti(block_ore_dust);
        for (IStringSerializable iStringSerializable : BlockDustOre.EnumVariant.values()) {
            item = block_ore_dust.asItemStack((BlockDustOre.EnumVariant)iStringSerializable);
            ore_stacks.put(iStringSerializable.material, item);
            OreDictionary.registerOre((String)("ore" + iStringSerializable.material.suffix), (ItemStack)item);
        }
        SubstratumBlocks.registerHalfSlabs();
        SubstratumBlocks.registerStairs(EnumMaterial.IRON, Blocks.field_150339_S.func_176223_P());
        SubstratumBlocks.registerStairs(EnumMaterial.GOLD, Blocks.field_150340_R.func_176223_P());
    }

    static {
        ore_stacks = new EnumMap<EnumMaterial, ItemStack>(EnumMaterial.class);
        block_stacks = new EnumMap<EnumMaterial, ItemStack>(EnumMaterial.class);
        slab_stacks = new EnumMap<EnumMaterial, ItemStack>(EnumMaterial.class);
        stairs_stacks = new EnumMap<EnumMaterial, ItemStack>(EnumMaterial.class);
    }
}

