/*
 * Decompiled with CFR 0.152.
 */
package exter.substratum.fluid;

import exter.substratum.fluid.SubstratumFluids;
import exter.substratum.item.ItemMaterial;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidContainerCapability
implements ICapabilityProvider,
IFluidHandler {
    private final ItemStack item;
    private final int amount;

    public FluidContainerCapability(ItemStack item, int amount) {
        this.item = item;
        this.amount = amount;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    private Fluid getFluid() {
        return SubstratumFluids.material_fluids.get(((ItemMaterial)this.item.func_77973_b()).item.materials.get(this.item.func_77960_j()));
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(this.getFluid(), this.amount), this.amount)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        Fluid fluid = this.getFluid();
        if (this.item.field_77994_a != 1 || resource == null || resource.amount < this.amount || !resource.getFluid().getName().equals(fluid.getName())) {
            return null;
        }
        if (doDrain) {
            this.item.deserializeNBT(new ItemStack(this.item.func_77973_b().func_77668_q()).serializeNBT());
        }
        return new FluidStack(fluid, this.amount);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        Fluid fluid = this.getFluid();
        if (this.item.field_77994_a != 1 || maxDrain < this.amount) {
            return null;
        }
        if (doDrain) {
            this.item.deserializeNBT(new ItemStack(this.item.func_77973_b().func_77668_q()).serializeNBT());
        }
        return new FluidStack(fluid, this.amount);
    }
}

