/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.bakery;

import codechicken.lib.colour.Colour;
import codechicken.lib.render.Vertex5;
import codechicken.lib.render.uv.UV;
import codechicken.lib.vec.Vector3;
import java.util.LinkedList;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class CCQuadBakery {
    private LinkedList<Vertex5> vertices = new LinkedList();
    private LinkedList<Vector3> normals = new LinkedList();
    private LinkedList<Colour> colours = new LinkedList();
    private LinkedList<UV> lightMaps = new LinkedList();
    private VertexFormat format;
    private TextureAtlasSprite sprite;
    private EnumFacing face;

    public CCQuadBakery(TextureAtlasSprite sprite, EnumFacing face) {
        this(DefaultVertexFormats.field_176600_a, sprite, face);
    }

    public CCQuadBakery(VertexFormat format, TextureAtlasSprite sprite, EnumFacing face) {
        this.format = format;
        this.sprite = sprite;
        this.face = face;
    }

    public CCQuadBakery putVertex(double xPos, double yPos, double zPos, UV uv, Colour colour) {
        return this.putVertex(new Vector3(xPos, yPos, zPos), uv, colour);
    }

    public CCQuadBakery putVertex(double xPos, double yPos, double zPos, double u, double v, Colour colour) {
        return this.putVertex(new Vector3(xPos, yPos, zPos), new UV(u, v), colour);
    }

    public CCQuadBakery putVertex(Vector3 pos, UV uv, Colour colour) {
        return this.putVertex(new Vertex5(pos, uv), null, colour, null);
    }

    public CCQuadBakery putVertex(Vector3 pos, UV uv, Vector3 normal, Colour colour) {
        return this.putVertex(new Vertex5(pos, uv), normal, colour, null);
    }

    public CCQuadBakery putVertex(Vector3 pos, UV uv, Vector3 normal, Colour colour, UV lightMap) {
        return this.putVertex(new Vertex5(pos, uv), normal, colour, lightMap);
    }

    public CCQuadBakery putVertex(Vertex5 vertex, Vector3 normal, Colour colour, UV lightMap) {
        if (this.vertices.size() == 4) {
            throw new IllegalArgumentException("Unable to add 5 vertices to a quad!");
        }
        this.vertices.add(vertex);
        if (normal != null) {
            this.normals.add(normal);
        }
        if (colour != null) {
            this.colours.add(colour);
        }
        if (lightMap != null) {
            this.lightMaps.add(lightMap);
        }
        return this;
    }

    private void quadulate() {
        if (this.vertices.size() == 3) {
            if (this.normals.size() != 0 && this.normals.size() != 3) {
                throw new IllegalArgumentException("Unable to quadulate triangle model as not all normals exist!");
            }
            this.vertices.add(this.vertices.get(2));
            if (this.normals.size() != 0) {
                this.normals.add(this.normals.get(2));
            }
        }
    }

    @Deprecated
    public CCQuadBakery interpolateUVs() {
        LinkedList<Vertex5> verts = new LinkedList<Vertex5>(this.vertices);
        this.vertices = new LinkedList();
        for (Vertex5 vert : verts) {
            vert.uv.u = this.sprite.func_94214_a(vert.uv.u);
            vert.uv.v = this.sprite.func_94207_b(vert.uv.v);
            this.vertices.add(vert);
        }
        return this;
    }

    private void fill() {
        int i;
        if (this.colours.size() == 1) {
            Colour colour = this.colours.get(0);
            for (i = 1; i < 4; ++i) {
                this.colours.add(colour);
            }
        }
        if (this.lightMaps.size() == 1) {
            UV lightMap = this.lightMaps.get(0);
            for (i = 1; i < 4; ++i) {
                this.lightMaps.add(lightMap);
            }
        }
    }

    private void computeNormals() {
        if (this.normals.size() == 0) {
            if (this.vertices.size() == 3) {
                this.quadulate();
            }
            Vector3 diff1 = this.vertices.get((int)1).vec.copy().subtract(this.vertices.get((int)0).vec);
            Vector3 diff2 = this.vertices.get((int)3).vec.copy().subtract(this.vertices.get((int)0).vec);
            Vector3 normal = diff1.crossProduct(diff2).normalize();
            this.normals = new LinkedList();
            this.normals.add(normal.copy());
            this.normals.add(normal.copy());
            this.normals.add(normal.copy());
            this.normals.add(normal.copy());
        }
    }

    public BakedQuad bake() {
        this.quadulate();
        this.fill();
        if (this.format.func_177350_b()) {
            this.computeNormals();
        }
        UnpackedBakedQuad.Builder quadBuilder = new UnpackedBakedQuad.Builder(this.format);
        quadBuilder.setTexture(this.sprite);
        quadBuilder.setQuadOrientation(this.face);
        for (int i = 0; i < this.vertices.size(); ++i) {
            block7: for (int e = 0; e < this.format.func_177345_h(); ++e) {
                switch (this.format.func_177348_c(e).func_177375_c()) {
                    case POSITION: {
                        Vector3 pos = this.vertices.get((int)i).vec;
                        quadBuilder.put(e, new float[]{(float)pos.x, (float)pos.y, (float)pos.z});
                        continue block7;
                    }
                    case NORMAL: {
                        Vector3 normal = this.normals.get(i);
                        quadBuilder.put(e, new float[]{(float)normal.x, (float)normal.y, (float)normal.z});
                        continue block7;
                    }
                    case COLOR: {
                        Colour colour = this.colours.get(i);
                        quadBuilder.put(e, new float[]{(colour.r & 0xFF) / 255, (colour.g & 0xFF) / 255, (colour.b & 0xFF) / 255, (colour.a & 0xFF) / 255});
                        continue block7;
                    }
                    case UV: {
                        UV uv;
                        if (this.format.func_177348_c(e).func_177369_e() == 0) {
                            uv = this.vertices.get((int)i).uv;
                            quadBuilder.put(e, new float[]{(float)uv.u, (float)uv.v});
                            continue block7;
                        }
                        if (this.lightMaps.size() == 0) {
                            quadBuilder.put(e, new float[0]);
                            continue block7;
                        }
                        uv = this.lightMaps.get(i);
                        quadBuilder.put(e, new float[]{(float)uv.u, (float)uv.v});
                        continue block7;
                    }
                    default: {
                        quadBuilder.put(e, new float[0]);
                    }
                }
            }
        }
        return quadBuilder.build();
    }
}

