/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.loader;

import codechicken.lib.model.loader.IBakedModelLoader;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.thread.RestartableTask;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import org.apache.logging.log4j.Level;

public class CCBakedModelLoader
implements TextureUtils.IIconRegister,
IResourceManagerReloadListener {
    public static final CCBakedModelLoader INSTANCE = new CCBakedModelLoader();
    private static final Map<String, IBakedModel> modelCache = new HashMap<String, IBakedModel>();
    private static final Map<String, IBakedModelLoader.IModKeyProvider> modelBakeQue = new HashMap<String, IBakedModelLoader.IModKeyProvider>();
    private static final ModelBakeTask bakingTask = new ModelBakeTask();
    private static final Map<String, IBakedModelLoader.IModKeyProvider> modKeyProviders = new HashMap<String, IBakedModelLoader.IModKeyProvider>();
    private static final Map<IBakedModelLoader.IModKeyProvider, IBakedModelLoader> modelLoaders = new HashMap<IBakedModelLoader.IModKeyProvider, IBakedModelLoader>();

    public static void registerLoader(IBakedModelLoader loader) {
        if (Loader.instance().hasReachedState(LoaderState.INITIALIZATION)) {
            throw new RuntimeException("Unable to register IBakedModelLoader after Pre Initialization! Please register as the first thing you do in Pre Init!");
        }
        if (modelLoaders.containsValue(loader)) {
            throw new RuntimeException("Unable to register IBakedModelLoader as it has already been registered!");
        }
        IBakedModelLoader.IModKeyProvider provider = loader.createKeyProvider();
        FMLLog.log((String)"CodeChicken Lib", (Level)Level.INFO, (String)"Registered loader for mod: %s", (Object[])new Object[]{provider.getMod()});
        modelLoaders.put(provider, loader);
        modKeyProviders.put(provider.getMod(), provider);
    }

    @Override
    public void registerIcons(TextureMap textureMap) {
        for (ResourceLocation location : CCBakedModelLoader.getTextures()) {
            textureMap.func_174942_a(location);
        }
    }

    public void func_110549_a(IResourceManager resourceManager) {
        modelCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<String, IBakedModel> map = modelCache;
        synchronized (map) {
            modelCache.clear();
        }
    }

    private static Collection<ResourceLocation> getTextures() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IBakedModelLoader loader : modelLoaders.values()) {
            loader.addTextures((ImmutableList.Builder<ResourceLocation>)builder);
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized IBakedModel getModel(IBlockState state) {
        if (state.func_177230_c() == null || state.func_177230_c().getRegistryName() == null) {
            return null;
        }
        ResourceLocation location = state.func_177230_c().getRegistryName();
        IBakedModelLoader.IModKeyProvider provider = modKeyProviders.get(location.func_110624_b());
        if (provider == null) {
            FMLLog.bigWarning((String)"Unable to find IModKeyProvider for domain %s!", (Object[])new Object[]{location.func_110624_b()});
            return null;
        }
        String key = provider.createKey(state);
        if (key == null) {
            return null;
        }
        String mapKey = location.toString() + "|" + key;
        Map<String, IBakedModel> map = modelCache;
        synchronized (map) {
            if (!modelCache.containsKey(mapKey)) {
                IBakedModelLoader loader = modelLoaders.get(provider);
                IBakedModel model = loader.bakeModel(key);
                if (model == null) {
                    return null;
                }
                modelCache.put(mapKey, model);
            }
            return modelCache.get(mapKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized IBakedModel getModel(ItemStack stack) {
        if (stack.func_77973_b() == null || stack.func_77973_b().getRegistryName() == null) {
            return null;
        }
        ResourceLocation location = stack.func_77973_b().getRegistryName();
        IBakedModelLoader.IModKeyProvider provider = modKeyProviders.get(location.func_110624_b());
        if (provider == null) {
            FMLLog.bigWarning((String)"Unable to find IModKeyProvider for domain %s!", (Object[])new Object[]{location.func_110624_b()});
            return null;
        }
        String key = provider.createKey(stack);
        if (key == null) {
            return null;
        }
        String mapKey = location.toString() + "|" + key;
        Map<String, IBakedModel> map = modelCache;
        synchronized (map) {
            if (!modelCache.containsKey(mapKey)) {
                if (modelBakeQue.containsKey(mapKey)) {
                    return null;
                }
                bakingTask.stop();
                modelBakeQue.put(mapKey, provider);
                bakingTask.restart();
            }
            return modelCache.get(mapKey);
        }
    }

    static {
        TextureUtils.addIconRegister(INSTANCE);
        TextureUtils.registerReloadListener(INSTANCE);
    }

    public static class ModelBakeTask
    extends RestartableTask {
        public ModelBakeTask() {
            super("CodeChicken Lib Dynamic model baking");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() {
            HashMap localQue = new HashMap(modelBakeQue);
            Iterator queIterator = localQue.entrySet().iterator();
            while (queIterator.hasNext()) {
                if (this.interrupted()) {
                    return;
                }
                Map.Entry entry = queIterator.next();
                IBakedModelLoader loader = (IBakedModelLoader)modelLoaders.get(entry.getValue());
                String key = ModelBakeTask.stripMapHeader((String)entry.getKey());
                IBakedModel model = loader.bakeModel(key);
                queIterator.remove();
                Map map = modelBakeQue;
                synchronized (map) {
                    modelBakeQue.remove(entry.getKey());
                }
                if (model == null) continue;
                map = modelCache;
                synchronized (map) {
                    modelCache.put(entry.getKey(), model);
                }
            }
        }

        private static String stripMapHeader(String mapKey) {
            int firstPipe = mapKey.indexOf(124);
            return mapKey.substring(firstPipe + 1);
        }
    }
}

