/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.uv.UV;
import codechicken.lib.vec.RedundantTransformation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class CCOBJParser {
    private static final Pattern vertPattern = Pattern.compile("v(?: ([\\d\\.+-]+))+");
    private static final Pattern uvwPattern = Pattern.compile("vt(?: ([\\d\\.+-]+))+");
    private static final Pattern normalPattern = Pattern.compile("vn(?: ([\\d\\.+-]+))+");
    private static final Pattern polyPattern = Pattern.compile("f(?: ((?:\\d*)(?:/\\d*)?(?:/\\d*)?))+");
    public static final Matcher vertMatcher = vertPattern.matcher("");
    public static final Matcher uvwMatcher = uvwPattern.matcher("");
    public static final Matcher normalMatcher = normalPattern.matcher("");
    public static final Matcher polyMatcher = polyPattern.matcher("");

    public static Map<String, CCModel> parseObjModels(ResourceLocation res) {
        return CCOBJParser.parseObjModels(res, null);
    }

    public static Map<String, CCModel> parseObjModels(ResourceLocation res, Transformation coordSystem) {
        return CCOBJParser.parseObjModels(res, 4, coordSystem);
    }

    public static Map<String, CCModel> parseObjModels(ResourceLocation res, int vertexMode, Transformation coordSystem) {
        try {
            return CCOBJParser.parseObjModels(Minecraft.func_71410_x().func_110442_L().func_110536_a(res).func_110527_b(), vertexMode, coordSystem);
        }
        catch (Exception e) {
            throw new RuntimeException("failed to load model: " + res, e);
        }
    }

    public static Map<String, CCModel> parseObjModels(InputStream input, int vertexMode, Transformation coordSystem) throws IOException {
        String line;
        if (coordSystem == null) {
            coordSystem = new RedundantTransformation();
        }
        int vp = vertexMode == 7 ? 4 : 3;
        HashMap<String, CCModel> modelMap = new HashMap<String, CCModel>();
        ArrayList<Vector3> verts = new ArrayList<Vector3>();
        ArrayList<Vector3> uvs = new ArrayList<Vector3>();
        ArrayList<Vector3> normals = new ArrayList<Vector3>();
        ArrayList<int[]> polys = new ArrayList<int[]>();
        String modelName = "unnamed";
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        while ((line = reader.readLine()) != null) {
            double[] values;
            if ((line = line.replaceAll("\\s+", " ").trim()).startsWith("#") || line.length() == 0) continue;
            if (line.startsWith("v ")) {
                CCModel.assertMatch(vertMatcher, line);
                values = CCModel.parseDoubles(line.substring(2), " ");
                CCModel.illegalAssert(values.length >= 3, "Vertices must have x, y and z components");
                Vector3 vert = new Vector3(values[0], values[1], values[2]);
                coordSystem.apply(vert);
                verts.add(vert);
                continue;
            }
            if (line.startsWith("vt ")) {
                CCModel.assertMatch(uvwMatcher, line);
                values = CCModel.parseDoubles(line.substring(3), " ");
                CCModel.illegalAssert(values.length >= 2, "Tex Coords must have u, and v components");
                uvs.add(new Vector3(values[0], 1.0 - values[1], 0.0));
                continue;
            }
            if (line.startsWith("vn ")) {
                CCModel.assertMatch(normalMatcher, line);
                values = CCModel.parseDoubles(line.substring(3), " ");
                CCModel.illegalAssert(values.length >= 3, "Normals must have x, y and z components");
                Vector3 norm = new Vector3(values[0], values[1], values[2]).normalize();
                coordSystem.applyN(norm);
                normals.add(norm);
                continue;
            }
            if (line.startsWith("f ")) {
                CCModel.assertMatch(polyMatcher, line);
                String[] av = line.substring(2).split(" ");
                CCModel.illegalAssert(av.length >= 3, "Polygons must have at least 3 vertices");
                int[][] polyVerts = new int[av.length][3];
                for (int i = 0; i < av.length; ++i) {
                    String[] as = av[i].split("/");
                    for (int p = 0; p < as.length; ++p) {
                        if (as[p].length() <= 0) continue;
                        polyVerts[i][p] = Integer.parseInt(as[p]);
                    }
                }
                if (vp == 3) {
                    CCModel.triangulate(polys, polyVerts);
                } else {
                    CCModel.quadulate(polys, polyVerts);
                }
            }
            if (!line.startsWith("g ")) continue;
            if (!polys.isEmpty()) {
                modelMap.put(modelName, CCModel.createModel(verts, uvs, normals, vertexMode, polys));
                polys.clear();
            }
            modelName = line.substring(2);
        }
        if (!polys.isEmpty()) {
            modelMap.put(modelName, CCModel.createModel(verts, uvs, normals, vertexMode, polys));
        }
        return modelMap;
    }

    public static void exportObj(Map<String, CCModel> models, PrintWriter p) {
        ArrayList verts = new ArrayList();
        ArrayList uvs = new ArrayList();
        ArrayList normals = new ArrayList();
        ArrayList<int[]> polys = new ArrayList<int[]>();
        for (Map.Entry<String, CCModel> e : models.entrySet()) {
            int[] ia;
            int i;
            p.println("g " + e.getKey());
            CCModel m = e.getValue();
            int vStart = verts.size();
            int uStart = uvs.size();
            int nStart = normals.size();
            boolean hasNormals = m.normals() != null;
            polys.clear();
            for (i = 0; i < m.verts.length; ++i) {
                ia = new int[hasNormals ? 3 : 2];
                ia[0] = CCOBJParser.addIndex(verts, m.verts[i].vec);
                ia[1] = CCOBJParser.addIndex(uvs, m.verts[i].uv);
                if (hasNormals) {
                    ia[2] = CCOBJParser.addIndex(normals, m.normals()[i]);
                }
                polys.add(ia);
            }
            if (vStart < verts.size()) {
                p.println();
                for (i = vStart; i < verts.size(); ++i) {
                    Vector3 v = (Vector3)verts.get(i);
                    p.format("v %s %s %s\n", CCOBJParser.clean(v.x), CCOBJParser.clean(v.y), CCOBJParser.clean(v.z));
                }
            }
            if (uStart < uvs.size()) {
                p.println();
                for (i = uStart; i < uvs.size(); ++i) {
                    UV uv = (UV)uvs.get(i);
                    p.format("vt %s %s\n", CCOBJParser.clean(uv.u), CCOBJParser.clean(uv.v));
                }
            }
            if (nStart < normals.size()) {
                p.println();
                for (i = nStart; i < normals.size(); ++i) {
                    Vector3 n = (Vector3)normals.get(i);
                    p.format("vn %s %s %s\n", CCOBJParser.clean(n.x), CCOBJParser.clean(n.y), CCOBJParser.clean(n.z));
                }
            }
            p.println();
            for (i = 0; i < polys.size(); ++i) {
                if (i % m.vp == 0) {
                    p.format("f", new Object[0]);
                }
                ia = (int[])polys.get(i);
                if (hasNormals) {
                    p.format(" %d/%d/%d", ia[0], ia[1], ia[2]);
                } else {
                    p.format(" %d/%d", ia[0], ia[1]);
                }
                if (i % m.vp != m.vp - 1) continue;
                p.println();
            }
        }
    }

    private static <T> int addIndex(List<T> list, T elem) {
        int i = list.indexOf(elem) + 1;
        if (i == 0) {
            list.add(elem);
            i = list.size();
        }
        return i;
    }

    private static String clean(double d) {
        return d == (double)((int)d) ? Integer.toString((int)d) : Double.toString(d);
    }
}

