/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.baked;

import codechicken.lib.colour.Colour;
import codechicken.lib.render.EnumDrawMode;
import codechicken.lib.render.Vertex5;
import codechicken.lib.render.baked.CCBakedModel;
import codechicken.lib.render.baked.CCBakedQuad;
import codechicken.lib.render.uv.UV;
import codechicken.lib.vec.Vector3;
import java.util.LinkedList;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class CCBakedModelBuilder {
    private VertexFormat format = DefaultVertexFormats.field_176600_a;
    private EnumDrawMode drawMode = EnumDrawMode.QUADS;
    private LinkedList<CCBakedQuad> quads = new LinkedList();

    public CCBakedModelBuilder addQuad(Vector3 pos, UV tex, Vector3 normal, Colour colour, int lightMap) {
        return this.addQuad(new Vertex5(pos, tex), normal, colour, lightMap);
    }

    public CCBakedModelBuilder addQuad(Vertex5 vertex, Vector3 normal, Colour colour, int lightMap) {
        CCBakedQuad quad = new CCBakedQuad(this.format, this.drawMode, vertex, normal, colour, lightMap);
        this.quads.add(quad);
        return this;
    }

    public CCBakedModelBuilder setFormat(VertexFormat format) {
        if (!this.quads.isEmpty()) {
            throw new RuntimeException("Unable to set format on already baked quads!");
        }
        this.format = format;
        return this;
    }

    public CCBakedModelBuilder setDrawMode(EnumDrawMode drawMode) {
        if (!this.quads.isEmpty()) {
            throw new RuntimeException("Unable to set DrawMode on already baked quads!");
        }
        this.drawMode = drawMode;
        return this;
    }

    public CCBakedModel build() {
        return new CCBakedModel(this.quads.toArray(new CCBakedQuad[this.quads.size()]));
    }
}

