/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity;

import crazypants.enderzoo.EnderZoo;
import crazypants.enderzoo.config.Config;
import crazypants.enderzoo.entity.EntityUtil;
import crazypants.enderzoo.entity.EntityWitherCat;
import crazypants.enderzoo.entity.IEnderZooMob;
import crazypants.enderzoo.entity.MobInfo;
import crazypants.enderzoo.entity.SpawnUtil;
import crazypants.enderzoo.entity.ai.EntityAIRangedAttack;
import crazypants.enderzoo.potion.BrewingUtil;
import crazypants.enderzoo.vec.Point3i;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityWitherWitch
extends EntityMob
implements IRangedAttackMob,
IEnderZooMob {
    public static final String NAME = "WitherWitch";
    public static final int EGG_BG_COL = 2511373;
    public static final int EGG_FG_COL = 9461315;
    private ItemStack[] drops = new ItemStack[]{new ItemStack((Item)EnderZoo.itemWitheringDust), new ItemStack((Item)EnderZoo.itemWitheringDust), new ItemStack((Item)EnderZoo.itemWitheringDust), BrewingUtil.createHealthPotion(false, false, true), BrewingUtil.createWitherPotion(false, true), BrewingUtil.createWitherPotion(false, true), BrewingUtil.createRegenerationPotion(false, false, true)};
    private int attackTimer;
    private EntityLivingBase attackedWithPotion;
    private int healTimer;
    private boolean isHealing;
    private boolean spawned;
    private boolean firstUpdate = true;
    private final List<EntityWitherCat> cats = new ArrayList<EntityWitherCat>();
    private List<NBTTagCompound> loadedCats;
    private final EntityAIRangedAttack rangedAttackAI = new EntityAIRangedAttack(this, 1.0, 60, 10.0f);
    private int noActiveTargetTime;

    public EntityWitherWitch(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.rangedAttackAI);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        MobInfo.WITHER_WITCH.applyAttributes((EntityLivingBase)this);
    }

    protected float func_70672_c(DamageSource damageSource, float damage) {
        damage = super.func_70672_c(damageSource, damage);
        if (damageSource.func_76346_g() == this) {
            damage = 0.0f;
        }
        if (damageSource.func_82725_o()) {
            damage = (float)((double)damage * 0.15);
        }
        return damage;
    }

    public boolean func_70687_e(PotionEffect potion) {
        return potion.func_188419_a() != MobEffects.field_82731_v && super.func_70687_e(potion);
    }

    protected void func_70628_a(boolean hitByPlayer, int lootingLevel) {
        int numDrops = this.field_70146_Z.nextInt(1) + 1;
        if (lootingLevel > 0) {
            numDrops += this.field_70146_Z.nextInt(lootingLevel + 1);
        }
        for (int i = 0; i < numDrops; ++i) {
            ItemStack item = this.drops[this.field_70146_Z.nextInt(this.drops.length)].func_77946_l();
            this.func_70099_a(item, 0.0f);
        }
    }

    public void func_70604_c(EntityLivingBase target) {
        EntityLivingBase curTarget = this.func_70643_av();
        super.func_70604_c(target);
        if (curTarget == target || this.field_70170_p.field_72995_K || target == null) {
            return;
        }
        float distToSrc = this.func_70032_d((Entity)target);
        if (distToSrc > this.func_70661_as().func_111269_d() && distToSrc < 50.0f) {
            this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)(distToSrc + 2.0f));
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance di, IEntityLivingData livingData) {
        this.spawned = true;
        return super.func_180482_a(di, livingData);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            super.func_70636_d();
            return;
        }
        if (this.firstUpdate) {
            if (this.spawned) {
                this.spawnCats();
            } else {
                this.loadCats();
            }
            this.firstUpdate = false;
        }
        this.doAttackActions();
        this.manageCats();
        super.func_70636_d();
    }

    protected void doAttackActions() {
        --this.attackTimer;
        --this.healTimer;
        EntityLivingBase target = this.getActiveTarget();
        this.noActiveTargetTime = target == null ? ++this.noActiveTargetTime : 0;
        if (this.shouldStartHeal()) {
            ItemStack potion = (double)this.field_70146_Z.nextFloat() > 0.75 ? BrewingUtil.createRegenerationPotion(false, true, true) : BrewingUtil.createHealthPotion(false, false, true);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, potion);
            this.healTimer = 10;
            this.isHealing = true;
        } else if (target != null && this.func_184586_b(EnumHand.MAIN_HAND) == null) {
            ItemStack potion = this.getActiveTarget().func_70644_a(MobEffects.field_82731_v) ? BrewingUtil.createHarmingPotion(EntityUtil.isHardDifficulty(this.field_70170_p), true) : BrewingUtil.createWitherPotion(false, true);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, potion);
            this.attackTimer = 10;
            this.healTimer = 40;
        } else if (this.noActiveTargetTime > 40 && !this.isHealing && this.func_184586_b(EnumHand.MAIN_HAND) != null) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
            this.attackedWithPotion = null;
        }
        if (this.isHealing && this.healTimer <= 0) {
            this.throwHealthPotion();
            this.isHealing = false;
        }
    }

    protected EntityLivingBase getActiveTarget() {
        EntityLivingBase res = this.func_70638_az();
        if (res == null) {
            res = this.rangedAttackAI.getAttackTarget();
        }
        return res;
    }

    protected boolean shouldStartHeal() {
        if (this.func_70644_a(MobEffects.field_76428_l)) {
            return false;
        }
        return (double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.75 && (double)this.field_70146_Z.nextFloat() > 0.5 && this.healTimer <= 0;
    }

    public void func_82196_d(EntityLivingBase entity, float rangeRatio) {
        if (this.attackTimer <= 0 && this.func_184586_b(EnumHand.MAIN_HAND) != null && !this.isHealing) {
            this.attackedWithPotion = entity;
            double x = entity.field_70165_t + entity.field_70159_w - this.field_70165_t;
            double y = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f - this.field_70163_u;
            double z = entity.field_70161_v + entity.field_70179_y - this.field_70161_v;
            float groundDistance = MathHelper.func_76133_a((double)(x * x + z * z));
            ItemStack potion = this.func_184586_b(EnumHand.MAIN_HAND);
            this.attackTimer = this.func_184586_b(EnumHand.MAIN_HAND).func_77988_m();
            EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, potion);
            entitypotion.field_70125_A -= -20.0f;
            entitypotion.func_70186_c(x, y + (double)(groundDistance * 0.2f), z, 0.75f, 8.0f);
            this.field_70170_p.func_72838_d((Entity)entitypotion);
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
        }
    }

    protected void throwHealthPotion() {
        ItemStack potion = this.func_184586_b(EnumHand.MAIN_HAND);
        EntityPotion entitypotion = new EntityPotion(this.field_70170_p, (EntityLivingBase)this, potion);
        Vec3d lookVec = this.func_70040_Z();
        entitypotion.func_70186_c(lookVec.field_72450_a * 0.5, -1.0, lookVec.field_72449_c * 0.5, 0.75f, 1.0f);
        this.field_70170_p.func_72838_d((Entity)entitypotion);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, null);
        this.healTimer = 80;
    }

    public void catDied(EntityWitherCat cat) {
        this.cats.remove(cat);
    }

    private void spawnCats() {
        if (!Config.witherCatEnabled) {
            return;
        }
        int numCats = this.field_70146_Z.nextInt(Config.witherWitchMaxCats + 1);
        numCats = Math.max(numCats, Config.witherWitchMinCats);
        for (int i = 0; i < numCats; ++i) {
            Point3i startPoint = EntityUtil.getEntityPositionI((Entity)this);
            startPoint.x += 4 - this.field_70146_Z.nextInt(9);
            startPoint.z += 4 - this.field_70146_Z.nextInt(9);
            Point3i spawnLoc = new Point3i();
            if (!SpawnUtil.findClearGround(this.field_70170_p, startPoint, spawnLoc, 2, 10, true)) {
                return;
            }
            this.spawnCat(spawnLoc);
        }
    }

    private void spawnCat(Point3i spawnLoc) {
        EntityWitherCat cat = new EntityWitherCat(this.field_70170_p);
        cat.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
        cat.setOwner(this);
        cat.func_70080_a((double)spawnLoc.x + 0.5, (double)spawnLoc.y + 0.5, (double)spawnLoc.z + 0.5, this.field_70177_z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)new LivingSpawnEvent.CheckSpawn((EntityLiving)cat, this.field_70170_p, (float)cat.field_70165_t, (float)cat.field_70163_u, (float)cat.field_70161_v))) {
            return;
        }
        if (!cat.func_70601_bi()) {
            return;
        }
        this.cats.add(cat);
        this.field_70170_p.func_72838_d((Entity)cat);
    }

    public void func_70014_b(NBTTagCompound root) {
        super.func_70014_b(root);
        if (this.cats.isEmpty()) {
            return;
        }
        NBTTagList catsList = new NBTTagList();
        for (EntityWitherCat cat : this.cats) {
            if (cat.field_70128_L) continue;
            NBTTagCompound catRoot = new NBTTagCompound();
            cat.func_189511_e(catRoot);
            catsList.func_74742_a((NBTBase)catRoot);
        }
        if (catsList.func_74745_c() > 0) {
            root.func_74782_a("cats", (NBTBase)catsList);
        }
    }

    public void func_70037_a(NBTTagCompound root) {
        super.func_70037_a(root);
        if (!root.func_74764_b("cats")) {
            return;
        }
        NBTTagList catsList = (NBTTagList)root.func_74781_a("cats");
        this.loadedCats = new ArrayList<NBTTagCompound>(catsList.func_74745_c());
        for (int i = 0; i < catsList.func_74745_c(); ++i) {
            NBTTagCompound catRoot = catsList.func_150305_b(i);
            if (catRoot == null) continue;
            this.loadedCats.add(catRoot);
        }
    }

    private void loadCats() {
        if (this.loadedCats == null) {
            return;
        }
        for (NBTTagCompound catRoot : this.loadedCats) {
            if (catRoot == null) continue;
            EntityWitherCat cat = new EntityWitherCat(this.field_70170_p);
            cat.func_70020_e(catRoot);
            cat.setOwner(this);
            this.cats.add(cat);
            this.field_70170_p.func_72838_d((Entity)cat);
        }
    }

    protected void manageCats() {
        if (this.cats.isEmpty()) {
            return;
        }
        if (this.noActiveTargetTime > 40) {
            this.pacifyCats();
            return;
        }
        EntityLivingBase currentTarget = this.getActiveTarget();
        EntityLivingBase hitBy = this.func_70643_av();
        if (hitBy == null) {
            hitBy = this.attackedWithPotion;
        }
        this.angerCats(currentTarget, hitBy);
    }

    private void angerCats(EntityLivingBase targ, EntityLivingBase hitBy) {
        for (EntityWitherCat cat : this.cats) {
            if (cat.isAngry()) {
                if (cat.func_70638_az() == targ) continue;
                cat.func_70624_b(targ);
                continue;
            }
            if (cat.getGrowthMode() == EntityWitherCat.GrowthMode.GROW || hitBy == null) continue;
            cat.setGrowthMode(EntityWitherCat.GrowthMode.GROW);
        }
    }

    private void pacifyCats() {
        for (EntityWitherCat cat : this.cats) {
            if (!cat.isAngry()) continue;
            cat.setGrowthMode(EntityWitherCat.GrowthMode.SHRINK);
            if (cat.func_70638_az() == null) continue;
            cat.func_70624_b(null);
        }
    }
}

