/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderzoo.entity.ai;

import crazypants.enderzoo.entity.EntityUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.util.math.BlockPos;

public class EntityAIFlyingFindPerch
extends EntityAIBase {
    private EntityCreature entity;
    private double xPosition;
    private double yPosition;
    private double zPosition;
    private double speed;
    private int executionChance;
    private int searchRange = 6;
    private int searchAttempts = 30;

    public EntityAIFlyingFindPerch(EntityCreature creatureIn, double speedIn) {
        this(creatureIn, speedIn, 120);
    }

    public EntityAIFlyingFindPerch(EntityCreature creatureIn, double speedIn, int chance) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        int chance = this.executionChance;
        if (this.isOnLeaves()) {
            chance *= 10;
        }
        if (this.entity.func_70681_au().nextInt(chance) != 0) {
            return false;
        }
        BlockPos targetPos = EntityUtil.findRandomLandingSurface(this.entity, this.searchRange, this.entity.func_180425_c().func_177956_o() + 1, 250, this.searchAttempts);
        if (targetPos != null) {
            List others = this.entity.field_70170_p.func_72872_a(this.entity.getClass(), EntityUtil.getBoundsAround(targetPos, 4));
            if (others != null && others.size() > 1) {
                return false;
            }
            this.xPosition = (double)targetPos.func_177958_n() + 0.5;
            this.yPosition = targetPos.func_177956_o();
            this.zPosition = (double)targetPos.func_177952_p() + 0.5;
            return true;
        }
        return false;
    }

    private boolean isOnLeaves() {
        IBlockState bs = this.entity.field_70170_p.func_180495_p(this.entity.func_180425_c().func_177977_b());
        Block block = bs.func_177230_c();
        return block.func_149688_o(bs) == Material.field_151584_j;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        if (!this.entity.func_70661_as().func_75492_a(this.xPosition, this.yPosition, this.zPosition, this.speed)) {
            // empty if block
        }
    }

    public void setExecutionChance(int newchance) {
        this.executionChance = newchance;
    }
}

