/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.client;

import net.blay09.mods.trashslot.TrashSlot;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiTrashSlot
extends Gui {
    private static final ResourceLocation texture = new ResourceLocation("trashslot", "textures/gui/slot.png");
    private static final int SNAP_SIZE = 6;
    private final GuiInventory parentGui;
    private final Slot trashSlot;
    private int offsetX;
    private int offsetY;
    private int width;
    private int height;
    private int snapGridTop;
    private int snapGridBottom;
    private int snapGridLeft;
    private int snapGridRight;
    public static final int UPDOWN_WIDTH = 32;
    public static final int UPDOWN_HEIGHT = 25;
    public static final int LEFTRIGHT_WIDTH = 25;
    public static final int LEFTRIGHT_HEIGHT = 31;
    public static final int LONELY_WIDTH = 28;
    public static final int LONELY_HEIGHT = 28;
    private boolean lastHover;
    private boolean lastMouseDown;
    private boolean dragging;
    private int dragStartX;
    private int dragStartY;

    public GuiTrashSlot(GuiInventory parentGui, Slot trashSlot) {
        this.parentGui = parentGui;
        this.snapGridLeft = parentGui.field_147003_i + 4;
        this.snapGridTop = parentGui.field_147009_r + 4;
        this.snapGridRight = parentGui.field_147003_i + parentGui.field_146999_f - 4;
        this.snapGridBottom = parentGui.field_147009_r + parentGui.field_147000_g - 4;
        this.trashSlot = trashSlot;
        this.offsetX = (int)(TrashSlot.trashSlotRelative ? TrashSlot.trashSlotX * (float)parentGui.field_146294_l : TrashSlot.trashSlotX);
        this.offsetY = (int)(TrashSlot.trashSlotRelative ? TrashSlot.trashSlotY * (float)parentGui.field_146295_m : TrashSlot.trashSlotY);
    }

    public void update(int mouseX, int mouseY) {
        this.snapGridLeft = this.parentGui.field_147003_i + 4;
        this.snapGridTop = this.parentGui.field_147009_r + 4;
        this.snapGridRight = this.parentGui.field_147003_i + this.parentGui.field_146999_f - 4;
        this.snapGridBottom = this.parentGui.field_147009_r + this.parentGui.field_147000_g - 4;
        int renderX = this.getRenderX();
        int renderY = this.getRenderY();
        boolean hover = this.isInside(mouseX, mouseY);
        if (Mouse.isButtonDown((int)0)) {
            if (!(this.lastMouseDown || !this.lastHover || !hover || this.dragging || Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() != null || this.trashSlot.func_75216_d() && mouseX >= this.parentGui.field_147003_i + this.trashSlot.field_75223_e && mouseX < this.parentGui.field_147003_i + this.trashSlot.field_75223_e + 16 && mouseY >= this.parentGui.field_147009_r + this.trashSlot.field_75221_f && mouseY < this.parentGui.field_147009_r + this.trashSlot.field_75221_f + 16)) {
                this.dragStartX = renderX - mouseX;
                this.dragStartY = renderY - mouseY;
                this.dragging = true;
            }
            this.lastMouseDown = true;
        } else {
            this.lastMouseDown = false;
            if (this.dragging) {
                if (TrashSlot.trashSlotRelative) {
                    TrashSlot.trashSlotX = (float)renderX / (float)this.parentGui.field_146294_l;
                    TrashSlot.trashSlotY = (float)renderY / (float)this.parentGui.field_146295_m;
                } else {
                    TrashSlot.trashSlotX = renderX - (this.parentGui.field_147003_i + this.parentGui.field_146999_f / 2);
                    TrashSlot.trashSlotY = renderY - (this.parentGui.field_147009_r + this.parentGui.field_147000_g / 2);
                }
                TrashSlot.instance.saveConfig();
                this.dragging = false;
            }
        }
        if (this.dragging) {
            int oldX = renderX;
            int oldY = renderY;
            renderX = mouseX + this.dragStartX;
            renderY = mouseY + this.dragStartY;
            renderX = Math.max(0, Math.min(this.parentGui.field_146294_l - this.width, renderX));
            renderY = Math.max(0, Math.min(this.parentGui.field_146295_m - this.height, renderY));
            if (oldX + 25 > this.snapGridLeft && oldX < this.snapGridRight) {
                renderY = renderY > this.parentGui.field_146295_m / 2 ? Math.max(renderY, this.snapGridBottom) : Math.min(renderY, this.snapGridTop - 25);
            } else if (oldY + 25 > this.snapGridTop && oldY < this.snapGridBottom) {
                renderX = renderX > this.parentGui.field_146294_l / 2 ? Math.max(renderX, this.snapGridRight) : Math.min(renderX, this.snapGridLeft - 25);
            }
            if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                if (Math.abs(renderX - this.parentGui.field_147003_i) <= 6) {
                    renderX = this.parentGui.field_147003_i;
                } else if (Math.abs(renderX + this.width - (this.parentGui.field_147003_i + this.parentGui.field_146999_f)) <= 6) {
                    renderX = this.parentGui.field_147003_i + this.parentGui.field_146999_f - this.width;
                }
                if (Math.abs(renderY - this.parentGui.field_147009_r) <= 6) {
                    renderY = this.parentGui.field_147009_r;
                } else if (Math.abs(renderY + this.height - (this.parentGui.field_147009_r + this.parentGui.field_147000_g)) <= 6) {
                    renderY = this.parentGui.field_147009_r + this.parentGui.field_147000_g - this.height;
                }
            }
            this.offsetX = TrashSlot.trashSlotRelative ? renderX : renderX - (this.parentGui.field_147003_i + this.parentGui.field_146999_f / 2);
            this.offsetY = TrashSlot.trashSlotRelative ? renderY : renderY - (this.parentGui.field_147009_r + this.parentGui.field_147000_g / 2);
        }
        this.lastHover = hover;
    }

    public void drawBackground(int mouseX, int mouseY) {
        int renderX = this.getRenderX();
        int renderY = this.getRenderY();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_73735_i = 1.0f;
        this.parentGui.field_146297_k.func_110434_K().func_110577_a(texture);
        boolean isLonely = true;
        if (renderX >= this.parentGui.field_147003_i && renderX + 32 <= this.parentGui.field_147003_i + this.parentGui.field_146999_f) {
            this.width = 32;
            this.height = 25;
            if (renderY == this.snapGridBottom) {
                this.trashSlot.field_75223_e = renderX + 8 - this.parentGui.field_147003_i;
                this.trashSlot.field_75221_f = renderY + 3 - this.parentGui.field_147009_r;
                this.func_73729_b(renderX, renderY, 0, 0, this.width, this.height);
                if (renderX > this.parentGui.field_147003_i + 4) {
                    this.func_73729_b(renderX, renderY, 50, 29, 4, 4);
                }
                if (renderX + this.width < this.parentGui.field_147003_i + this.parentGui.field_146999_f - 4) {
                    this.func_73729_b(renderX + this.width - 4, renderY, 54, 29, 4, 4);
                }
                isLonely = false;
            } else if (renderY + this.height == this.snapGridTop) {
                this.trashSlot.field_75223_e = renderX + 8 - this.parentGui.field_147003_i;
                this.trashSlot.field_75221_f = renderY + 6 - this.parentGui.field_147009_r;
                this.func_73729_b(renderX, renderY, 32, 0, this.width, this.height);
                if (renderX > this.parentGui.field_147003_i + 4) {
                    this.func_73729_b(renderX, renderY + this.height - 4, 50, 25, 4, 4);
                }
                if (renderX + this.width < this.parentGui.field_147003_i + this.parentGui.field_146999_f - 4) {
                    this.func_73729_b(renderX + this.width - 4, renderY + this.height - 4, 54, 25, 4, 4);
                }
                isLonely = false;
            }
        } else if (renderY >= this.parentGui.field_147009_r && renderY + 31 <= this.parentGui.field_147009_r + this.parentGui.field_147000_g) {
            this.width = 25;
            this.height = 31;
            if (renderX == this.snapGridRight) {
                this.trashSlot.field_75223_e = renderX + 3 - this.parentGui.field_147003_i;
                this.trashSlot.field_75221_f = renderY + 7 - this.parentGui.field_147009_r;
                this.func_73729_b(renderX, renderY, 0, 25, this.width, this.height);
                if (renderY > this.parentGui.field_147009_r + 4) {
                    this.func_73729_b(renderX, renderY, 54, 33, 4, 4);
                }
                if (renderY + this.height < this.parentGui.field_147009_r + this.parentGui.field_147000_g - 3) {
                    this.func_73729_b(renderX, renderY + this.height - 4, 54, 37, 4, 4);
                }
                isLonely = false;
            } else if (renderX + this.width == this.snapGridLeft) {
                this.trashSlot.field_75223_e = renderX + 6 - this.parentGui.field_147003_i;
                this.trashSlot.field_75221_f = renderY + 7 - this.parentGui.field_147009_r;
                this.func_73729_b(renderX, renderY, 25, 25, this.width, this.height);
                if (renderY > this.parentGui.field_147009_r + 4) {
                    this.func_73729_b(renderX + this.width - 4, renderY, 50, 33, 4, 4);
                }
                if (renderY + this.height < this.parentGui.field_147009_r + this.parentGui.field_147000_g - 4) {
                    this.func_73729_b(renderX + this.width - 4, renderY + this.height - 4, 50, 37, 4, 4);
                }
                isLonely = false;
            }
        }
        if (isLonely) {
            this.width = 28;
            this.height = 28;
            this.trashSlot.field_75223_e = renderX + 6 - this.parentGui.field_147003_i;
            this.trashSlot.field_75221_f = renderY + 6 - this.parentGui.field_147009_r;
            this.func_73729_b(renderX, renderY, 0, 56, this.width, this.height);
        }
        this.field_73735_i = 0.0f;
    }

    public boolean isInside(int mouseX, int mouseY) {
        int renderX = this.getRenderX();
        int renderY = this.getRenderY();
        return mouseX >= renderX && mouseY >= renderY && mouseX < renderX + this.width && mouseY < renderY + this.height;
    }

    private int getRenderX() {
        return Math.max(0, Math.min(TrashSlot.trashSlotRelative ? this.offsetX : this.parentGui.field_147003_i + this.parentGui.field_146999_f / 2 + this.offsetX, this.parentGui.field_146294_l - 28));
    }

    private int getRenderY() {
        return Math.max(0, Math.min(TrashSlot.trashSlotRelative ? this.offsetY : this.parentGui.field_147009_r + this.parentGui.field_147000_g / 2 + this.offsetY, this.parentGui.field_146295_m - 28));
    }
}

