/*
 * Decompiled with CFR 0.152.
 */
package portablejim.ud.repack.adapter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.FMLModContainer;
import net.minecraftforge.fml.common.ILanguageAdapter;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import portablejim.ud.repack.annotations.NotNull;
import portablejim.ud.repack.annotations.Nullable;
import portablejim.ud.repack.kotlin.Metadata;
import portablejim.ud.repack.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002J2\u0010\r\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0016J$\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00072\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010$\u001a\u00020\u000bH\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/drakon/forge/kotlin/KotlinAdapter;", "Lnet/minecraftforge/fml/common/ILanguageAdapter;", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "findInstanceFieldOrThrow", "Ljava/lang/reflect/Field;", "targetClass", "Ljava/lang/Class;", "findModObjectOrThrow", "", "instanceField", "getNewInstance", "container", "Lnet/minecraftforge/fml/common/FMLModContainer;", "objectClass", "classLoader", "Ljava/lang/ClassLoader;", "factoryMarkedAnnotation", "Ljava/lang/reflect/Method;", "instanceSecurityException", "Lio/drakon/forge/kotlin/KotlinAdapter$KotlinAdapterException;", "exception", "Ljava/lang/Exception;", "noInstanceFieldException", "setInternalProxies", "", "mod", "Lnet/minecraftforge/fml/common/ModContainer;", "side", "Lnet/minecraftforge/fml/relauncher/Side;", "loader", "setProxy", "target", "proxyTarget", "proxy", "supportsStatics", "", "unexpectedInitializerSignatureException", "wrongVisibilityOnInitializerException", "KotlinAdapterException", "Forgelin-compileKotlin"})
public final class KotlinAdapter
implements ILanguageAdapter {
    private final Logger logger = LogManager.getLogger((String)"ILanguageAdapter/Kotlin");

    public void setProxy(@NotNull Field target, @NotNull Class<?> proxyTarget, @NotNull Object proxy) {
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(proxyTarget, "proxyTarget");
        Intrinsics.checkParameterIsNotNull(proxy, "proxy");
        this.logger.debug("Setting proxy on target: {}.{} -> {}", new Object[]{target.getDeclaringClass().getSimpleName(), target.getName(), proxy});
        Field instanceField = this.findInstanceFieldOrThrow(proxyTarget);
        Object modObject = this.findModObjectOrThrow(instanceField);
        target.set(modObject, proxy);
    }

    @Nullable
    public Object getNewInstance(@Nullable FMLModContainer container, @NotNull Class<?> objectClass, @NotNull ClassLoader classLoader, @Nullable Method factoryMarkedAnnotation) {
        Intrinsics.checkParameterIsNotNull(objectClass, "objectClass");
        Intrinsics.checkParameterIsNotNull(classLoader, "classLoader");
        this.logger.debug("Constructing new instance of {}", new Object[]{objectClass.getSimpleName()});
        Field instanceField = this.findInstanceFieldOrThrow(objectClass);
        Object modObject = this.findModObjectOrThrow(instanceField);
        return modObject;
    }

    public boolean supportsStatics() {
        return false;
    }

    public void setInternalProxies(@Nullable ModContainer mod, @Nullable Side side, @Nullable ClassLoader loader) {
    }

    private final Field findInstanceFieldOrThrow(Class<?> targetClass) {
        Field field;
        try {
            Field field2 = targetClass.getField("INSTANCE");
            Intrinsics.checkExpressionValueIsNotNull(field2, "targetClass.getField(\"INSTANCE\")");
            field = field2;
        }
        catch (NoSuchFieldException exception) {
            throw (Throwable)this.noInstanceFieldException(exception);
        }
        catch (SecurityException exception) {
            throw (Throwable)this.instanceSecurityException(exception);
        }
        Field instanceField = field;
        return instanceField;
    }

    private final Object findModObjectOrThrow(Field instanceField) {
        Object modObject;
        Object object;
        try {
            object = instanceField.get(null);
        }
        catch (IllegalArgumentException exception) {
            throw (Throwable)this.unexpectedInitializerSignatureException(exception);
        }
        catch (IllegalAccessException exception) {
            throw (Throwable)this.wrongVisibilityOnInitializerException(exception);
        }
        Object object2 = modObject = object;
        Intrinsics.checkExpressionValueIsNotNull(object2, "modObject");
        return object2;
    }

    private final KotlinAdapterException noInstanceFieldException(Exception exception) {
        return new KotlinAdapterException("Couldn't find INSTANCE singleton on Kotlin @Mod container", exception);
    }

    private final KotlinAdapterException instanceSecurityException(Exception exception) {
        return new KotlinAdapterException("Security violation accessing INSTANCE singleton on Kotlin @Mod container", exception);
    }

    private final KotlinAdapterException unexpectedInitializerSignatureException(Exception exception) {
        return new KotlinAdapterException("Kotlin @Mod object has an unexpected initializer signature, somehow?", exception);
    }

    private final KotlinAdapterException wrongVisibilityOnInitializerException(Exception exception) {
        return new KotlinAdapterException("Initializer on Kotlin @Mod object isn't `public`", exception);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/drakon/forge/kotlin/KotlinAdapter$KotlinAdapterException;", "Ljava/lang/RuntimeException;", "message", "", "exception", "Ljava/lang/Exception;", "(Ljava/lang/String;Ljava/lang/Exception;)V", "Forgelin-compileKotlin"})
    private static final class KotlinAdapterException
    extends RuntimeException {
        public KotlinAdapterException(@NotNull String message, @NotNull Exception exception) {
            Intrinsics.checkParameterIsNotNull(message, "message");
            Intrinsics.checkParameterIsNotNull(exception, "exception");
            super("Kotlin adapter error - do not report to Forge! " + message, exception);
        }
    }
}

