/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces;

import cubex2.mods.morefurnaces.MoreFurnaces;
import cubex2.mods.morefurnaces.blocks.BlockMoreFurnaces;
import cubex2.mods.morefurnaces.tileentity.TileEntityDiamondFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityGoldFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityIronFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityNetherrackFurnace;
import cubex2.mods.morefurnaces.tileentity.TileEntityObsidianFurnace;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.oredict.ShapedOreRecipe;

public enum FurnaceType implements IStringSerializable
{
    IRON(2, 2, 2, 1, 150, 1.25f, "Iron Furnace", TileEntityIronFurnace.class, "III", "IPI", "III"),
    GOLD(4, 5, 4, 1, 80, 2.0f, "Gold Furnace", TileEntityGoldFurnace.class, "GGG", "GPG", "GGG"),
    DIAMOND(7, 9, 7, 1, 40, 4.0f, "Diamond Furnace", TileEntityDiamondFurnace.class, "DDD", "DPD", "DDD"),
    OBSIDIAN(2, 2, 2, 2, 150, 2.0f, "Obsidian Furnace", TileEntityObsidianFurnace.class, "OOO", "O1O", "OOO"),
    NETHERRACK(1, 1, 0, 1, 1800, 1.0f, "Netherrack Furnace", TileEntityNetherrackFurnace.class, "NNN", "NFN", "NNN");

    final int inputSlots;
    final int outputSlots;
    public final int fuelSlots;
    public final int parallelSmelting;
    public final int[] inputSlotIds;
    public final int[] outputSlotIds;
    public final int[] fuelSlotIds;
    public final int speed;
    public final float consumptionRate;
    public final String friendlyName;
    public final Class<? extends TileEntityIronFurnace> clazz;
    private final String[] recipe;

    private FurnaceType(int inputSlots, int outputSlots, int fuelSlots, int parallelSmelting, int speed, float consumptionRate, String friendlyName, Class<? extends TileEntityIronFurnace> clazz, String ... recipe) {
        int i;
        this.inputSlots = inputSlots;
        this.outputSlots = outputSlots;
        this.fuelSlots = fuelSlots;
        this.parallelSmelting = parallelSmelting;
        this.inputSlotIds = new int[inputSlots * parallelSmelting];
        this.outputSlotIds = new int[outputSlots * parallelSmelting];
        this.fuelSlotIds = new int[fuelSlots];
        for (i = 0; i < this.inputSlotIds.length; ++i) {
            this.inputSlotIds[i] = i;
        }
        for (i = 0; i < this.fuelSlotIds.length; ++i) {
            this.fuelSlotIds[i] = i + this.inputSlotIds.length;
        }
        for (i = 0; i < this.outputSlotIds.length; ++i) {
            this.outputSlotIds[i] = i + this.inputSlotIds.length + this.fuelSlotIds.length;
        }
        this.speed = speed;
        this.consumptionRate = consumptionRate;
        this.friendlyName = friendlyName;
        this.clazz = clazz;
        this.recipe = recipe;
    }

    public static TileEntityIronFurnace makeEntity(int meta) {
        try {
            TileEntityIronFurnace te = FurnaceType.values()[meta].clazz.newInstance();
            return te;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void generateRecipes(BlockMoreFurnaces blockResult) {
        ItemStack previous = new ItemStack(Blocks.field_150460_al);
        for (FurnaceType typ : FurnaceType.values()) {
            ShapedOreRecipe recipe = new ShapedOreRecipe(new ItemStack((Block)blockResult, 1, typ.ordinal()), new Object[]{typ.recipe, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('G'), Items.field_151043_k, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('O'), Blocks.field_150343_Z, Character.valueOf('N'), Blocks.field_150424_aL, Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('1'), new ItemStack((Block)MoreFurnaces.blockFurnaces, 0), Character.valueOf('P'), previous});
            CraftingManager.func_77594_a().func_77592_b().add(recipe);
            previous = new ItemStack((Block)blockResult, 1, typ.ordinal());
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public boolean isInputSlot(int slotId) {
        return FurnaceType.arrayContains(this.inputSlotIds, slotId);
    }

    public boolean isFuelSlot(int slotId) {
        return FurnaceType.arrayContains(this.fuelSlotIds, slotId);
    }

    public boolean isOutputSlot(int slotId) {
        return FurnaceType.arrayContains(this.outputSlotIds, slotId);
    }

    public static boolean arrayContains(int[] i, int i1) {
        for (int i2 : i) {
            if (i2 != i1) continue;
            return true;
        }
        return false;
    }

    public int getNumInputSlots() {
        return this.parallelSmelting * this.inputSlots;
    }

    public int getNumFuelSlots() {
        return this.fuelSlots;
    }

    public int getNumOutputSlots() {
        return this.parallelSmelting * this.outputSlots;
    }

    public int getFirstInputSlot(int id) {
        return 0 + id * this.inputSlots;
    }

    public int getLastInputSlot(int id) {
        return this.getFirstInputSlot(id) + this.inputSlots - 1;
    }

    public int getFirstFuelSlot() {
        return this.getLastInputSlot(this.parallelSmelting - 1) + 1;
    }

    public int getLastFuelSlot() {
        return this.getFirstFuelSlot() + this.fuelSlots - 1;
    }

    public int getFirstOutputSlot(int id) {
        return this.getLastFuelSlot() + 1 + id * this.outputSlots;
    }

    public int getLastOutputSlot(int id) {
        return this.getFirstOutputSlot(id) + this.outputSlots - 1;
    }

    public int getNumSlots() {
        return this.parallelSmelting * (this.inputSlots + this.outputSlots) + this.fuelSlots;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }
}

