/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.morefurnaces;

import cubex2.mods.morefurnaces.FurnaceType;
import cubex2.mods.morefurnaces.blocks.BlockMoreFurnaces;
import cubex2.mods.morefurnaces.proxies.CommonProxy;
import java.io.IOException;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

@Mod(modid="MoreFurnaces", name="More Furnaces", version="1.8.2", dependencies="required-after:cxlibrary@[1.2.0,)", acceptedMinecraftVersions="[1.10.2]")
public class MoreFurnaces {
    public static BlockMoreFurnaces blockFurnaces;
    @SidedProxy(clientSide="cubex2.mods.morefurnaces.proxies.ClientProxy", serverSide="cubex2.mods.morefurnaces.proxies.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="MoreFurnaces")
    public static MoreFurnaces instance;
    public static int ironSpeed;
    public static int goldSpeed;
    public static int diamondSpeed;
    public static int netherrackSpeed;
    public static int obsidianSpeed;
    public static float ironConsumptionRate;
    public static float goldConsumptionRate;
    public static float diamondConsumptionRate;
    public static float netherrackConsumptionRate;
    public static float obsidianConsumptionRate;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            ironSpeed = config.get("General", "ironFurnaceSpeed", FurnaceType.IRON.speed).getInt();
            goldSpeed = config.get("General", "goldFurnaceSpeed", FurnaceType.GOLD.speed).getInt();
            diamondSpeed = config.get("General", "diamondFurnaceSpeed", FurnaceType.DIAMOND.speed).getInt();
            netherrackSpeed = config.get("General", "netherrackFurnaceSpeed", FurnaceType.NETHERRACK.speed).getInt();
            obsidianSpeed = config.get("General", "obsidianFurnaceSpeed", FurnaceType.OBSIDIAN.speed).getInt();
            ironConsumptionRate = (float)config.get("General", "ironFurnaceConsumptionRate", (double)FurnaceType.IRON.consumptionRate).getDouble((double)FurnaceType.IRON.consumptionRate);
            goldConsumptionRate = (float)config.get("General", "goldFurnaceConsumptionRate", (double)FurnaceType.GOLD.consumptionRate).getDouble((double)FurnaceType.GOLD.consumptionRate);
            diamondConsumptionRate = (float)config.get("General", "diamondFurnaceConsumptionRate", (double)FurnaceType.DIAMOND.consumptionRate).getDouble((double)FurnaceType.DIAMOND.consumptionRate);
            netherrackConsumptionRate = (float)config.get("General", "netherrackFurnaceConsumptionRate", (double)FurnaceType.NETHERRACK.consumptionRate).getDouble((double)FurnaceType.NETHERRACK.consumptionRate);
            obsidianConsumptionRate = (float)config.get("General", "obsidianFurnaceConsumptionRate", (double)FurnaceType.OBSIDIAN.consumptionRate).getDouble((double)FurnaceType.OBSIDIAN.consumptionRate);
        }
        finally {
            config.save();
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        blockFurnaces = new BlockMoreFurnaces();
        for (FurnaceType typ : FurnaceType.values()) {
            GameRegistry.registerTileEntity(typ.clazz, (String)("CubeX2 " + typ.friendlyName));
        }
        FurnaceType.generateRecipes(blockFurnaces);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerRenderInformation();
    }
}

