/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.api.food;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import squeek.applecore.api.AppleCoreAPI;

public class FoodValues {
    public final int hunger;
    public final float saturationModifier;

    public FoodValues(int hunger, float saturationModifier) {
        this.hunger = hunger;
        this.saturationModifier = saturationModifier;
    }

    public FoodValues(FoodValues other) {
        this(other.hunger, other.saturationModifier);
    }

    public float getSaturationIncrement() {
        return Math.min(20.0f, (float)this.hunger * this.saturationModifier * 2.0f);
    }

    public static FoodValues getUnmodified(ItemStack itemStack) {
        return AppleCoreAPI.accessor.getUnmodifiedFoodValues(itemStack);
    }

    public static FoodValues get(ItemStack itemStack) {
        return AppleCoreAPI.accessor.getFoodValues(itemStack);
    }

    public static FoodValues get(ItemStack itemStack, EntityPlayer player) {
        return AppleCoreAPI.accessor.getFoodValuesForPlayer(itemStack, player);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hunger;
        result = 31 * result + Float.floatToIntBits(this.saturationModifier);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FoodValues other = (FoodValues)obj;
        if (this.hunger != other.hunger) {
            return false;
        }
        return Float.floatToIntBits(this.saturationModifier) == Float.floatToIntBits(other.saturationModifier);
    }
}

