/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm.module;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.asmhelper.applecore.ASMHelper;
import squeek.asmhelper.applecore.ObfHelper;

public class ModuleFoodEatingSpeed
implements IClassTransformerModule {
    @Override
    public String[] getClassesToTransform() {
        return new String[]{"net.minecraft.entity.EntityLivingBase", "net.minecraft.client.renderer.ItemRenderer"};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        if (transformedName.equals("net.minecraft.entity.EntityLivingBase")) {
            this.addItemInUseMaxDurationField(classNode);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_184598_c", "setActiveHand", ASMHelper.toMethodDescriptor("V", "net.minecraft.util.EnumHand"));
            if (methodNode == null) {
                throw new RuntimeException(classNode.name + ": setActiveHand method not found");
            }
            this.patchSetActiveHand(classNode, methodNode);
            methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_184612_cw", "getItemInUseMaxCount", ASMHelper.toMethodDescriptor("I", new String[0]));
            if (methodNode == null) throw new RuntimeException(classNode.name + ": getItemInUseMaxCount method not found");
            this.patchGetItemInUseMaxCount(classNode, methodNode);
            return ASMHelper.writeClassToBytes(classNode);
        } else {
            if (!transformedName.equals("net.minecraft.client.renderer.ItemRenderer")) return ASMHelper.writeClassToBytes(classNode);
            MethodNode methodNode = ASMHelper.findMethodNodeOfClass(classNode, "func_187454_a", "transformEatFirstPerson", ASMHelper.toMethodDescriptor("V", "F", "net.minecraft.util.EnumHandSide", "net.minecraft.item.ItemStack"));
            if (methodNode == null) throw new RuntimeException(classNode.name + ": setActiveHand method not found");
            this.patchRenderItemInFirstPerson(methodNode);
        }
        return ASMHelper.writeClassToBytes(classNode);
    }

    private void patchRenderItemInFirstPerson(MethodNode method) {
        boolean replaced;
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 3));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, ASMHelper.toInternalClassName("net.minecraft.item.ItemStack"), ObfHelper.isObfuscated() ? "func_77988_m" : "getMaxItemUseDuration", ASMHelper.toMethodDescriptor("I", new String[0]), false));
        InsnList replacement = new InsnList();
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
        replacement.add((AbstractInsnNode)new FieldInsnNode(180, ObfHelper.getInternalClassName("net.minecraft.client.renderer.ItemRenderer"), ObfHelper.isObfuscated() ? "field_78455_a" : "mc", ASMHelper.toDescriptor("net.minecraft.client.Minecraft")));
        replacement.add((AbstractInsnNode)new FieldInsnNode(180, ObfHelper.getInternalClassName("net.minecraft.client.Minecraft"), ObfHelper.isObfuscated() ? "field_71439_g" : "thePlayer", ASMHelper.toDescriptor("net.minecraft.client.entity.EntityPlayerSP")));
        replacement.add((AbstractInsnNode)new FieldInsnNode(180, ObfHelper.getInternalClassName("net.minecraft.entity.player.EntityPlayer"), "itemInUseMaxDuration", "I"));
        boolean bl = replaced = ASMHelper.findAndReplace(method.instructions, needle, replacement) != null;
        if (!replaced) {
            throw new RuntimeException("ItemRenderer.transformEatFirstPerson: no replacements made");
        }
    }

    private void patchGetItemInUseMaxCount(ClassNode classNode, MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new VarInsnNode(25, 0));
        needle.add((AbstractInsnNode)new FieldInsnNode(180, ObfHelper.getInternalClassName("net.minecraft.entity.EntityLivingBase"), ObfHelper.isObfuscated() ? "field_184627_bm" : "activeItemStack", ASMHelper.toDescriptor("net.minecraft.item.ItemStack")));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, ObfHelper.getInternalClassName("net.minecraft.item.ItemStack"), ObfHelper.isObfuscated() ? "func_77988_m" : "getMaxItemUseDuration", ASMHelper.toMethodDescriptor("I", new String[0]), false));
        InsnList replacement = new InsnList();
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 0));
        replacement.add((AbstractInsnNode)new FieldInsnNode(180, ASMHelper.toInternalClassName(classNode.name), "itemInUseMaxDuration", "I"));
        replacement.add((AbstractInsnNode)new MethodInsnNode(184, ASMHelper.toInternalClassName("squeek.applecore.asm.Hooks"), "getItemInUseMaxCount", ASMHelper.toMethodDescriptor("I", "net.minecraft.entity.EntityLivingBase", "I"), false));
        int numReplacementsMade = ASMHelper.findAndReplaceAll(method.instructions, needle, replacement);
        if (numReplacementsMade == 0) {
            throw new RuntimeException("EntityLivingBase.getItemInUseMaxCount: no replacements made");
        }
    }

    private void patchSetActiveHand(ClassNode classNode, MethodNode method) {
        AbstractInsnNode targetNode = ASMHelper.findFirstInstructionWithOpcode(method, 181);
        while (targetNode != null && !((FieldInsnNode)targetNode).name.equals(ObfHelper.isObfuscated() ? "field_184628_bn" : "activeItemStackUseCount")) {
            targetNode = ASMHelper.findNextInstructionWithOpcode(targetNode, 181);
        }
        if (targetNode == null) {
            throw new RuntimeException("EntityLivingBase.setActiveHand: PUTFIELD activeItemStackUseCount instruction not found");
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)new VarInsnNode(21, 3));
        toInject.add((AbstractInsnNode)new FieldInsnNode(181, ASMHelper.toInternalClassName(classNode.name), "itemInUseMaxDuration", "I"));
        method.instructions.insert(targetNode, toInject);
    }

    private void addItemInUseMaxDurationField(ClassNode classNode) {
        classNode.fields.add(new FieldNode(1, "itemInUseMaxDuration", "I", null, null));
    }
}

