/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.badges;

import com.feed_the_beast.ftbu.badges.Badge;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.latmod.lib.util.LMUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class BadgeStorage {
    public final Map<String, Badge> badgeMap = new HashMap<String, Badge>();
    public final Map<UUID, Badge> badgePlayerMap = new HashMap<UUID, Badge>();

    public void clear() {
        this.badgeMap.clear();
        this.badgePlayerMap.clear();
    }

    public void loadBadges(JsonElement e) {
        if (e == null || !e.isJsonObject()) {
            return;
        }
        JsonObject o = e.getAsJsonObject();
        if (o.has("badges") && o.has("players")) {
            JsonObject o1 = o.get("badges").getAsJsonObject();
            for (Map.Entry entry : o1.entrySet()) {
                Badge b = new Badge((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                this.badgeMap.put(b.getID(), b);
            }
            o1 = o.get("players").getAsJsonObject();
            for (Map.Entry entry : o1.entrySet()) {
                Badge b;
                UUID id = LMUtils.fromString((String)((String)entry.getKey()));
                if (id == null || (b = this.badgeMap.get(((JsonElement)entry.getValue()).getAsString())) == null) continue;
                this.badgePlayerMap.put(id, b);
            }
        }
    }

    public void copyFrom(BadgeStorage storage) {
        this.badgeMap.putAll(storage.badgeMap);
        this.badgePlayerMap.putAll(storage.badgePlayerMap);
    }
}

