/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.client;

import com.feed_the_beast.ftbl.api.FTBLibCapabilities;
import com.feed_the_beast.ftbl.api.client.CubeRenderer;
import com.feed_the_beast.ftbl.api.client.FTBLibClient;
import com.feed_the_beast.ftbl.api.client.LMFrustumUtils;
import com.feed_the_beast.ftbl.api.paint.IPainterItem;
import com.feed_the_beast.ftbl.util.ChunkDimPos;
import com.feed_the_beast.ftbl.util.FTBLib;
import com.feed_the_beast.ftbu.client.FTBUClient;
import com.feed_the_beast.ftbu.gui.guide.ClientGuideFile;
import com.feed_the_beast.ftbu.world.chunks.ClaimedChunk;
import com.feed_the_beast.ftbu.world.data.FTBUWorldDataSP;
import com.latmod.lib.math.MathHelperLM;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class FTBUClientEventHandler {
    public static final ResourceLocation CHUNK_BORDER_TEXTURE = new ResourceLocation("ftbu", "textures/world/chunk_border.png");
    public static final ResourceLocation TEXTURE_LIGHT_VALUE_X = new ResourceLocation("ftbu", "textures/world/light_value_x.png");
    public static final ResourceLocation TEXTURE_LIGHT_VALUE_O = new ResourceLocation("ftbu", "textures/world/light_value_o.png");
    public boolean renderChunkBounds = false;
    private CubeRenderer chunkBorderRenderer = new CubeRenderer(true, true);
    private Collection<MobSpawnPos> lightList = new HashSet<MobSpawnPos>();
    private boolean renderLightValues = false;
    private boolean needsLightUpdate = true;
    private int lastX;
    private int lastY = -1;
    private int lastZ;

    public void toggleLightLevel() {
        this.needsLightUpdate = this.renderLightValues = !this.renderLightValues;
        if (!this.renderLightValues) {
            this.needsLightUpdate = false;
            this.lightList.clear();
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent e) {
        IBlockState paint;
        if (e.getItemStack().hasCapability(FTBLibCapabilities.PAINTER_ITEM, null) && (paint = ((IPainterItem)e.getItemStack().getCapability(FTBLibCapabilities.PAINTER_ITEM, null)).getPaint()) != null) {
            e.getToolTip().add(String.valueOf(TextFormatting.WHITE) + TextFormatting.BOLD + new ItemStack(paint.func_177230_c(), 1, paint.func_177230_c().func_176201_c(paint)).func_82833_r() + TextFormatting.RESET);
        }
    }

    @SubscribeEvent
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (FTBUClient.KEY_GUIDE.func_151468_f()) {
            ClientGuideFile.openClientGui(true);
        }
        if (FTBUClient.KEY_CHUNK_BORDER.func_151468_f()) {
            boolean bl = this.renderChunkBounds = !this.renderChunkBounds;
        }
        if (FTBUClient.KEY_LIGHT_VALUES.func_151468_f()) {
            this.toggleLightLevel();
        }
    }

    @SubscribeEvent
    public void blockChanged(BlockEvent e) {
        if (MathHelperLM.distSq((double)((double)e.getPos().func_177958_n() + 0.5), (double)((double)e.getPos().func_177956_o() + 0.5), (double)((double)e.getPos().func_177952_p() + 0.5), (double)((double)this.lastX + 0.5), (double)((double)this.lastY + 0.5), (double)((double)this.lastZ + 0.5)) <= 4096.0) {
            this.needsLightUpdate = true;
        }
    }

    @SubscribeEvent
    public void renderWorld(RenderWorldLastEvent e) {
        if (this.renderChunkBounds || this.renderLightValues) {
            Minecraft mc = Minecraft.func_71410_x();
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-LMFrustumUtils.renderX), (double)(-LMFrustumUtils.renderY), (double)(-LMFrustumUtils.renderZ));
            FTBLibClient.pushMaxBrightness();
            GlStateManager.func_179147_l();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179089_o();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179092_a((int)516, (float)0.01f);
            if (this.renderChunkBounds) {
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
                int x = MathHelperLM.chunk((double)LMFrustumUtils.playerX);
                int z = MathHelperLM.chunk((double)LMFrustumUtils.playerZ);
                double d = 0.007;
                FTBLibClient.setTexture((ResourceLocation)CHUNK_BORDER_TEXTURE);
                this.chunkBorderRenderer.setTessellator(tessellator);
                this.chunkBorderRenderer.setUV(0.0, 0.0, 16.0, 256.0);
                ClaimedChunk chunk = FTBUWorldDataSP.getChunk(new ChunkDimPos(mc.field_71439_g.field_71093_bK, x, z));
                this.chunkBorderRenderer.setSize((double)x * 16.0 + d, 0.0, (double)z * 16.0 + d, (double)x * 16.0 + 16.0 - d, 256.0, (double)z * 16.0 + 16.0 - d);
                this.chunkBorderRenderer.color.setF(chunk == null ? -16736240 : (chunk.owner.hasTeam() ? chunk.owner.getTeam().getColor().color : 0), 0.6f);
                this.chunkBorderRenderer.renderSides();
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                GlStateManager.func_179129_p();
                GlStateManager.func_179090_x();
                for (int cz = z - 2; cz <= z + 2; ++cz) {
                    for (int cx = x - 2; cx <= x + 2; ++cx) {
                        chunk = FTBUWorldDataSP.getChunk(new ChunkDimPos(mc.field_71439_g.field_71093_bK, cx, cz));
                        this.chunkBorderRenderer.color.setF(chunk == null ? -16736240 : (chunk.owner.hasTeam() ? chunk.owner.getTeam().getColor().color : 0), 1.0f);
                        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                        buffer.func_181662_b((double)cx * 16.0 + 8.0, 0.0, (double)cz * 16.0 + 8.0).func_181666_a(this.chunkBorderRenderer.color.red, this.chunkBorderRenderer.color.green, this.chunkBorderRenderer.color.blue, 1.0f).func_181675_d();
                        buffer.func_181662_b((double)cx * 16.0 + 8.0, 256.0, (double)cz * 16.0 + 8.0).func_181666_a(this.chunkBorderRenderer.color.red, this.chunkBorderRenderer.color.green, this.chunkBorderRenderer.color.blue, 1.0f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                }
                GlStateManager.func_179089_o();
                GlStateManager.func_179098_w();
            }
            if (this.renderLightValues && LMFrustumUtils.playerY >= 0.0) {
                if ((double)this.lastY == -1.0 || MathHelperLM.distSq((double)LMFrustumUtils.playerX, (double)LMFrustumUtils.playerY, (double)LMFrustumUtils.playerZ, (double)((double)this.lastX + 0.5), (double)((double)this.lastY + 0.5), (double)((double)this.lastZ + 0.5)) >= MathHelperLM.SQRT_2 * 2.0) {
                    this.needsLightUpdate = true;
                }
                if (this.needsLightUpdate) {
                    this.needsLightUpdate = false;
                    this.lightList.clear();
                    this.lastX = MathHelperLM.floor((double)LMFrustumUtils.playerX);
                    this.lastY = MathHelperLM.floor((double)LMFrustumUtils.playerY);
                    this.lastZ = MathHelperLM.floor((double)LMFrustumUtils.playerZ);
                    for (int by = this.lastY - 20; by <= this.lastY + 3; ++by) {
                        for (int bx = this.lastX - 16; bx <= this.lastX + 16; ++bx) {
                            for (int bz = this.lastZ - 16; bz <= this.lastZ + 16; ++bz) {
                                BlockPos pos = new BlockPos(bx, by, bz);
                                Boolean b = FTBLib.canMobSpawn((World)mc.field_71441_e, (BlockPos)pos);
                                if (b == null) continue;
                                int lv = 0;
                                if (mc.field_71474_y.field_74330_P) {
                                    lv = mc.field_71441_e.func_175721_c(pos, true);
                                }
                                this.lightList.add(new MobSpawnPos(pos, b == Boolean.TRUE, lv));
                            }
                        }
                    }
                }
                if (!this.lightList.isEmpty()) {
                    double bx;
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    FTBLibClient.setTexture((ResourceLocation)(FTBUClient.light_value_texture_x.getAsBoolean() ? TEXTURE_LIGHT_VALUE_X : TEXTURE_LIGHT_VALUE_O));
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
                    for (MobSpawnPos pos : this.lightList) {
                        bx = pos.func_177958_n();
                        double by = (double)pos.func_177956_o() + 0.03;
                        double bz = pos.func_177952_p();
                        float green = pos.alwaysSpawns ? 0.2f : 1.0f;
                        buffer.func_181662_b(bx, by, bz).func_187315_a(0.0, 0.0).func_181666_a(1.0f, green, 0.2f, 1.0f).func_181675_d();
                        buffer.func_181662_b(bx, by, bz + 1.0).func_187315_a(0.0, 1.0).func_181666_a(1.0f, green, 0.2f, 1.0f).func_181675_d();
                        buffer.func_181662_b(bx + 1.0, by, bz + 1.0).func_187315_a(1.0, 1.0).func_181666_a(1.0f, green, 0.2f, 1.0f).func_181675_d();
                        buffer.func_181662_b(bx + 1.0, by, bz).func_187315_a(1.0, 0.0).func_181666_a(1.0f, green, 0.2f, 1.0f).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (mc.field_71474_y.field_74330_P) {
                        for (MobSpawnPos pos : this.lightList) {
                            double bz;
                            double by;
                            bx = (double)pos.func_177958_n() + 0.5;
                            if (!(MathHelperLM.distSq((double)LMFrustumUtils.playerX, (double)LMFrustumUtils.playerY, (double)LMFrustumUtils.playerZ, (double)bx, (double)(by = (double)pos.func_177956_o() + 0.14), (double)(bz = (double)pos.func_177952_p() + 0.5)) <= 144.0)) continue;
                            GlStateManager.func_179094_E();
                            GlStateManager.func_179137_b((double)bx, (double)by, (double)bz);
                            GlStateManager.func_179114_b((float)((float)(-Math.atan2(bz - LMFrustumUtils.playerZ, bx - LMFrustumUtils.playerX) * 180.0 / Math.PI) + 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                            GlStateManager.func_179114_b((float)40.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                            float scale = 0.03125f;
                            GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)1.0f);
                            String s = Integer.toString(pos.lightValue);
                            mc.field_71466_p.func_78276_b(s, -mc.field_71466_p.func_78256_a(s) / 2, -5, -1);
                            GlStateManager.func_179121_F();
                        }
                    }
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179103_j((int)7424);
            FTBLibClient.popMaxBrightness();
            GlStateManager.func_179121_F();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
        }
    }

    private static class MobSpawnPos
    extends BlockPos {
        public final boolean alwaysSpawns;
        public final int lightValue;

        public MobSpawnPos(BlockPos p, boolean b, int lv) {
            super((Vec3i)p);
            this.alwaysSpawns = b;
            this.lightValue = lv;
        }
    }
}

